/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtRegistry {
    private static Map<String, Set<String>> _extMap = new HashMap<String, Set<String>>();

    public static Map<String, Set<String>> getConflicts(ServletContext servletContext) throws Exception {
        String servletContextName = servletContext.getServletContextName();
        Set<String> files = ExtRegistry._readExtFiles(servletContext, "/WEB-INF/ext-" + servletContextName + ".xml");
        Iterator<Map.Entry<String, Set<String>>> itr = _extMap.entrySet().iterator();
        HashMap<String, Set<String>> conflicts = new HashMap<String, Set<String>>();
        while (itr.hasNext()) {
            Map.Entry<String, Set<String>> entry = itr.next();
            String curServletContextName = entry.getKey();
            Set<String> curFiles = entry.getValue();
            for (String file : files) {
                if (!curFiles.contains(file)) continue;
                TreeSet<String> conflictFiles = (TreeSet<String>)conflicts.get(curServletContextName);
                if (conflictFiles == null) {
                    conflictFiles = new TreeSet<String>();
                    conflicts.put(curServletContextName, conflictFiles);
                }
                conflictFiles.add(file);
            }
        }
        return conflicts;
    }

    public static Set<String> getServletContextNames() {
        return Collections.unmodifiableSet(_extMap.keySet());
    }

    public static boolean isRegistered(String servletContextName) {
        return _extMap.containsKey(servletContextName);
    }

    public static void registerExt(ServletContext servletContext) throws Exception {
        String servletContextName = servletContext.getServletContextName();
        Set<String> files = ExtRegistry._readExtFiles(servletContext, "/WEB-INF/ext-" + servletContextName + ".xml");
        _extMap.put(servletContextName, files);
    }

    public static void registerPortal(ServletContext servletContext) throws Exception {
        Set resourcePaths = servletContext.getResourcePaths("/WEB-INF");
        for (String resourcePath : resourcePaths) {
            if (!resourcePath.startsWith("/WEB-INF/ext-") || !resourcePath.endsWith("-ext.xml")) continue;
            String servletContextName = resourcePath.substring(13, resourcePath.length() - 4);
            Set<String> files = ExtRegistry._readExtFiles(servletContext, resourcePath);
            _extMap.put(servletContextName, files);
        }
    }

    private static Set<String> _readExtFiles(ServletContext servletContext, String resourcePath) throws Exception {
        TreeSet<String> files = new TreeSet<String>();
        Document document = SAXReaderUtil.read((InputStream)servletContext.getResourceAsStream(resourcePath));
        Element rootElement = document.getRootElement();
        Element filesElement = rootElement.element("files");
        List fileElements = filesElement.elements("file");
        for (Element fileElement : fileElements) {
            files.add(fileElement.getText());
        }
        return files;
    }
}

