/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.util.FileImpl;
import com.liferay.portal.xml.SAXReaderImpl;
import com.liferay.util.xml.DocUtil;
import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.AbstractJavaEntity;
import com.thoughtworks.qdox.model.Annotation;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.Type;
import jargs.gnu.CmdLineParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.DirectoryScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavadocFormatter {
    private static FileImpl _fileUtil = FileImpl.getInstance();
    private static SAXReaderImpl _saxReaderUtil = SAXReaderImpl.getInstance();
    private String _basedir = "./";
    private boolean _initializeMissingJavadocs;

    public static void main(String[] args) {
        try {
            new JavadocFormatter(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JavadocFormatter(String[] args) throws Exception {
        int n;
        int n2;
        String[] stringArray;
        CmdLineParser cmdLineParser = new CmdLineParser();
        CmdLineParser.Option limitOption = cmdLineParser.addStringOption("limit");
        CmdLineParser.Option initOption = cmdLineParser.addStringOption("init");
        cmdLineParser.parse(args);
        String limit = (String)cmdLineParser.getOptionValue(limitOption);
        String init = (String)cmdLineParser.getOptionValue(initOption);
        if (!init.startsWith("$")) {
            this._initializeMissingJavadocs = GetterUtil.getBoolean((String)init);
        }
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(this._basedir);
        ds.setExcludes(new String[]{"**\\classes\\**", "**\\portal-client\\**", "**\\tools\\**"});
        ArrayList<String> includes = new ArrayList<String>();
        if (Validator.isNotNull((String)limit) && !limit.startsWith("$")) {
            String[] limitArray;
            stringArray = limitArray = StringUtil.split((String)limit, (String)"/");
            n2 = limitArray.length;
            n = 0;
            while (n < n2) {
                String curLimit = stringArray[n];
                includes.add("**\\" + StringUtil.replace((String)curLimit, (String)".", (String)"\\") + "\\**\\*.java");
                includes.add("**\\" + curLimit + ".java");
                ++n;
            }
        } else {
            includes.add("**\\*.java");
        }
        ds.setIncludes(includes.toArray(new String[includes.size()]));
        ds.scan();
        String[] fileNames = ds.getIncludedFiles();
        stringArray = fileNames;
        n2 = fileNames.length;
        n = 0;
        while (n < n2) {
            String fileName = stringArray[n];
            fileName = StringUtil.replace((String)fileName, (String)"\\", (String)"/");
            this._format(fileName);
            ++n;
        }
    }

    private void _addClassCommentElement(Element rootElement, JavaClass javaClass) {
        Element commentElement = rootElement.addElement("comment");
        String comment = this._getCDATA((AbstractJavaEntity)javaClass);
        if (comment.startsWith("Copyright (c) 2000-2010 Liferay, Inc.")) {
            comment = "";
        }
        commentElement.addCDATA(comment);
    }

    private void _addDocletElements(Element parentElement, AbstractJavaEntity abstractJavaEntity, String name) throws Exception {
        DocletTag[] docletTags;
        DocletTag[] docletTagArray = docletTags = abstractJavaEntity.getTagsByName(name);
        int n = docletTags.length;
        int n2 = 0;
        while (n2 < n) {
            DocletTag docletTag = docletTagArray[n2];
            String value = docletTag.getValue();
            value = this._trimMultilineText(value);
            value = StringUtil.replace((String)value, (String)" </", (String)"</");
            if (!(name.equals("author") || name.equals("see") || name.equals("since"))) {
                name.equals("version");
            }
            Element element = parentElement.addElement(name);
            element.addCDATA(value);
            ++n2;
        }
        if (docletTags.length == 0 && name.equals("author")) {
            Element element = parentElement.addElement(name);
            element.addCDATA("Brian Wing Shun Chan");
        }
    }

    private String _addDocletTags(Element parentElement, String[] names, String indent) {
        StringBuilder sb = new StringBuilder();
        int maxNameLength = 0;
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name.length() >= maxNameLength) {
                List elements = parentElement.elements(name);
                for (Element element : elements) {
                    Element commentElement = element.element("comment");
                    String comment = null;
                    comment = commentElement != null ? commentElement.getText() : element.getText();
                    if (!name.equals("deprecated") && !this._initializeMissingJavadocs && Validator.isNull((String)comment)) continue;
                    maxNameLength = name.length();
                    break;
                }
            }
            ++n2;
        }
        int indentLength = this._getIndentLength(indent) + maxNameLength;
        String maxNameIndent = "\t ";
        int i = 0;
        while (i < maxNameLength) {
            maxNameIndent = String.valueOf(maxNameIndent) + " ";
            ++i;
        }
        maxNameIndent = StringUtil.replace((String)maxNameIndent, (String)"    ", (String)"\t");
        String[] stringArray2 = names;
        int n3 = names.length;
        int n4 = 0;
        while (n4 < n3) {
            String name = stringArray2[n4];
            String curNameIndent = " ";
            if (name.length() < maxNameLength) {
                int firstTab = 4 - name.length() % 4;
                int delta = maxNameLength + 1 - (name.length() + firstTab);
                if (delta == 0) {
                    curNameIndent = "\t";
                } else if (delta < 0) {
                    int i2 = 0;
                    while (i2 < maxNameLength - name.length()) {
                        curNameIndent = String.valueOf(curNameIndent) + " ";
                        ++i2;
                    }
                } else if (delta > 0) {
                    int numberOfSpaces;
                    curNameIndent = "\t";
                    int numberOfTabs = delta / 4;
                    if (numberOfTabs > 0) {
                        int i3 = 0;
                        while (i3 < numberOfTabs) {
                            curNameIndent = String.valueOf(curNameIndent) + "\t";
                            ++i3;
                        }
                    }
                    if ((numberOfSpaces = delta % 4) > 0) {
                        int i4 = 0;
                        while (i4 < numberOfSpaces) {
                            curNameIndent = String.valueOf(curNameIndent) + " ";
                            ++i4;
                        }
                    }
                }
            }
            List elements = parentElement.elements(name);
            for (Element element : elements) {
                Element commentElement = element.element("comment");
                String comment = null;
                comment = commentElement != null ? commentElement.getText() : element.getText();
                if (!name.equals("deprecated") && !this._initializeMissingJavadocs && Validator.isNull((String)comment)) continue;
                sb.append(indent);
                sb.append(" * @");
                sb.append(name);
                if (Validator.isNotNull((String)comment) || commentElement != null) {
                    sb.append(curNameIndent);
                }
                if (commentElement != null) {
                    comment = String.valueOf(element.elementText("name")) + " " + comment;
                }
                comment = StringUtil.wrap((String)comment, (int)(80 - indentLength - 5), (String)"\n");
                comment = comment.trim();
                comment = StringUtil.replace((String)comment, (String)"\n", (String)("\n" + indent + " *" + maxNameIndent));
                while (comment.contains(" \n")) {
                    comment = StringUtil.replace((String)comment, (String)" \n", (String)"\n");
                }
                while (comment.startsWith("\n")) {
                    comment = comment.substring(1, comment.length());
                }
                sb.append(comment);
                sb.append("\n");
            }
            ++n4;
        }
        return sb.toString();
    }

    private void _addFieldElement(Element rootElement, JavaField javaField) throws Exception {
        Element fieldElement = rootElement.addElement("field");
        DocUtil.add((Element)fieldElement, (String)"name", (String)javaField.getName());
        Element commentElement = fieldElement.addElement("comment");
        commentElement.addCDATA(this._getCDATA((AbstractJavaEntity)javaField));
        this._addDocletElements(fieldElement, (AbstractJavaEntity)javaField, "version");
        this._addDocletElements(fieldElement, (AbstractJavaEntity)javaField, "see");
        this._addDocletElements(fieldElement, (AbstractJavaEntity)javaField, "since");
        this._addDocletElements(fieldElement, (AbstractJavaEntity)javaField, "deprecated");
    }

    private void _addMethodElement(Element rootElement, JavaMethod javaMethod) throws Exception {
        Element methodElement = rootElement.addElement("method");
        DocUtil.add((Element)methodElement, (String)"name", (String)javaMethod.getName());
        Element commentElement = methodElement.addElement("comment");
        commentElement.addCDATA(this._getCDATA((AbstractJavaEntity)javaMethod));
        this._addDocletElements(methodElement, (AbstractJavaEntity)javaMethod, "version");
        this._addParamElements(methodElement, javaMethod);
        this._addReturnElement(methodElement, javaMethod);
        this._addThrowsElements(methodElement, javaMethod);
        this._addDocletElements(methodElement, (AbstractJavaEntity)javaMethod, "see");
        this._addDocletElements(methodElement, (AbstractJavaEntity)javaMethod, "since");
        this._addDocletElements(methodElement, (AbstractJavaEntity)javaMethod, "deprecated");
    }

    private void _addParamElement(Element methodElement, JavaParameter javaParameter, DocletTag[] paramDocletTags) {
        String name = javaParameter.getName();
        String type = javaParameter.getType().getValue();
        String value = null;
        DocletTag[] docletTagArray = paramDocletTags;
        int n = paramDocletTags.length;
        int n2 = 0;
        while (n2 < n) {
            DocletTag paramDocletTag = docletTagArray[n2];
            String curValue = paramDocletTag.getValue();
            if (curValue.startsWith(name)) {
                value = curValue;
                break;
            }
            ++n2;
        }
        Element paramElement = methodElement.addElement("param");
        DocUtil.add((Element)paramElement, (String)"name", (String)name);
        DocUtil.add((Element)paramElement, (String)"type", (String)type);
        if (value != null) {
            value = value.substring(name.length());
        }
        value = this._trimMultilineText(value);
        Element commentElement = paramElement.addElement("comment");
        commentElement.addCDATA(value);
    }

    private void _addParamElements(Element methodElement, JavaMethod javaMethod) {
        JavaParameter[] javaParameters = javaMethod.getParameters();
        DocletTag[] paramDocletTags = javaMethod.getTagsByName("param");
        JavaParameter[] javaParameterArray = javaParameters;
        int n = javaParameters.length;
        int n2 = 0;
        while (n2 < n) {
            JavaParameter javaParameter = javaParameterArray[n2];
            this._addParamElement(methodElement, javaParameter, paramDocletTags);
            ++n2;
        }
    }

    private void _addReturnElement(Element methodElement, JavaMethod javaMethod) throws Exception {
        Type returns = javaMethod.getReturns();
        if (returns == null || returns.getValue().equals("void")) {
            return;
        }
        this._addDocletElements(methodElement, (AbstractJavaEntity)javaMethod, "return");
    }

    private void _addThrowsElement(Element methodElement, Type exception, DocletTag[] throwsDocletTags) {
        String name = exception.getJavaClass().getName();
        String value = null;
        DocletTag[] docletTagArray = throwsDocletTags;
        int n = throwsDocletTags.length;
        int n2 = 0;
        while (n2 < n) {
            DocletTag throwsDocletTag = docletTagArray[n2];
            String curValue = throwsDocletTag.getValue();
            if (curValue.startsWith(name)) {
                value = curValue;
                break;
            }
            ++n2;
        }
        Element throwsElement = methodElement.addElement("throws");
        DocUtil.add((Element)throwsElement, (String)"name", (String)name);
        DocUtil.add((Element)throwsElement, (String)"type", (String)exception.getValue());
        if (value != null) {
            value = value.substring(name.length());
        }
        value = this._trimMultilineText(value);
        Element commentElement = throwsElement.addElement("comment");
        commentElement.addCDATA(this._getCDATA(value));
    }

    private void _addThrowsElements(Element methodElement, JavaMethod javaMethod) {
        Type[] exceptions = javaMethod.getExceptions();
        DocletTag[] throwsDocletTags = javaMethod.getTagsByName("throws");
        Type[] typeArray = exceptions;
        int n = exceptions.length;
        int n2 = 0;
        while (n2 < n) {
            Type exception = typeArray[n2];
            this._addThrowsElement(methodElement, exception, throwsDocletTags);
            ++n2;
        }
    }

    private String _getCDATA(AbstractJavaEntity abstractJavaEntity) {
        return this._getCDATA(abstractJavaEntity.getComment());
    }

    private String _getCDATA(String cdata) {
        if (cdata == null) {
            return "";
        }
        cdata = cdata.replaceAll("(?s)\\s*<(p|pre|[ou]l)>\\s*(.*?)\\s*</\\1>\\s*", "\n\n<$1>\n$2\n</$1>\n\n");
        cdata = cdata.replaceAll("(?s)\\s*<li>\\s*(.*?)\\s*</li>\\s*", "\n<li>\n$1\n</li>\n");
        cdata = StringUtil.replace((String)cdata, (String)"</li>\n\n<li>", (String)"</li>\n<li>");
        cdata = cdata.replaceAll("\n\\s+\n", "\n\n");
        cdata = cdata.replaceAll(" +", " ");
        Pattern pattern = Pattern.compile("(^.*?(?=\n\n|$)+|(?<=<p>\n).*?(?=\n</p>))", 32);
        Matcher matcher = pattern.matcher(cdata);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String trimmed = this._trimMultilineText(matcher.group());
            matcher.appendReplacement(sb, trimmed);
        }
        matcher.appendTail(sb);
        cdata = sb.toString();
        return cdata.trim();
    }

    private String _getFieldKey(Element fieldElement) {
        return fieldElement.elementText("name");
    }

    private String _getFieldKey(JavaField javaField) {
        return javaField.getName();
    }

    private int _getIndentLength(String indent) {
        int indentLength = 0;
        char[] cArray = indent.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            indentLength = c == '\t' ? (indentLength += 4) : ++indentLength;
            ++n2;
        }
        return indentLength;
    }

    private JavaClass _getJavaClass(String fileName, Reader reader) throws Exception {
        int pos = fileName.indexOf("src/");
        if (pos == -1) {
            pos = fileName.indexOf("test/");
        }
        if (pos == -1) {
            throw new RuntimeException(fileName);
        }
        pos = fileName.indexOf("/", pos);
        String srcFile = fileName.substring(pos + 1, fileName.length());
        String className = StringUtil.replace((String)srcFile.substring(0, srcFile.length() - 5), (String)"/", (String)".");
        JavaDocBuilder builder = new JavaDocBuilder();
        if (reader == null) {
            File file = new File(fileName);
            if (!file.exists()) {
                return null;
            }
            builder.addSource(file);
        } else {
            builder.addSource(reader);
        }
        return builder.getClassByName(className);
    }

    private String _getJavaClassComment(Element rootElement, JavaClass javaClass) {
        String docletTags;
        StringBuilder sb = new StringBuilder();
        String indent = "";
        sb.append("/**\n");
        String comment = rootElement.elementText("comment");
        if (this._initializeMissingJavadocs || Validator.isNotNull((String)comment)) {
            sb.append(this._wrapText(comment, indent));
        }
        if ((docletTags = this._addDocletTags(rootElement, new String[]{"author", "version", "see", "since", "serial", "deprecated"}, indent)).length() > 0) {
            if (this._initializeMissingJavadocs || Validator.isNotNull((String)comment)) {
                sb.append(" *\n");
            }
            sb.append(docletTags);
        }
        sb.append(" */\n");
        return sb.toString();
    }

    private Document _getJavadocDocument(JavaClass javaClass) throws Exception {
        JavaField[] javaFields;
        JavaMethod[] javaMethods;
        Element rootElement = _saxReaderUtil.createElement("javadoc");
        Document document = _saxReaderUtil.createDocument(rootElement);
        DocUtil.add((Element)rootElement, (String)"name", (String)javaClass.getName());
        DocUtil.add((Element)rootElement, (String)"type", (String)javaClass.getFullyQualifiedName());
        this._addClassCommentElement(rootElement, javaClass);
        this._addDocletElements(rootElement, (AbstractJavaEntity)javaClass, "author");
        this._addDocletElements(rootElement, (AbstractJavaEntity)javaClass, "version");
        this._addDocletElements(rootElement, (AbstractJavaEntity)javaClass, "see");
        this._addDocletElements(rootElement, (AbstractJavaEntity)javaClass, "since");
        this._addDocletElements(rootElement, (AbstractJavaEntity)javaClass, "serial");
        this._addDocletElements(rootElement, (AbstractJavaEntity)javaClass, "deprecated");
        JavaMethod[] javaMethodArray = javaMethods = javaClass.getMethods();
        int n = javaMethods.length;
        int n2 = 0;
        while (n2 < n) {
            JavaMethod javaMethod = javaMethodArray[n2];
            this._addMethodElement(rootElement, javaMethod);
            ++n2;
        }
        JavaField[] javaFieldArray = javaFields = javaClass.getFields();
        int n3 = javaFields.length;
        n = 0;
        while (n < n3) {
            JavaField javaField = javaFieldArray[n];
            this._addFieldElement(rootElement, javaField);
            ++n;
        }
        return document;
    }

    private String _getJavaFieldComment(String[] lines, Map<String, Element> fieldElementsMap, JavaField javaField) {
        String docletTags;
        String fieldKey = this._getFieldKey(javaField);
        Element fieldElement = fieldElementsMap.get(fieldKey);
        if (fieldElement == null) {
            return null;
        }
        String line = lines[javaField.getLineNumber() - 1];
        String indent = "";
        char[] cArray = line.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Character.isWhitespace(c)) break;
            indent = String.valueOf(indent) + c;
            ++n2;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(indent);
        sb.append("/**\n");
        String comment = fieldElement.elementText("comment");
        if (this._initializeMissingJavadocs || Validator.isNotNull((String)comment)) {
            sb.append(this._wrapText(comment, indent));
        }
        if ((docletTags = this._addDocletTags(fieldElement, new String[]{"version", "see", "since", "deprecated"}, indent)).length() > 0) {
            if (this._initializeMissingJavadocs || Validator.isNotNull((String)comment)) {
                sb.append(indent);
                sb.append(" *\n");
            }
            sb.append(docletTags);
        }
        sb.append(indent);
        sb.append(" */\n");
        if (!this._initializeMissingJavadocs && Validator.isNull((String)comment) && Validator.isNull((String)docletTags)) {
            return null;
        }
        return sb.toString();
    }

    private String _getJavaMethodComment(String[] lines, Map<String, Element> methodElementsMap, JavaMethod javaMethod) {
        String docletTags;
        String methodKey = this._getMethodKey(javaMethod);
        Element methodElement = methodElementsMap.get(methodKey);
        if (methodElement == null) {
            return null;
        }
        String line = lines[javaMethod.getLineNumber() - 1];
        String indent = "";
        char[] cArray = line.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Character.isWhitespace(c)) break;
            indent = String.valueOf(indent) + c;
            ++n2;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(indent);
        sb.append("/**\n");
        String comment = methodElement.elementText("comment");
        if (this._initializeMissingJavadocs || Validator.isNotNull((String)comment)) {
            sb.append(this._wrapText(comment, indent));
        }
        if ((docletTags = this._addDocletTags(methodElement, new String[]{"version", "param", "return", "throws", "see", "since", "deprecated"}, indent)).length() > 0) {
            if (this._initializeMissingJavadocs || Validator.isNotNull((String)comment)) {
                sb.append(indent);
                sb.append(" *\n");
            }
            sb.append(docletTags);
        }
        sb.append(indent);
        sb.append(" */\n");
        if (!this._initializeMissingJavadocs && Validator.isNull((String)comment) && Validator.isNull((String)docletTags)) {
            return null;
        }
        return sb.toString();
    }

    private String _getMethodKey(Element methodElement) {
        StringBuilder sb = new StringBuilder();
        sb.append(methodElement.elementText("name"));
        sb.append("(");
        List paramElements = methodElement.elements("param");
        for (Element paramElement : paramElements) {
            sb.append(paramElement.elementText("name"));
            sb.append("|");
            sb.append(paramElement.elementText("type"));
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    private String _getMethodKey(JavaMethod javaMethod) {
        JavaParameter[] javaParameters;
        StringBuilder sb = new StringBuilder();
        sb.append(javaMethod.getName());
        sb.append("(");
        JavaParameter[] javaParameterArray = javaParameters = javaMethod.getParameters();
        int n = javaParameters.length;
        int n2 = 0;
        while (n2 < n) {
            JavaParameter javaParameter = javaParameterArray[n2];
            sb.append(javaParameter.getName());
            sb.append("|");
            sb.append(javaParameter.getType().getValue());
            sb.append(",");
            ++n2;
        }
        sb.append(")");
        return sb.toString();
    }

    private boolean _isGenerated(String content) {
        return content.contains("* @generated");
    }

    private String _removeJavadocFromJava(JavaClass javaClass, String content) {
        JavaField[] javaFields;
        JavaMethod[] javaMethods;
        HashSet<Integer> lineNumbers = new HashSet<Integer>();
        lineNumbers.add(this._getJavaClassLineNumber(javaClass));
        JavaMethod[] javaMethodArray = javaMethods = javaClass.getMethods();
        int n = javaMethods.length;
        int n2 = 0;
        while (n2 < n) {
            JavaMethod javaMethod = javaMethodArray[n2];
            lineNumbers.add(javaMethod.getLineNumber());
            ++n2;
        }
        JavaField[] javaFieldArray = javaFields = javaClass.getFields();
        int n3 = javaFields.length;
        n = 0;
        while (n < n3) {
            JavaField javaField = javaFieldArray[n];
            lineNumbers.add(javaField.getLineNumber());
            ++n;
        }
        String[] lines = StringUtil.split((String)content, (String)"\n");
        Iterator iterator = lineNumbers.iterator();
        block2: while (iterator.hasNext()) {
            int pos;
            String line;
            int lineNumber = (Integer)iterator.next();
            if (lineNumber == 0 || !(line = lines[pos = lineNumber - 2].trim()).endsWith("*/")) continue;
            while (true) {
                lines[pos] = null;
                if (line.startsWith("/**")) continue block2;
                line = lines[--pos].trim();
            }
        }
        StringBuilder sb = new StringBuilder(content.length());
        String[] stringArray = lines;
        int n4 = lines.length;
        int n5 = 0;
        while (n5 < n4) {
            String line = stringArray[n5];
            if (line != null) {
                sb.append(line);
                sb.append("\n");
            }
            ++n5;
        }
        return sb.toString().trim();
    }

    private void _format(String fileName) throws Exception {
        FileInputStream fis = new FileInputStream(new File(String.valueOf(this._basedir) + fileName));
        byte[] bytes = new byte[fis.available()];
        fis.read(bytes);
        fis.close();
        String originalContent = new String(bytes);
        if (!fileName.endsWith("JavadocFormatter.java") && this._isGenerated(originalContent)) {
            return;
        }
        JavaClass javaClass = this._getJavaClass(fileName, (Reader)new UnsyncStringReader(originalContent));
        String javadocLessContent = this._removeJavadocFromJava(javaClass, originalContent);
        Document document = this._getJavadocDocument(javaClass);
        this._updateJavaFromDocument(fileName, originalContent, javadocLessContent, document);
    }

    private String _formatInlines(String text) {
        text = text.replaceAll("(?i)(?<!<code>)(null|false|true)", "<code>$1</code>");
        return text;
    }

    private int _getJavaClassLineNumber(JavaClass javaClass) {
        int lineNumber = javaClass.getLineNumber();
        Annotation[] annotations = javaClass.getAnnotations();
        if (annotations.length == 0) {
            return lineNumber;
        }
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            int annotationLineNumber = annotation.getLineNumber();
            if (annotation.getPropertyMap().isEmpty()) {
                --annotationLineNumber;
            }
            if (annotationLineNumber < lineNumber) {
                lineNumber = annotationLineNumber;
            }
            ++n2;
        }
        return lineNumber;
    }

    private String _trimMultilineText(String text) {
        Object[] textArray = StringUtil.split((String)text, (String)"\n");
        int i = 0;
        while (i < textArray.length) {
            textArray[i] = ((String)textArray[i]).trim();
            ++i;
        }
        return StringUtil.merge((Object[])textArray, (String)" ");
    }

    private void _updateJavaFromDocument(String fileName, String originalContent, String javadocLessContent, Document document) throws Exception {
        JavaField[] javaFields;
        String[] lines = StringUtil.split((String)javadocLessContent, (String)"\n");
        JavaClass javaClass = this._getJavaClass(fileName, (Reader)new UnsyncStringReader(javadocLessContent));
        Element rootElement = document.getRootElement();
        TreeMap<Integer, String> commentsMap = new TreeMap<Integer, String>();
        commentsMap.put(this._getJavaClassLineNumber(javaClass), this._getJavaClassComment(rootElement, javaClass));
        HashMap<String, Element> methodElementsMap = new HashMap<String, Element>();
        List methodElements = rootElement.elements("method");
        for (Element methodElement : methodElements) {
            String methodKey = this._getMethodKey(methodElement);
            methodElementsMap.put(methodKey, methodElement);
        }
        JavaMethod[] javaMethods = javaClass.getMethods();
        JavaMethod[] javaMethodArray = javaMethods;
        int n = javaMethods.length;
        int methodKey = 0;
        while (methodKey < n) {
            JavaMethod javaMethod = javaMethodArray[methodKey];
            if (!commentsMap.containsKey(javaMethod.getLineNumber())) {
                commentsMap.put(javaMethod.getLineNumber(), this._getJavaMethodComment(lines, methodElementsMap, javaMethod));
            }
            ++methodKey;
        }
        HashMap<String, Element> fieldElementsMap = new HashMap<String, Element>();
        List fieldElements = rootElement.elements("field");
        for (Element fieldElement : fieldElements) {
            String fieldKey = this._getFieldKey(fieldElement);
            fieldElementsMap.put(fieldKey, fieldElement);
        }
        JavaField[] javaFieldArray = javaFields = javaClass.getFields();
        int n2 = javaFields.length;
        int fieldKey = 0;
        while (fieldKey < n2) {
            JavaField javaField = javaFieldArray[fieldKey];
            if (!commentsMap.containsKey(javaField.getLineNumber())) {
                commentsMap.put(javaField.getLineNumber(), this._getJavaFieldComment(lines, fieldElementsMap, javaField));
            }
            ++fieldKey;
        }
        StringBuilder sb = new StringBuilder(javadocLessContent.length());
        int lineNumber = 1;
        while (lineNumber <= lines.length) {
            String line = lines[lineNumber - 1];
            String comments = (String)commentsMap.get(lineNumber);
            if (comments != null) {
                sb.append(comments);
            }
            sb.append(line);
            sb.append("\n");
            ++lineNumber;
        }
        String formattedContent = sb.toString().trim();
        if (!originalContent.equals(formattedContent)) {
            File file = new File(String.valueOf(this._basedir) + fileName);
            _fileUtil.write(file, formattedContent.getBytes());
            System.out.println("Writing " + file);
        }
    }

    private String _wrapText(String text, String indent) {
        int indentLength = this._getIndentLength(indent);
        if (text.contains("<pre>")) {
            Pattern pattern = Pattern.compile("(?<=^|</pre>).+?(?=$|<pre>)", 32);
            Matcher matcher = pattern.matcher(text);
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                String wrapped = this._formatInlines(matcher.group());
                wrapped = StringUtil.wrap((String)wrapped, (int)(80 - indentLength - 3), (String)"\n");
                matcher.appendReplacement(sb, wrapped);
            }
            matcher.appendTail(sb);
            sb.append("\n");
            text = sb.toString();
        } else {
            text = this._formatInlines(text);
            text = StringUtil.wrap((String)text, (int)(80 - indentLength - 3), (String)"\n");
        }
        text = text.replaceAll("(?m)^", String.valueOf(indent) + " * ");
        text = text.replaceAll("(?m) +$", "");
        return text;
    }
}

