/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodInvoker;
import com.liferay.portal.kernel.util.MethodWrapper;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalInstances;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TunnelServlet
extends HttpServlet {
    private static Log _log = LogFactoryUtil.getLog(TunnelServlet.class);

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ObjectInputStream ois = new ObjectInputStream((InputStream)request.getInputStream());
        Object returnObj = null;
        try {
            ObjectValuePair ovp = (ObjectValuePair)ois.readObject();
            HttpPrincipal httpPrincipal = (HttpPrincipal)ovp.getKey();
            Object ovpValue = ovp.getValue();
            MethodHandler methodHandler = null;
            MethodWrapper methodWrapper = null;
            if (ovpValue instanceof MethodHandler) {
                methodHandler = (MethodHandler)ovpValue;
            } else {
                methodWrapper = (MethodWrapper)ovpValue;
            }
            if (methodHandler != null ? !this.isValidRequest(methodHandler.getClassName()) : !this.isValidRequest(methodWrapper.getClassName())) {
                return;
            }
            long companyId = PortalInstances.getCompanyId(request);
            if (Validator.isNotNull((String)httpPrincipal.getLogin())) {
                User user = null;
                try {
                    user = UserLocalServiceUtil.getUserByEmailAddress((long)companyId, (String)httpPrincipal.getLogin());
                }
                catch (NoSuchUserException noSuchUserException) {}
                if (user == null) {
                    try {
                        user = UserLocalServiceUtil.getUserByScreenName((long)companyId, (String)httpPrincipal.getLogin());
                    }
                    catch (NoSuchUserException noSuchUserException) {}
                }
                if (user == null) {
                    try {
                        user = UserLocalServiceUtil.getUserById((long)GetterUtil.getLong((String)httpPrincipal.getLogin()));
                    }
                    catch (NoSuchUserException noSuchUserException) {}
                }
                if (user != null) {
                    PrincipalThreadLocal.setName((long)user.getUserId());
                    PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user, (boolean)true);
                    PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
                }
            }
            if (returnObj == null) {
                returnObj = methodHandler != null ? methodHandler.invoke(true) : MethodInvoker.invoke((MethodWrapper)methodWrapper);
            }
        }
        catch (InvocationTargetException ite) {
            returnObj = ite.getCause();
            if (!(returnObj instanceof PortalException)) {
                ite.printStackTrace();
                returnObj = new SystemException();
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (returnObj != null) {
            ObjectOutputStream oos = new ObjectOutputStream((OutputStream)response.getOutputStream());
            oos.writeObject(returnObj);
            oos.flush();
            oos.close();
        }
    }

    protected boolean isValidRequest(String className) {
        return className.contains(".service.") && className.endsWith("ServiceUtil") && !className.endsWith("LocalServiceUtil");
    }
}

