/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.scheduler.SchedulerEngineUtil;
import com.liferay.portal.kernel.scheduler.SchedulerEntry;
import com.liferay.portal.kernel.scheduler.SchedulerEntryImpl;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.TriggerType;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.search.lucene.LuceneIndexer;
import com.liferay.portal.search.lucene.messaging.CleanUpMessageListener;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;

public class LuceneServlet
extends HttpServlet {
    private static final String THREAD_NAME = LuceneIndexer.class.getName();
    private static final int THREAD_PRIORITY = 1;
    private static final int THREAD_TIMEOUT = 60000;
    private static Log _log = LogFactoryUtil.getLog(LuceneServlet.class);
    private List<ObjectValuePair<LuceneIndexer, Thread>> _indexers = new ArrayList<ObjectValuePair<LuceneIndexer, Thread>>();

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        long[] companyIds = PortalInstances.getCompanyIds();
        int i = 0;
        while (i < companyIds.length) {
            long companyId = companyIds[i];
            if (GetterUtil.getBoolean((String)PropsUtil.get("index.on.startup"))) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)"Indexing Lucene on startup");
                }
                LuceneIndexer indexer = new LuceneIndexer(companyId);
                Thread indexerThread = null;
                if (GetterUtil.getBoolean((String)PropsUtil.get("index.with.thread"))) {
                    indexerThread = new Thread((Runnable)indexer, String.valueOf(THREAD_NAME) + "." + companyId);
                    indexerThread.setPriority(1);
                    indexerThread.start();
                } else {
                    indexer.reindex();
                }
                this._indexers.add((ObjectValuePair<LuceneIndexer, Thread>)new ObjectValuePair((Object)indexer, indexerThread));
            }
            if (PropsValues.LUCENE_STORE_JDBC_AUTO_CLEAN_UP_ENABLED) {
                SchedulerEntryImpl schedulerEntry = new SchedulerEntryImpl();
                schedulerEntry.setEventListenerClass(CleanUpMessageListener.class.getName());
                schedulerEntry.setTimeUnit(TimeUnit.MINUTE);
                schedulerEntry.setTriggerType(TriggerType.SIMPLE);
                schedulerEntry.setTriggerValue(PropsValues.LUCENE_STORE_JDBC_AUTO_CLEAN_UP_INTERVAL);
                try {
                    SchedulerEngineUtil.schedule((SchedulerEntry)schedulerEntry, (ClassLoader)PortalClassLoaderUtil.getClassLoader());
                }
                catch (Exception e) {
                    _log.error((Object)e, (Throwable)e);
                }
            }
            ++i;
        }
    }

    public void destroy() {
        int i = 0;
        while (i < this._indexers.size()) {
            ObjectValuePair<LuceneIndexer, Thread> ovp = this._indexers.get(i);
            LuceneIndexer indexer = (LuceneIndexer)ovp.getKey();
            Thread indexerThread = (Thread)ovp.getValue();
            if (indexer != null && !indexer.isFinished() && indexerThread != null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"Waiting for Lucene indexer to shutdown");
                }
                indexer.halt();
                try {
                    indexerThread.join(60000L);
                }
                catch (InterruptedException e) {
                    _log.error((Object)"Lucene indexer shutdown interrupted", (Throwable)e);
                }
            }
            ++i;
        }
        super.destroy();
    }
}

