/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.permission;

import com.liferay.portal.NoSuchResourceException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.ResourceLocalServiceUtil;
import com.liferay.portal.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.service.permission.GroupPermissionUtil;
import com.liferay.portal.service.permission.LayoutPermission;
import com.liferay.portal.util.PropsValues;

public class LayoutPermissionImpl
implements LayoutPermission {
    public void check(PermissionChecker permissionChecker, Layout layout, String actionId) throws PortalException, SystemException {
        if (!this.contains(permissionChecker, layout, actionId)) {
            throw new PrincipalException();
        }
    }

    public void check(PermissionChecker permissionChecker, long groupId, boolean privateLayout, long layoutId, String actionId) throws PortalException, SystemException {
        if (!this.contains(permissionChecker, groupId, privateLayout, layoutId, actionId)) {
            throw new PrincipalException();
        }
    }

    public void check(PermissionChecker permissionChecker, long plid, String actionId) throws PortalException, SystemException {
        if (!this.contains(permissionChecker, plid, actionId)) {
            throw new PrincipalException();
        }
    }

    public boolean contains(PermissionChecker permissionChecker, Layout layout, String actionId) throws PortalException, SystemException {
        Group group;
        if ((layout.isPrivateLayout() && !PropsValues.LAYOUT_USER_PRIVATE_LAYOUTS_MODIFIABLE || layout.isPublicLayout() && !PropsValues.LAYOUT_USER_PUBLIC_LAYOUTS_MODIFIABLE) && actionId.equals("UPDATE") && (group = GroupLocalServiceUtil.getGroup((long)layout.getGroupId())).isUser()) {
            return false;
        }
        if (GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)layout.getGroupId(), (String)"MANAGE_LAYOUTS")) {
            return true;
        }
        try {
            if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
                if (ResourcePermissionLocalServiceUtil.getResourcePermissionsCount((long)layout.getCompanyId(), (String)Layout.class.getName(), (int)4, (String)String.valueOf(layout.getPlid())) == 0) {
                    throw new NoSuchResourceException();
                }
            } else {
                ResourceLocalServiceUtil.getResource((long)layout.getCompanyId(), (String)Layout.class.getName(), (int)4, (String)String.valueOf(layout.getPlid()));
            }
        }
        catch (NoSuchResourceException noSuchResourceException) {
            boolean addCommunityPermission = true;
            boolean addGuestPermission = true;
            if (layout.isPrivateLayout()) {
                addGuestPermission = false;
            }
            ResourceLocalServiceUtil.addResources((long)layout.getCompanyId(), (long)layout.getGroupId(), (long)0L, (String)Layout.class.getName(), (long)layout.getPlid(), (boolean)false, (boolean)addCommunityPermission, (boolean)addGuestPermission);
        }
        return permissionChecker.hasPermission(layout.getGroupId(), Layout.class.getName(), layout.getPlid(), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long groupId, boolean privateLayout, long layoutId, String actionId) throws PortalException, SystemException {
        if (layoutId == 0L) {
            return GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)groupId, (String)"MANAGE_LAYOUTS");
        }
        Layout layout = LayoutLocalServiceUtil.getLayout((long)groupId, (boolean)privateLayout, (long)layoutId);
        return this.contains(permissionChecker, layout, actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long plid, String actionId) throws PortalException, SystemException {
        Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
        return this.contains(permissionChecker, layout, actionId);
    }
}

