/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.model.Address;
import com.liferay.portal.model.EmailAddress;
import com.liferay.portal.model.Phone;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroupRole;
import com.liferay.portal.model.Website;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserServiceUtil;
import com.liferay.portal.service.http.TunnelUtil;
import com.liferay.portlet.announcements.model.AnnouncementsDelivery;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(UserServiceHttp.class);

    public static void addGroupUsers(HttpPrincipal httpPrincipal, long groupId, long[] userIds) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserServiceUtil.class.getName(), "addGroupUsers", new Class[]{Long.TYPE, long[].class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, userIds});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void addOrganizationUsers(HttpPrincipal httpPrincipal, long organizationId, long[] userIds) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserServiceUtil.class.getName(), "addOrganizationUsers", new Class[]{Long.TYPE, long[].class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{organizationId, userIds});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void addPasswordPolicyUsers(HttpPrincipal httpPrincipal, long passwordPolicyId, long[] userIds) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserServiceUtil.class.getName(), "addPasswordPolicyUsers", new Class[]{Long.TYPE, long[].class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{passwordPolicyId, userIds});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void addRoleUsers(HttpPrincipal httpPrincipal, long roleId, long[] userIds) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserServiceUtil.class.getName(), "addRoleUsers", new Class[]{Long.TYPE, long[].class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{roleId, userIds});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void addTeamUsers(HttpPrincipal httpPrincipal, long teamId, long[] userIds) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserServiceUtil.class.getName(), "addTeamUsers", new Class[]{Long.TYPE, long[].class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{teamId, userIds});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void addUserGroupUsers(HttpPrincipal httpPrincipal, long userGroupId, long[] userIds) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserServiceUtil.class.getName(), "addUserGroupUsers", new Class[]{Long.TYPE, long[].class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userGroupId, userIds});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static User addUser(HttpPrincipal httpPrincipal, long companyId, boolean autoPassword, String password1, String password2, boolean autoScreenName, String screenName, String emailAddress, long facebookId, String openId, Locale locale, String firstName, String middleName, String lastName, int prefixId, int suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String jobTitle, long[] groupIds, long[] organizationIds, long[] roleIds, long[] userGroupIds, boolean sendEmail, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserServiceUtil.class.getName(), "addUser", new Class[]{Long.TYPE, Boolean.TYPE, String.class, String.class, Boolean.TYPE, String.class, String.class, Long.TYPE, String.class, Locale.class, String.class, String.class, String.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, String.class, long[].class, long[].class, long[].class, long[].class, Boolean.TYPE, ServiceContext.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, autoPassword, password1, password2, autoScreenName, screenName, emailAddress, facebookId, openId, locale, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, groupIds, organizationIds, roleIds, userGroupIds, sendEmail, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (User)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static User addUser(HttpPrincipal httpPrincipal, long companyId, boolean autoPassword, String password1, String password2, boolean autoScreenName, String screenName, String emailAddress, long facebookId, String openId, Locale locale, String firstName, String middleName, String lastName, int prefixId, int suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String jobTitle, long[] groupIds, long[] organizationIds, long[] roleIds, long[] userGroupIds, boolean sendEmail, List<Address> addresses, List<EmailAddress> emailAddresses, List<Phone> phones, List<Website> websites, List<AnnouncementsDelivery> announcementsDelivers, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserServiceUtil.class.getName(), "addUser", new Class[]{Long.TYPE, Boolean.TYPE, String.class, String.class, Boolean.TYPE, String.class, String.class, Long.TYPE, String.class, Locale.class, String.class, String.class, String.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, String.class, long[].class, long[].class, long[].class, long[].class, Boolean.TYPE, List.class, List.class, List.class, List.class, List.class, ServiceContext.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, autoPassword, password1, password2, autoScreenName, screenName, emailAddress, facebookId, openId, locale, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, groupIds, organizationIds, roleIds, userGroupIds, sendEmail, addresses, emailAddresses, phones, websites, announcementsDelivers, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (User)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deletePortrait(HttpPrincipal httpPrincipal, long userId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserServiceUtil.class.getName(), "deletePortrait", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteRoleUser(HttpPrincipal httpPrincipal, long roleId, long userId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserServiceUtil.class.getName(), "deleteRoleUser", new Class[]{Long.TYPE, Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{roleId, userId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteUser(HttpPrincipal httpPrincipal, long userId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserServiceUtil.class.getName(), "deleteUser", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static long getDefaultUserId(HttpPrincipal httpPrincipal, long companyId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserServiceUtil.class.getName(), "getDefaultUserId", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Long)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static long[] getGroupUserIds(HttpPrincipal httpPrincipal, long groupId) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserServiceUtil.class.getName(), "getGroupUserIds", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (long[])returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static long[] getOrganizationUserIds(HttpPrincipal httpPrincipal, long organizationId) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserServiceUtil.class.getName(), "getOrganizationUserIds", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{organizationId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (long[])returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static long[] getRoleUserIds(HttpPrincipal httpPrincipal, long roleId) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserServiceUtil.class.getName(), "getRoleUserIds", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{roleId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (long[])returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static User getUserByEmailAddress(HttpPrincipal httpPrincipal, long companyId, String emailAddress) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserServiceUtil.class.getName(), "getUserByEmailAddress", new Class[]{Long.TYPE, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, emailAddress});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (User)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static User getUserById(HttpPrincipal httpPrincipal, long userId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserServiceUtil.class.getName(), "getUserById", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (User)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static User getUserByScreenName(HttpPrincipal httpPrincipal, long companyId, String screenName) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserServiceUtil.class.getName(), "getUserByScreenName", new Class[]{Long.TYPE, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, screenName});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (User)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static long getUserIdByEmailAddress(HttpPrincipal httpPrincipal, long companyId, String emailAddress) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserServiceUtil.class.getName(), "getUserIdByEmailAddress", new Class[]{Long.TYPE, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, emailAddress});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Long)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static long getUserIdByScreenName(HttpPrincipal httpPrincipal, long companyId, String screenName) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserServiceUtil.class.getName(), "getUserIdByScreenName", new Class[]{Long.TYPE, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, screenName});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Long)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static boolean hasGroupUser(HttpPrincipal httpPrincipal, long groupId, long userId) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserServiceUtil.class.getName(), "hasGroupUser", new Class[]{Long.TYPE, Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, userId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Boolean)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static boolean hasRoleUser(HttpPrincipal httpPrincipal, long roleId, long userId) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserServiceUtil.class.getName(), "hasRoleUser", new Class[]{Long.TYPE, Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{roleId, userId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Boolean)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static boolean hasRoleUser(HttpPrincipal httpPrincipal, long companyId, String name, long userId, boolean inherited) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserServiceUtil.class.getName(), "hasRoleUser", new Class[]{Long.TYPE, String.class, Long.TYPE, Boolean.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, name, userId, inherited});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Boolean)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void setRoleUsers(HttpPrincipal httpPrincipal, long roleId, long[] userIds) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserServiceUtil.class.getName(), "setRoleUsers", new Class[]{Long.TYPE, long[].class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{roleId, userIds});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void setUserGroupUsers(HttpPrincipal httpPrincipal, long userGroupId, long[] userIds) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserServiceUtil.class.getName(), "setUserGroupUsers", new Class[]{Long.TYPE, long[].class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userGroupId, userIds});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void unsetGroupUsers(HttpPrincipal httpPrincipal, long groupId, long[] userIds) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserServiceUtil.class.getName(), "unsetGroupUsers", new Class[]{Long.TYPE, long[].class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, userIds});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void unsetOrganizationUsers(HttpPrincipal httpPrincipal, long organizationId, long[] userIds) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserServiceUtil.class.getName(), "unsetOrganizationUsers", new Class[]{Long.TYPE, long[].class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{organizationId, userIds});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void unsetPasswordPolicyUsers(HttpPrincipal httpPrincipal, long passwordPolicyId, long[] userIds) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserServiceUtil.class.getName(), "unsetPasswordPolicyUsers", new Class[]{Long.TYPE, long[].class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{passwordPolicyId, userIds});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void unsetRoleUsers(HttpPrincipal httpPrincipal, long roleId, long[] userIds) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserServiceUtil.class.getName(), "unsetRoleUsers", new Class[]{Long.TYPE, long[].class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{roleId, userIds});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void unsetTeamUsers(HttpPrincipal httpPrincipal, long teamId, long[] userIds) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserServiceUtil.class.getName(), "unsetTeamUsers", new Class[]{Long.TYPE, long[].class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{teamId, userIds});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void unsetUserGroupUsers(HttpPrincipal httpPrincipal, long userGroupId, long[] userIds) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserServiceUtil.class.getName(), "unsetUserGroupUsers", new Class[]{Long.TYPE, long[].class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userGroupId, userIds});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static User updateActive(HttpPrincipal httpPrincipal, long userId, boolean active) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserServiceUtil.class.getName(), "updateActive", new Class[]{Long.TYPE, Boolean.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, active});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (User)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static User updateAgreedToTermsOfUse(HttpPrincipal httpPrincipal, long userId, boolean agreedToTermsOfUse) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserServiceUtil.class.getName(), "updateAgreedToTermsOfUse", new Class[]{Long.TYPE, Boolean.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, agreedToTermsOfUse});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (User)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void updateEmailAddress(HttpPrincipal httpPrincipal, long userId, String password, String emailAddress1, String emailAddress2) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserServiceUtil.class.getName(), "updateEmailAddress", new Class[]{Long.TYPE, String.class, String.class, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, password, emailAddress1, emailAddress2});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static User updateLockout(HttpPrincipal httpPrincipal, long userId, boolean lockout) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserServiceUtil.class.getName(), "updateLockout", new Class[]{Long.TYPE, Boolean.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, lockout});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (User)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void updateOpenId(HttpPrincipal httpPrincipal, long userId, String openId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserServiceUtil.class.getName(), "updateOpenId", new Class[]{Long.TYPE, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, openId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void updateOrganizations(HttpPrincipal httpPrincipal, long userId, long[] organizationIds) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserServiceUtil.class.getName(), "updateOrganizations", new Class[]{Long.TYPE, long[].class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, organizationIds});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static User updatePassword(HttpPrincipal httpPrincipal, long userId, String password1, String password2, boolean passwordReset) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserServiceUtil.class.getName(), "updatePassword", new Class[]{Long.TYPE, String.class, String.class, Boolean.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, password1, password2, passwordReset});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (User)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void updatePortrait(HttpPrincipal httpPrincipal, long userId, byte[] bytes) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserServiceUtil.class.getName(), "updatePortrait", new Class[]{Long.TYPE, byte[].class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, bytes});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void updateReminderQuery(HttpPrincipal httpPrincipal, long userId, String question, String answer) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserServiceUtil.class.getName(), "updateReminderQuery", new Class[]{Long.TYPE, String.class, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, question, answer});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void updateScreenName(HttpPrincipal httpPrincipal, long userId, String screenName) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserServiceUtil.class.getName(), "updateScreenName", new Class[]{Long.TYPE, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, screenName});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static User updateUser(HttpPrincipal httpPrincipal, long userId, String oldPassword, String newPassword1, String newPassword2, boolean passwordReset, String reminderQueryQuestion, String reminderQueryAnswer, String screenName, String emailAddress, long facebookId, String openId, String languageId, String timeZoneId, String greeting, String comments, String firstName, String middleName, String lastName, int prefixId, int suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String smsSn, String aimSn, String facebookSn, String icqSn, String jabberSn, String msnSn, String mySpaceSn, String skypeSn, String twitterSn, String ymSn, String jobTitle, long[] groupIds, long[] organizationIds, long[] roleIds, List<UserGroupRole> userGroupRoles, long[] userGroupIds, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserServiceUtil.class.getName(), "updateUser", new Class[]{Long.TYPE, String.class, String.class, String.class, Boolean.TYPE, String.class, String.class, String.class, String.class, Long.TYPE, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, long[].class, long[].class, long[].class, List.class, long[].class, ServiceContext.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, oldPassword, newPassword1, newPassword2, passwordReset, reminderQueryQuestion, reminderQueryAnswer, screenName, emailAddress, facebookId, openId, languageId, timeZoneId, greeting, comments, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, smsSn, aimSn, facebookSn, icqSn, jabberSn, msnSn, mySpaceSn, skypeSn, twitterSn, ymSn, jobTitle, groupIds, organizationIds, roleIds, userGroupRoles, userGroupIds, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (User)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static User updateUser(HttpPrincipal httpPrincipal, long userId, String oldPassword, String newPassword1, String newPassword2, boolean passwordReset, String reminderQueryQuestion, String reminderQueryAnswer, String screenName, String emailAddress, long facebookId, String openId, String languageId, String timeZoneId, String greeting, String comments, String firstName, String middleName, String lastName, int prefixId, int suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String smsSn, String aimSn, String facebookSn, String icqSn, String jabberSn, String msnSn, String mySpaceSn, String skypeSn, String twitterSn, String ymSn, String jobTitle, long[] groupIds, long[] organizationIds, long[] roleIds, List<UserGroupRole> userGroupRoles, long[] userGroupIds, List<Address> addresses, List<EmailAddress> emailAddresses, List<Phone> phones, List<Website> websites, List<AnnouncementsDelivery> announcementsDelivers, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(UserServiceUtil.class.getName(), "updateUser", new Class[]{Long.TYPE, String.class, String.class, String.class, Boolean.TYPE, String.class, String.class, String.class, String.class, Long.TYPE, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, long[].class, long[].class, long[].class, List.class, long[].class, List.class, List.class, List.class, List.class, List.class, ServiceContext.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, oldPassword, newPassword1, newPassword2, passwordReset, reminderQueryQuestion, reminderQueryAnswer, screenName, emailAddress, facebookId, openId, languageId, timeZoneId, greeting, comments, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, smsSn, aimSn, facebookSn, icqSn, jabberSn, msnSn, mySpaceSn, skypeSn, twitterSn, ymSn, jobTitle, groupIds, organizationIds, roleIds, userGroupRoles, userGroupIds, addresses, emailAddresses, phones, websites, announcementsDelivers, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (User)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

