/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap;

import com.liferay.portal.UserEmailAddressException;
import com.liferay.portal.UserScreenNameException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Contact;
import com.liferay.portal.model.ContactConstants;
import com.liferay.portal.model.User;
import com.liferay.portal.model.impl.ContactImpl;
import com.liferay.portal.model.impl.UserImpl;
import com.liferay.portal.security.auth.FullNameGenerator;
import com.liferay.portal.security.auth.FullNameGeneratorFactory;
import com.liferay.portal.security.ldap.LDAPGroup;
import com.liferay.portal.security.ldap.LDAPToPortalConverter;
import com.liferay.portal.security.ldap.LDAPUser;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.util.ldap.LDAPUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseLDAPToPortalConverter
implements LDAPToPortalConverter {
    private static Log _log = LogFactoryUtil.getLog(BaseLDAPToPortalConverter.class);

    public LDAPGroup importLDAPGroup(long companyId, Attributes attributes, Properties groupMappings) throws Exception {
        String groupName = LDAPUtil.getAttributeValue((Attributes)attributes, (Properties)groupMappings, (String)"groupName").toLowerCase();
        String description = LDAPUtil.getAttributeValue((Attributes)attributes, (Properties)groupMappings, (String)"description");
        LDAPGroup ldapGroup = new LDAPGroup();
        ldapGroup.setCompanyId(companyId);
        ldapGroup.setDescription(description);
        ldapGroup.setGroupName(groupName);
        return ldapGroup;
    }

    public LDAPUser importLDAPUser(long companyId, Attributes attributes, Properties userMappings, Properties userExpandoMappings, Properties contactMappings, Properties contactExpandoMappings, String password) throws Exception {
        boolean autoPassword = false;
        boolean updatePassword = true;
        if (password.equals("")) {
            autoPassword = true;
            updatePassword = false;
        }
        long creatorUserId = 0L;
        boolean passwordReset = false;
        boolean autoScreenName = PrefsPropsUtil.getBoolean(companyId, "users.screen.name.always.autogenerate");
        String screenName = LDAPUtil.getAttributeValue((Attributes)attributes, (Properties)userMappings, (String)"screenName").toLowerCase();
        String emailAddress = LDAPUtil.getAttributeValue((Attributes)attributes, (Properties)userMappings, (String)"emailAddress");
        String openId = "";
        Locale locale = LocaleUtil.getDefault();
        String firstName = LDAPUtil.getAttributeValue((Attributes)attributes, (Properties)userMappings, (String)"firstName");
        String middleName = LDAPUtil.getAttributeValue((Attributes)attributes, (Properties)userMappings, (String)"middleName");
        String lastName = LDAPUtil.getAttributeValue((Attributes)attributes, (Properties)userMappings, (String)"lastName");
        if (Validator.isNull((String)firstName) || Validator.isNull((String)lastName)) {
            String fullName = LDAPUtil.getAttributeValue((Attributes)attributes, (Properties)userMappings, (String)"fullName");
            FullNameGenerator fullNameGenerator = FullNameGeneratorFactory.getInstance();
            String[] names = fullNameGenerator.splitFullName(fullName);
            firstName = names[0];
            middleName = names[1];
            lastName = names[2];
        }
        int prefixId = 0;
        int suffixId = 0;
        boolean male = true;
        int birthdayMonth = 0;
        int birthdayDay = 1;
        int birthdayYear = 1970;
        String jobTitle = LDAPUtil.getAttributeValue((Attributes)attributes, (Properties)userMappings, (String)"jobTitle");
        long[] groupIds = null;
        long[] organizationIds = null;
        long[] roleIds = null;
        List userGroupRoles = null;
        long[] userGroupIds = null;
        boolean sendEmail = false;
        ServiceContext serviceContext = new ServiceContext();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Screen name " + screenName + " and email address " + emailAddress));
        }
        if (Validator.isNull((String)screenName) && !autoScreenName) {
            throw new UserScreenNameException("Screen name cannot be null for " + ContactConstants.getFullName((String)firstName, (String)middleName, (String)lastName));
        }
        if (Validator.isNull((String)emailAddress) && PrefsPropsUtil.getBoolean(companyId, "users.email.address.required")) {
            throw new UserEmailAddressException("Email address cannot be null for " + ContactConstants.getFullName((String)firstName, (String)middleName, (String)lastName));
        }
        UserImpl user = new UserImpl();
        user.setCompanyId(companyId);
        user.setEmailAddress(emailAddress);
        user.setFirstName(firstName);
        user.setJobTitle(jobTitle);
        user.setLanguageId(locale.toString());
        user.setLastName(lastName);
        user.setMiddleName(middleName);
        user.setOpenId(openId);
        user.setPasswordUnencrypted(password);
        user.setScreenName(screenName);
        Map<String, String> userExpandoAttributes = this.getExpandoAttributes(attributes, userExpandoMappings);
        ContactImpl contact = new ContactImpl();
        contact.setBirthday(CalendarFactoryUtil.getCalendar((int)birthdayYear, (int)birthdayMonth, (int)birthdayDay).getTime());
        contact.setMale(male);
        contact.setPrefixId(prefixId);
        contact.setSuffixId(suffixId);
        Map<String, String> contactExpandoAttributes = this.getExpandoAttributes(attributes, contactExpandoMappings);
        LDAPUser ldapUser = new LDAPUser();
        ldapUser.setAutoPassword(autoPassword);
        ldapUser.setAutoScreenName(autoScreenName);
        ldapUser.setContact((Contact)contact);
        ldapUser.setContactExpandoAttributes(contactExpandoAttributes);
        ldapUser.setCreatorUserId(creatorUserId);
        ldapUser.setGroupIds(groupIds);
        ldapUser.setOrganizationIds(organizationIds);
        ldapUser.setPasswordReset(passwordReset);
        ldapUser.setRoleIds(roleIds);
        ldapUser.setSendEmail(sendEmail);
        ldapUser.setServiceContext(serviceContext);
        ldapUser.setUpdatePassword(updatePassword);
        ldapUser.setUser((User)user);
        ldapUser.setUserExpandoAttributes(userExpandoAttributes);
        ldapUser.setUserGroupIds(userGroupIds);
        ldapUser.setUserGroupRoles(userGroupRoles);
        return ldapUser;
    }

    protected Map<String, String> getExpandoAttributes(Attributes attributes, Properties expandoMappings) throws NamingException {
        HashMap<String, String> expandoAttributes = new HashMap<String, String>();
        for (Object key : expandoMappings.keySet()) {
            String name = (String)key;
            String value = LDAPUtil.getAttributeValue((Attributes)attributes, (Properties)expandoMappings, (String)name);
            if (!Validator.isNotNull((String)value)) continue;
            expandoAttributes.put(name, value);
        }
        return expandoAttributes;
    }
}

