/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.lucene;

import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.StringQueryImpl;
import com.liferay.portal.search.lucene.BooleanQueryImpl;
import com.liferay.portal.search.lucene.LuceneHelperUtil;
import com.liferay.portal.search.lucene.LuceneQueryImpl;
import com.liferay.portal.search.lucene.TermQueryImpl;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;

public class QueryTranslator {
    public static org.apache.lucene.search.Query translate(Query query) throws ParseException {
        if (query instanceof BooleanQueryImpl) {
            return ((BooleanQueryImpl)query).getBooleanQuery();
        }
        if (query instanceof LuceneQueryImpl) {
            return ((LuceneQueryImpl)query).getQuery();
        }
        if (query instanceof StringQueryImpl) {
            QueryParser parser = new QueryParser(LuceneHelperUtil.getVersion(), "", LuceneHelperUtil.getAnalyzer());
            return parser.parse(query.toString());
        }
        if (query instanceof TermQueryImpl) {
            return ((TermQueryImpl)query).getTermQuery();
        }
        return null;
    }
}

