/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.lar.LayoutCache;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.Resource;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.PermissionLocalServiceUtil;
import com.liferay.portal.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.time.StopWatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionExporter {
    private static Log _log = LogFactoryUtil.getLog(PermissionExporter.class);

    protected Element exportGroupPermissions(long companyId, long groupId, String resourceName, String resourcePrimKey, Element parentEl, String elName) throws SystemException {
        Element el = parentEl.addElement(elName);
        List permissions = PermissionLocalServiceUtil.getGroupPermissions((long)groupId, (long)companyId, (String)resourceName, (int)4, (String)resourcePrimKey);
        List<String> actions = ResourceActionsUtil.getActions(permissions);
        int i = 0;
        while (i < actions.size()) {
            String action = actions.get(i);
            Element actionKeyEl = el.addElement("action-key");
            actionKeyEl.addText(action);
            ++i;
        }
        return el;
    }

    protected void exportGroupRoles(LayoutCache layoutCache, long companyId, long groupId, String resourceName, String entityName, Element parentEl) throws SystemException {
        List<Role> roles = layoutCache.getGroupRoles_1to4(groupId);
        Element groupEl = this.exportRoles(companyId, resourceName, 2, String.valueOf(groupId), parentEl, String.valueOf(entityName) + "-roles", roles);
        if (groupEl.elements().isEmpty()) {
            parentEl.remove(groupEl);
        }
    }

    protected void exportInheritedPermissions(LayoutCache layoutCache, long companyId, String resourceName, String resourcePrimKey, Element parentEl, String entityName) throws PortalException, SystemException {
        Element entityPermissionsEl = SAXReaderUtil.createElement((String)(String.valueOf(entityName) + "-permissions"));
        Map<String, Long> entityMap = layoutCache.getEntityMap(companyId, entityName);
        for (Map.Entry<String, Long> entry : entityMap.entrySet()) {
            String name = entry.getKey().toString();
            long entityGroupId = entry.getValue();
            Element entityEl = this.exportGroupPermissions(companyId, entityGroupId, resourceName, resourcePrimKey, entityPermissionsEl, String.valueOf(entityName) + "-actions");
            if (entityEl.elements().isEmpty()) {
                entityPermissionsEl.remove(entityEl);
                continue;
            }
            entityEl.addAttribute("name", name);
        }
        if (!entityPermissionsEl.elements().isEmpty()) {
            parentEl.add(entityPermissionsEl);
        }
    }

    protected void exportInheritedRoles(LayoutCache layoutCache, long companyId, long groupId, String resourceName, String entityName, Element parentEl) throws PortalException, SystemException {
        Element entityRolesEl = SAXReaderUtil.createElement((String)(String.valueOf(entityName) + "-roles"));
        Map<String, Long> entityMap = layoutCache.getEntityMap(companyId, entityName);
        for (Map.Entry<String, Long> entry : entityMap.entrySet()) {
            String name = entry.getKey().toString();
            long entityGroupId = entry.getValue();
            List<Role> entityRoles = layoutCache.getGroupRoles_1to4(entityGroupId);
            Element entityEl = this.exportRoles(companyId, resourceName, 2, String.valueOf(groupId), entityRolesEl, entityName, entityRoles);
            if (entityEl.elements().isEmpty()) {
                entityRolesEl.remove(entityEl);
                continue;
            }
            entityEl.addAttribute("name", name);
        }
        if (!entityRolesEl.elements().isEmpty()) {
            parentEl.add(entityRolesEl);
        }
    }

    protected void exportLayoutPermissions(PortletDataContext context, LayoutCache layoutCache, long companyId, long groupId, Layout layout, Element layoutEl, boolean exportUserPermissions) throws PortalException, SystemException {
        String resourceName = Layout.class.getName();
        String resourcePrimKey = String.valueOf(layout.getPlid());
        Element permissionsEl = layoutEl.addElement("permissions");
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 5) {
            this.exportPermissions_5(layoutCache, companyId, groupId, resourceName, resourcePrimKey, permissionsEl, false);
        } else if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
            this.exportPermissions_6(layoutCache, companyId, groupId, resourceName, resourcePrimKey, permissionsEl, false);
        } else {
            this.exportPermissions_1to4(layoutCache, companyId, groupId, resourceName, resourcePrimKey, permissionsEl, exportUserPermissions);
        }
    }

    protected void exportLayoutRoles(LayoutCache layoutCache, long companyId, long groupId, Element rolesEl) throws PortalException, SystemException {
        String resourceName = Layout.class.getName();
        this.exportGroupRoles(layoutCache, companyId, groupId, resourceName, "community", rolesEl);
        this.exportUserRoles(layoutCache, companyId, groupId, resourceName, rolesEl);
        this.exportInheritedRoles(layoutCache, companyId, groupId, resourceName, "organization", rolesEl);
        this.exportInheritedRoles(layoutCache, companyId, groupId, resourceName, "user-group", rolesEl);
    }

    protected void exportPermissions_1to4(LayoutCache layoutCache, long companyId, long groupId, String resourceName, String resourcePrimKey, Element permissionsEl, boolean exportUserPermissions) throws PortalException, SystemException {
        Group guestGroup = GroupLocalServiceUtil.getGroup((long)companyId, (String)"Guest");
        this.exportGroupPermissions(companyId, groupId, resourceName, resourcePrimKey, permissionsEl, "community-actions");
        if (groupId != guestGroup.getGroupId()) {
            this.exportGroupPermissions(companyId, guestGroup.getGroupId(), resourceName, resourcePrimKey, permissionsEl, "guest-actions");
        }
        if (exportUserPermissions) {
            this.exportUserPermissions(layoutCache, companyId, groupId, resourceName, resourcePrimKey, permissionsEl);
        }
        this.exportInheritedPermissions(layoutCache, companyId, resourceName, resourcePrimKey, permissionsEl, "organization");
        this.exportInheritedPermissions(layoutCache, companyId, resourceName, resourcePrimKey, permissionsEl, "user-group");
    }

    protected void exportPermissions_5(LayoutCache layoutCache, long companyId, long groupId, String resourceName, String resourcePrimKey, Element permissionsEl, boolean portletActions) throws PortalException, SystemException {
        Resource resource = layoutCache.getResource(companyId, groupId, resourceName, 4, resourcePrimKey, portletActions);
        List<Role> roles = layoutCache.getGroupRoles_5(groupId, resourceName);
        for (Role role : roles) {
            if (role.getName().equals("Administrator")) continue;
            Element roleEl = permissionsEl.addElement("role");
            roleEl.addAttribute("name", role.getName());
            roleEl.addAttribute("description", role.getDescription());
            roleEl.addAttribute("type", String.valueOf(role.getType()));
            List permissions = PermissionLocalServiceUtil.getRolePermissions((long)role.getRoleId(), (long)resource.getResourceId());
            List<String> actions = ResourceActionsUtil.getActions(permissions);
            for (String action : actions) {
                Element actionKeyEl = roleEl.addElement("action-key");
                actionKeyEl.addText(action);
            }
        }
    }

    protected void exportPermissions_6(LayoutCache layoutCache, long companyId, long groupId, String resourceName, String resourcePrimKey, Element permissionsEl, boolean portletActions) throws PortalException, SystemException {
        List<Role> roles = layoutCache.getGroupRoles_5(groupId, resourceName);
        for (Role role : roles) {
            if (role.getName().equals("Administrator")) continue;
            Element roleEl = permissionsEl.addElement("role");
            roleEl.addAttribute("name", role.getName());
            roleEl.addAttribute("description", role.getDescription());
            roleEl.addAttribute("type", String.valueOf(role.getType()));
            List<String> actionIds = null;
            actionIds = portletActions ? ResourceActionsUtil.getPortletResourceActions(resourceName) : ResourceActionsUtil.getModelResourceActions(resourceName);
            List actions = ResourcePermissionLocalServiceUtil.getAvailableResourcePermissionActionIds((long)companyId, (String)resourceName, (int)4, (String)resourcePrimKey, (long)role.getRoleId(), actionIds);
            for (String action : actions) {
                Element actionKeyEl = roleEl.addElement("action-key");
                actionKeyEl.addText(action);
            }
        }
    }

    protected void exportPortletDataPermissions(PortletDataContext context) throws SystemException {
        try {
            Document doc = SAXReaderUtil.createDocument();
            Element root = doc.addElement("portlet-data-permissions");
            Map permissionsMap = context.getPermissions();
            for (Map.Entry entry : permissionsMap.entrySet()) {
                String[] permissionEntry = ((String)entry.getKey()).split("#");
                Element portletDataEl = root.addElement("portlet-data");
                portletDataEl.addAttribute("resource-name", permissionEntry[0]);
                portletDataEl.addAttribute("resource-pk", permissionEntry[1]);
                List permissions = (List)entry.getValue();
                for (KeyValuePair permission : permissions) {
                    String roleName = permission.getKey();
                    String actions = permission.getValue();
                    Element permissionsEl = portletDataEl.addElement("permissions");
                    permissionsEl.addAttribute("role-name", roleName);
                    permissionsEl.addAttribute("actions", actions);
                }
            }
            context.addZipEntry(String.valueOf(context.getRootPath()) + "/portlet-data-permissions.xml", doc.formattedString());
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    protected void exportPortletPermissions(PortletDataContext context, LayoutCache layoutCache, String portletId, Layout layout, Element portletEl) throws PortalException, SystemException {
        long companyId = context.getCompanyId();
        long groupId = context.getGroupId();
        String resourceName = PortletConstants.getRootPortletId((String)portletId);
        String resourcePrimKey = PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)portletId);
        Element permissionsEl = portletEl.addElement("permissions");
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 5) {
            this.exportPermissions_5(layoutCache, companyId, groupId, resourceName, resourcePrimKey, permissionsEl, true);
        } else if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
            this.exportPermissions_6(layoutCache, companyId, groupId, resourceName, resourcePrimKey, permissionsEl, true);
        } else {
            boolean exportUserPermissions = MapUtil.getBoolean((Map)context.getParameterMap(), (String)"USER_PERMISSIONS");
            this.exportPermissions_1to4(layoutCache, companyId, groupId, resourceName, resourcePrimKey, permissionsEl, exportUserPermissions);
            Element rolesEl = portletEl.addElement("roles");
            this.exportPortletRoles(layoutCache, companyId, groupId, portletId, rolesEl);
        }
    }

    protected void exportPortletRoles(LayoutCache layoutCache, long companyId, long groupId, String portletId, Element rolesEl) throws PortalException, SystemException {
        String resourceName = PortletConstants.getRootPortletId((String)portletId);
        Element portletEl = rolesEl.addElement("portlet");
        portletEl.addAttribute("portlet-id", portletId);
        this.exportGroupRoles(layoutCache, companyId, groupId, resourceName, "community", portletEl);
        this.exportUserRoles(layoutCache, companyId, groupId, resourceName, portletEl);
        this.exportInheritedRoles(layoutCache, companyId, groupId, resourceName, "organization", portletEl);
        this.exportInheritedRoles(layoutCache, companyId, groupId, resourceName, "user-group", portletEl);
        if (portletEl.elements().isEmpty()) {
            rolesEl.remove(portletEl);
        }
    }

    protected Element exportRoles(long companyId, String resourceName, int scope, String resourcePrimKey, Element parentEl, String elName, List<Role> roles) throws SystemException {
        Element el = parentEl.addElement(elName);
        Map resourceRoles = RoleLocalServiceUtil.getResourceRoles((long)companyId, (String)resourceName, (int)scope, (String)resourcePrimKey);
        for (Map.Entry entry : resourceRoles.entrySet()) {
            String roleName = ((String)entry.getKey()).toString();
            if (!this.hasRole(roles, roleName)) continue;
            Element roleEl = el.addElement("role");
            roleEl.addAttribute("name", roleName);
            List actions = (List)entry.getValue();
            int i = 0;
            while (i < actions.size()) {
                String action = (String)actions.get(i);
                Element actionKeyEl = roleEl.addElement("action-key");
                actionKeyEl.addText(action);
                actionKeyEl.addAttribute("scope", String.valueOf(scope));
                ++i;
            }
        }
        return el;
    }

    protected void exportUserPermissions(LayoutCache layoutCache, long companyId, long groupId, String resourceName, String resourcePrimKey, Element parentEl) throws SystemException {
        StopWatch stopWatch = null;
        if (_log.isDebugEnabled()) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        Element userPermissionsEl = SAXReaderUtil.createElement((String)"user-permissions");
        List<User> users = layoutCache.getGroupUsers(groupId);
        for (User user : users) {
            String uuid = user.getUuid();
            Element userActionsEl = SAXReaderUtil.createElement((String)"user-actions");
            List permissions = PermissionLocalServiceUtil.getUserPermissions((long)user.getUserId(), (long)companyId, (String)resourceName, (int)4, (String)resourcePrimKey);
            List<String> actions = ResourceActionsUtil.getActions(permissions);
            for (String action : actions) {
                Element actionKeyEl = userActionsEl.addElement("action-key");
                actionKeyEl.addText(action);
            }
            if (userActionsEl.elements().isEmpty()) continue;
            userActionsEl.addAttribute("uuid", uuid);
            userPermissionsEl.add(userActionsEl);
        }
        if (!userPermissionsEl.elements().isEmpty()) {
            parentEl.add(userPermissionsEl);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Export user permissions for {" + resourceName + ", " + resourcePrimKey + "} with " + users.size() + " users takes " + stopWatch.getTime() + " ms"));
        }
    }

    protected void exportUserRoles(LayoutCache layoutCache, long companyId, long groupId, String resourceName, Element parentEl) throws SystemException {
        Element userRolesEl = SAXReaderUtil.createElement((String)"user-roles");
        List<User> users = layoutCache.getGroupUsers(groupId);
        for (User user : users) {
            long userId = user.getUserId();
            String uuid = user.getUuid();
            List<Role> userRoles = layoutCache.getUserRoles(userId);
            Element userEl = this.exportRoles(companyId, resourceName, 2, String.valueOf(groupId), userRolesEl, "user", userRoles);
            if (userEl.elements().isEmpty()) {
                userRolesEl.remove(userEl);
                continue;
            }
            userEl.addAttribute("uuid", uuid);
        }
        if (!userRolesEl.elements().isEmpty()) {
            parentEl.add(userRolesEl);
        }
    }

    protected boolean hasRole(List<Role> roles, String roleName) {
        if (roles == null || roles.size() == 0) {
            return false;
        }
        for (Role role : roles) {
            if (!role.getName().equals(roleName)) continue;
            return true;
        }
        return false;
    }
}

