/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.upgrade.UpgradeProcessUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.verify.VerifyException;
import com.liferay.portal.verify.VerifyProcessUtil;

public class StartupHelper {
    private static Log _log = LogFactoryUtil.getLog(StartupHelper.class);
    private boolean _dropIndexes;
    private boolean _upgraded;
    private boolean _verified;

    public void setDropIndexes(boolean dropIndexes) {
        this._dropIndexes = dropIndexes;
    }

    public void updateIndexes() {
        try {
            DB db = DBFactoryUtil.getDB();
            Thread currentThread = Thread.currentThread();
            ClassLoader classLoader = currentThread.getContextClassLoader();
            String tablesSQL = StringUtil.read((ClassLoader)classLoader, (String)"com/liferay/portal/tools/sql/dependencies/portal-tables.sql");
            String indexesSQL = StringUtil.read((ClassLoader)classLoader, (String)"com/liferay/portal/tools/sql/dependencies/indexes.sql");
            String indexesProperties = StringUtil.read((ClassLoader)classLoader, (String)"com/liferay/portal/tools/sql/dependencies/indexes.properties");
            db.updateIndexes(tablesSQL, indexesSQL, indexesProperties, this._dropIndexes);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public void upgradeProcess(int buildNumber) throws UpgradeException {
        String[] upgradeProcessClassNames = PropsUtil.getArray("upgrade.processes");
        this._upgraded = UpgradeProcessUtil.upgradeProcess(buildNumber, upgradeProcessClassNames, PortalClassLoaderUtil.getClassLoader());
    }

    public void verifyProcess(boolean verified) throws VerifyException {
        this._verified = VerifyProcessUtil.verifyProcess(this._upgraded, verified);
    }

    public boolean isUpgraded() {
        return this._upgraded;
    }

    public boolean isVerified() {
        return this._verified;
    }
}

