/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.ehcache;

import com.liferay.portal.cache.ehcache.JGroupsManager;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.IPDetector;
import com.liferay.portal.kernel.util.OSDetector;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import java.util.Properties;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.distribution.CacheManagerPeerProviderFactory;

public class JGroupsCacheManagerPeerProviderFactory
extends CacheManagerPeerProviderFactory {
    private static final String _DEFAULT_CLUSTER_NAME = "Ehcache";
    private static Log _log = LogFactoryUtil.getLog(JGroupsCacheManagerPeerProviderFactory.class);
    private static boolean _initialized;

    public CacheManagerPeerProvider createCachePeerProvider(CacheManager cacheManager, Properties properties) {
        String channelProperties;
        String clusterName;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Creating JGroups peer provider");
        }
        if ((clusterName = properties.getProperty("clusterName")) == null) {
            clusterName = _DEFAULT_CLUSTER_NAME;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Cluster name " + clusterName));
        }
        if ((channelProperties = properties.getProperty("channelProperties")) != null && Validator.isNull((String)(channelProperties = channelProperties.replaceAll(" ", "")))) {
            channelProperties = null;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Channel properties " + channelProperties));
        }
        if (!_initialized) {
            if (OSDetector.isUnix() && IPDetector.isSupportsV6() && !IPDetector.isPrefersV4() && _log.isWarnEnabled()) {
                StringBundler sb = new StringBundler(4);
                sb.append("You are on an Unix server with IPv6 enabled. JGroups ");
                sb.append("may not work with IPv6. If you see a multicast ");
                sb.append("error, try adding java.net.preferIPv4Stack=true ");
                sb.append("as a JVM startup parameter.");
                _log.warn((Object)sb.toString());
            }
            _initialized = true;
        }
        return new JGroupsManager(cacheManager, clusterName, channelProperties);
    }
}

