/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.action;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextUtil;
import com.liferay.portal.struts.JSONAction;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.asset.model.AssetEntryDisplay;
import com.liferay.portlet.asset.model.AssetEntryType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONServiceAction
extends JSONAction {
    private static Log _log = LogFactoryUtil.getLog(JSONServiceAction.class);
    private static Pattern _fieldDescriptorPattern = Pattern.compile("^(.*?)((\\[\\])*)$", 32);
    private Set<String> _invalidClassNames = new HashSet<String>();
    private Map<String, Object[]> _methodCache = new HashMap<String, Object[]>();

    public JSONServiceAction() {
        this._invalidClassNames.addAll(ListUtil.fromArray((Object[])PropsValues.JSON_SERVICE_INVALID_CLASS_NAMES));
        if (_log.isDebugEnabled()) {
            for (String invalidClassName : this._invalidClassNames) {
                _log.debug((Object)("Invalid class name " + invalidClassName));
            }
        }
    }

    @Override
    public String getJSON(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String className = ParamUtil.getString((HttpServletRequest)request, (String)"serviceClassName");
        String methodName = ParamUtil.getString((HttpServletRequest)request, (String)"serviceMethodName");
        String[] serviceParameters = this.getStringArrayFromJSON(request, "serviceParameters");
        String[] serviceParameterTypes = this.getStringArrayFromJSON(request, "serviceParameterTypes");
        if (!this.isValidRequest(request)) {
            return null;
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        Class<?> classObj = contextClassLoader.loadClass(className);
        Object[] methodAndParameterTypes = this.getMethodAndParameterTypes(classObj, methodName, serviceParameters, serviceParameterTypes);
        if (methodAndParameterTypes != null) {
            Method method = (Method)methodAndParameterTypes[0];
            Type[] parameterTypes = (Type[])methodAndParameterTypes[1];
            Object[] args = new Object[serviceParameters.length];
            int i = 0;
            while (i < serviceParameters.length) {
                args[i] = this.getArgValue(request, classObj, methodName, serviceParameters[i], parameterTypes[i]);
                ++i;
            }
            try {
                Object returnObj;
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Invoking " + classObj + " on method " + method.getName() + " with args " + Arrays.toString(args)));
                }
                if ((returnObj = method.invoke(classObj, args)) != null) {
                    return this.getReturnValue(returnObj, method.getReturnType());
                }
                JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
                return jsonObject.toString();
            }
            catch (Exception e) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Invoked " + classObj + " on method " + method.getName() + " with args " + Arrays.toString(args)), (Throwable)e);
                }
                JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
                if (e instanceof InvocationTargetException) {
                    jsonObject.put("exception", e.getCause().toString());
                } else {
                    jsonObject.put("exception", e.getMessage());
                }
                return jsonObject.toString();
            }
        }
        return null;
    }

    protected Object getArgValue(HttpServletRequest request, Class<?> classObj, String methodName, String parameter, Type parameterType) throws Exception {
        String typeNameOrClassDescriptor = this.getTypeNameOrClassDescriptor(parameterType);
        String value = ParamUtil.getString((HttpServletRequest)request, (String)parameter);
        if (Validator.isNull((String)value) && !typeNameOrClassDescriptor.equals("[Ljava.lang.String;")) {
            return null;
        }
        if (typeNameOrClassDescriptor.equals("boolean") || typeNameOrClassDescriptor.equals(Boolean.class.getName())) {
            return ParamUtil.getBoolean((HttpServletRequest)request, (String)parameter);
        }
        if (typeNameOrClassDescriptor.equals("double") || typeNameOrClassDescriptor.equals(Double.class.getName())) {
            return new Double(ParamUtil.getDouble((HttpServletRequest)request, (String)parameter));
        }
        if (typeNameOrClassDescriptor.equals("int") || typeNameOrClassDescriptor.equals(Integer.class.getName())) {
            return new Integer(ParamUtil.getInteger((HttpServletRequest)request, (String)parameter));
        }
        if (typeNameOrClassDescriptor.equals("long") || typeNameOrClassDescriptor.equals(Long.class.getName())) {
            return new Long(ParamUtil.getLong((HttpServletRequest)request, (String)parameter));
        }
        if (typeNameOrClassDescriptor.equals("short") || typeNameOrClassDescriptor.equals(Short.class.getName())) {
            return new Short(ParamUtil.getShort((HttpServletRequest)request, (String)parameter));
        }
        if (typeNameOrClassDescriptor.equals(Date.class.getName())) {
            return new Date(ParamUtil.getLong((HttpServletRequest)request, (String)parameter));
        }
        if (typeNameOrClassDescriptor.equals(ServiceContext.class.getName())) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)value);
            jsonObject.put("javaClass", ServiceContext.class.getName());
            return ServiceContextUtil.deserialize((JSONObject)jsonObject);
        }
        if (typeNameOrClassDescriptor.equals(String.class.getName())) {
            return value;
        }
        if (typeNameOrClassDescriptor.equals("[Z")) {
            return ParamUtil.getBooleanValues((HttpServletRequest)request, (String)parameter);
        }
        if (typeNameOrClassDescriptor.equals("[D")) {
            return ParamUtil.getDoubleValues((HttpServletRequest)request, (String)parameter);
        }
        if (typeNameOrClassDescriptor.equals("[F")) {
            return ParamUtil.getFloatValues((HttpServletRequest)request, (String)parameter);
        }
        if (typeNameOrClassDescriptor.equals("[I")) {
            return ParamUtil.getIntegerValues((HttpServletRequest)request, (String)parameter);
        }
        if (typeNameOrClassDescriptor.equals("[J")) {
            return ParamUtil.getLongValues((HttpServletRequest)request, (String)parameter);
        }
        if (typeNameOrClassDescriptor.equals("[S")) {
            return ParamUtil.getShortValues((HttpServletRequest)request, (String)parameter);
        }
        if (typeNameOrClassDescriptor.equals("[Ljava.lang.String;")) {
            return StringUtil.split((String)value);
        }
        if (typeNameOrClassDescriptor.equals("[[Z")) {
            String[] values = request.getParameterValues(parameter);
            if (values != null && values.length > 0) {
                String[] values0 = StringUtil.split((String)values[0]);
                boolean[][] doubleArray = new boolean[values.length][values0.length];
                int i = 0;
                while (i < values.length) {
                    String[] curValues = StringUtil.split((String)values[i]);
                    int j = 0;
                    while (j < curValues.length) {
                        doubleArray[i][j] = GetterUtil.getBoolean((String)curValues[j]);
                        ++j;
                    }
                    ++i;
                }
                return doubleArray;
            }
            return new boolean[0][0];
        }
        if (typeNameOrClassDescriptor.equals("[[D")) {
            String[] values = request.getParameterValues(parameter);
            if (values != null && values.length > 0) {
                String[] values0 = StringUtil.split((String)values[0]);
                double[][] doubleArray = new double[values.length][values0.length];
                int i = 0;
                while (i < values.length) {
                    String[] curValues = StringUtil.split((String)values[i]);
                    int j = 0;
                    while (j < curValues.length) {
                        doubleArray[i][j] = GetterUtil.getDouble((String)curValues[j]);
                        ++j;
                    }
                    ++i;
                }
                return doubleArray;
            }
            return new double[0][0];
        }
        if (typeNameOrClassDescriptor.equals("[[F")) {
            String[] values = request.getParameterValues(parameter);
            if (values != null && values.length > 0) {
                String[] values0 = StringUtil.split((String)values[0]);
                float[][] doubleArray = new float[values.length][values0.length];
                int i = 0;
                while (i < values.length) {
                    String[] curValues = StringUtil.split((String)values[i]);
                    int j = 0;
                    while (j < curValues.length) {
                        doubleArray[i][j] = GetterUtil.getFloat((String)curValues[j]);
                        ++j;
                    }
                    ++i;
                }
                return doubleArray;
            }
            return new float[0][0];
        }
        if (typeNameOrClassDescriptor.equals("[[I")) {
            String[] values = request.getParameterValues(parameter);
            if (values != null && values.length > 0) {
                String[] values0 = StringUtil.split((String)values[0]);
                int[][] doubleArray = new int[values.length][values0.length];
                int i = 0;
                while (i < values.length) {
                    String[] curValues = StringUtil.split((String)values[i]);
                    int j = 0;
                    while (j < curValues.length) {
                        doubleArray[i][j] = GetterUtil.getInteger((String)curValues[j]);
                        ++j;
                    }
                    ++i;
                }
                return doubleArray;
            }
            return new int[0][0];
        }
        if (typeNameOrClassDescriptor.equals("[[J")) {
            String[] values = request.getParameterValues(parameter);
            if (values != null && values.length > 0) {
                String[] values0 = StringUtil.split((String)values[0]);
                long[][] doubleArray = new long[values.length][values0.length];
                int i = 0;
                while (i < values.length) {
                    String[] curValues = StringUtil.split((String)values[i]);
                    int j = 0;
                    while (j < curValues.length) {
                        doubleArray[i][j] = GetterUtil.getLong((String)curValues[j]);
                        ++j;
                    }
                    ++i;
                }
                return doubleArray;
            }
            return new long[0][0];
        }
        if (typeNameOrClassDescriptor.equals("[[S")) {
            String[] values = request.getParameterValues(parameter);
            if (values != null && values.length > 0) {
                String[] values0 = StringUtil.split((String)values[0]);
                short[][] doubleArray = new short[values.length][values0.length];
                int i = 0;
                while (i < values.length) {
                    String[] curValues = StringUtil.split((String)values[i]);
                    int j = 0;
                    while (j < curValues.length) {
                        doubleArray[i][j] = GetterUtil.getShort((String)curValues[j]);
                        ++j;
                    }
                    ++i;
                }
                return doubleArray;
            }
            return new short[0][0];
        }
        if (typeNameOrClassDescriptor.equals("[[Ljava.lang.String")) {
            String[] values = request.getParameterValues(parameter);
            if (values != null && values.length > 0) {
                String[] values0 = StringUtil.split((String)values[0]);
                String[][] doubleArray = new String[values.length][values0.length];
                int i = 0;
                while (i < values.length) {
                    doubleArray[i] = StringUtil.split((String)values[i]);
                    ++i;
                }
                return doubleArray;
            }
            return new String[0][0];
        }
        if (typeNameOrClassDescriptor.equals("java.util.Map<java.util.Locale, java.lang.String>")) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)value);
            return LocalizationUtil.deserialize((JSONObject)jsonObject);
        }
        _log.error((Object)("Unsupported parameter type for class " + classObj + ", method " + methodName + ", parameter " + parameter + ", and type " + typeNameOrClassDescriptor));
        return null;
    }

    protected Object[] getMethodAndParameterTypes(Class<?> classObj, String methodName, String[] parameters, String[] parameterTypes) throws Exception {
        String parameterNames = StringUtil.merge((Object[])parameters);
        String key = String.valueOf(classObj.getName()) + "_METHOD_NAME_" + methodName + "_PARAMETERS_" + parameterNames;
        Object[] methodAndParameterTypes = this._methodCache.get(key);
        if (methodAndParameterTypes != null) {
            return methodAndParameterTypes;
        }
        Method method = null;
        Type[] methodParameterTypes = null;
        Method[] methods = classObj.getMethods();
        int i = 0;
        while (i < methods.length) {
            Type[] curParameterTypes;
            Method curMethod = methods[i];
            if (curMethod.getName().equals(methodName) && (curParameterTypes = curMethod.getGenericParameterTypes()).length == parameters.length) {
                if (parameterTypes.length > 0 && parameterTypes.length == curParameterTypes.length) {
                    boolean match = true;
                    int j = 0;
                    while (j < parameterTypes.length) {
                        String t1 = parameterTypes[j];
                        String t2 = this.getTypeNameOrClassDescriptor(curParameterTypes[j]);
                        if (!t1.equals(t2)) {
                            match = false;
                        }
                        ++j;
                    }
                    if (match) {
                        method = curMethod;
                        methodParameterTypes = curParameterTypes;
                        break;
                    }
                } else {
                    if (method != null) {
                        _log.error((Object)("Obscure method name for class " + classObj + ", method " + methodName + ", and parameters " + parameterNames));
                        return null;
                    }
                    method = curMethod;
                    methodParameterTypes = curParameterTypes;
                }
            }
            ++i;
        }
        if (method != null) {
            methodAndParameterTypes = new Object[]{method, methodParameterTypes};
            this._methodCache.put(key, methodAndParameterTypes);
            return methodAndParameterTypes;
        }
        _log.error((Object)("No method found for class " + classObj + ", method " + methodName + ", and parameters " + parameterNames));
        return null;
    }

    protected String getReturnValue(AssetEntryDisplay assetEntryDisplay) throws Exception {
        JSONObject jsonObject = this.toJSONObject(assetEntryDisplay);
        return jsonObject.toString();
    }

    protected String getReturnValue(AssetEntryDisplay[] assetEntryDisplays) throws Exception {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        int i = 0;
        while (i < assetEntryDisplays.length) {
            AssetEntryDisplay assetEntryDisplay = assetEntryDisplays[i];
            jsonArray.put(this.toJSONObject(assetEntryDisplay));
            ++i;
        }
        return jsonArray.toString();
    }

    protected String getReturnValue(AssetEntryType assetEntryType) throws Exception {
        JSONObject jsonObject = this.toJSONObject(assetEntryType);
        return jsonObject.toString();
    }

    protected String getReturnValue(AssetEntryType[] assetEntryTypes) throws Exception {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        int i = 0;
        while (i < assetEntryTypes.length) {
            AssetEntryType assetEntryType = assetEntryTypes[i];
            jsonArray.put(this.toJSONObject(assetEntryType));
            ++i;
        }
        return jsonArray.toString();
    }

    protected String getReturnValue(Object returnObj, Class<?> returnType) throws Exception {
        if (returnObj instanceof Boolean || returnObj instanceof Double || returnObj instanceof Integer || returnObj instanceof Long || returnObj instanceof Short || returnObj instanceof String) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            jsonObject.put("returnValue", returnObj.toString());
            return jsonObject.toString();
        }
        if (returnObj instanceof BaseModel) {
            String serlializerClassName = this.getSerializerClassName(returnObj);
            MethodKey methodKey = new MethodKey(serlializerClassName, "toJSONObject", new Class[]{returnType});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{returnObj});
            JSONObject jsonObject = (JSONObject)methodHandler.invoke(false);
            return jsonObject.toString();
        }
        if (returnObj instanceof BaseModel[]) {
            JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
            BaseModel[] returnArray = (BaseModel[])returnObj;
            if (returnArray.length > 0) {
                BaseModel returnItem0 = returnArray[0];
                String serializerClassName = this.getSerializerClassName(returnItem0);
                MethodKey methodKey = new MethodKey(serializerClassName, "toJSONArray", new Class[]{returnType});
                MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{returnObj});
                jsonArray = (JSONArray)methodHandler.invoke(false);
            }
            return jsonArray.toString();
        }
        if (returnObj instanceof BaseModel[][]) {
            JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
            BaseModel[][] returnArray = (BaseModel[][])returnObj;
            if (returnArray.length > 0 && returnArray[0].length > 0) {
                BaseModel returnItem0 = returnArray[0][0];
                String serializerClassName = this.getSerializerClassName(returnItem0);
                MethodKey methodKey = new MethodKey(serializerClassName, "toJSONArray", new Class[]{returnType});
                MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{returnObj});
                jsonArray = (JSONArray)methodHandler.invoke(false);
            }
            return jsonArray.toString();
        }
        if (returnObj instanceof List) {
            JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
            List returnList = (List)returnObj;
            if (!returnList.isEmpty()) {
                Object returnItem0 = returnList.get(0);
                String serlializerClassName = this.getSerializerClassName(returnItem0);
                MethodKey methodKey = new MethodKey(serlializerClassName, "toJSONArray", new Class[]{returnType});
                MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{returnObj});
                jsonArray = (JSONArray)methodHandler.invoke(false);
            }
            return jsonArray.toString();
        }
        if (returnObj instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)returnObj;
            return jsonArray.toString();
        }
        if (returnObj instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)returnObj;
            return jsonObject.toString();
        }
        if (returnObj instanceof AssetEntryDisplay) {
            return this.getReturnValue((AssetEntryDisplay)returnObj);
        }
        if (returnObj instanceof AssetEntryDisplay[]) {
            return this.getReturnValue((AssetEntryDisplay[])returnObj);
        }
        if (returnObj instanceof AssetEntryType) {
            return this.getReturnValue((AssetEntryType)returnObj);
        }
        if (returnObj instanceof AssetEntryType[]) {
            return this.getReturnValue((AssetEntryType[])returnObj);
        }
        return JSONFactoryUtil.serialize((Object)returnObj);
    }

    protected String getSerializerClassName(Object obj) {
        String serlializerClassName = StringUtil.replace((String)obj.getClass().getName(), (String[])new String[]{".model.impl.", "Impl"}, (String[])new String[]{".service.http.", "JSONSerializer"});
        return serlializerClassName;
    }

    protected String[] getStringArrayFromJSON(HttpServletRequest request, String param) throws JSONException {
        String json = ParamUtil.getString((HttpServletRequest)request, (String)param, (String)"[]");
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray((String)json);
        return ArrayUtil.toStringArray((JSONArray)jsonArray);
    }

    protected String getTypeNameOrClassDescriptor(Type type) {
        String typeName = type.toString();
        if (typeName.contains("class ")) {
            return typeName.substring(6);
        }
        Matcher matcher = _fieldDescriptorPattern.matcher(typeName);
        if (matcher.find()) {
            String dimensions = matcher.group(2);
            String fieldDescriptor = matcher.group(1);
            if (Validator.isNull((String)dimensions)) {
                return fieldDescriptor;
            }
            dimensions = dimensions.replace("]", "");
            fieldDescriptor = fieldDescriptor.equals("boolean") ? "Z" : (fieldDescriptor.equals("byte") ? "B" : (fieldDescriptor.equals("char") ? "C" : (fieldDescriptor.equals("double") ? "D" : (fieldDescriptor.equals("float") ? "F" : (fieldDescriptor.equals("int") ? "I" : (fieldDescriptor.equals("long") ? "J" : (fieldDescriptor.equals("short") ? "S" : "L".concat(fieldDescriptor).concat(";"))))))));
            return dimensions.concat(fieldDescriptor);
        }
        throw new IllegalArgumentException(String.valueOf(type.toString()) + " is invalid");
    }

    protected boolean isValidRequest(HttpServletRequest request) {
        String className = ParamUtil.getString((HttpServletRequest)request, (String)"serviceClassName");
        return className.contains(".service.") && className.endsWith("ServiceUtil") && !className.endsWith("LocalServiceUtil") && !this._invalidClassNames.contains(className);
    }

    protected JSONObject toJSONObject(AssetEntryDisplay assetEntryDisplay) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        jsonObject.put("entryId", assetEntryDisplay.getEntryId());
        jsonObject.put("companyId", assetEntryDisplay.getCompanyId());
        jsonObject.put("userId", assetEntryDisplay.getUserId());
        jsonObject.put("userName", assetEntryDisplay.getUserName());
        jsonObject.put("createDate", assetEntryDisplay.getCreateDate());
        jsonObject.put("modifiedDate", assetEntryDisplay.getModifiedDate());
        jsonObject.put("classNameId", assetEntryDisplay.getClassNameId());
        jsonObject.put("className", assetEntryDisplay.getClassName());
        jsonObject.put("classPK", assetEntryDisplay.getClassPK());
        jsonObject.put("portletId", assetEntryDisplay.getPortletId());
        jsonObject.put("portletTitle", assetEntryDisplay.getPortletTitle());
        jsonObject.put("startDate", assetEntryDisplay.getStartDate());
        jsonObject.put("endDate", assetEntryDisplay.getEndDate());
        jsonObject.put("publishDate", assetEntryDisplay.getPublishDate());
        jsonObject.put("expirationDate", assetEntryDisplay.getExpirationDate());
        jsonObject.put("mimeType", assetEntryDisplay.getMimeType());
        jsonObject.put("title", assetEntryDisplay.getTitle());
        jsonObject.put("description", assetEntryDisplay.getDescription());
        jsonObject.put("summary", assetEntryDisplay.getSummary());
        jsonObject.put("url", assetEntryDisplay.getUrl());
        jsonObject.put("height", assetEntryDisplay.getHeight());
        jsonObject.put("width", assetEntryDisplay.getWidth());
        jsonObject.put("priority", assetEntryDisplay.getPriority());
        jsonObject.put("viewCount", assetEntryDisplay.getViewCount());
        jsonObject.put("assetCategoryIds", StringUtil.merge((long[])assetEntryDisplay.getCategoryIds()));
        jsonObject.put("assetTagNames", assetEntryDisplay.getTagNames());
        return jsonObject;
    }

    protected JSONObject toJSONObject(AssetEntryType assetEntryType) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        jsonObject.put("classNameId", assetEntryType.getClassNameId());
        jsonObject.put("className", assetEntryType.getClassName());
        jsonObject.put("portletId", assetEntryType.getPortletId());
        jsonObject.put("portletTitle", assetEntryType.getPortletTitle());
        return jsonObject;
    }
}

