/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.documentlibrary.util;

import com.liferay.documentlibrary.model.FileModel;
import com.liferay.documentlibrary.util.FileSystemHook;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdvancedFileSystemHook
extends FileSystemHook {
    private static final String _HOOK_EXTENSION = "afsh";

    @Override
    public void reindex(String[] ids) throws SearchException {
        String[] fileNames;
        long companyId = GetterUtil.getLong((String)ids[0]);
        String portletId = ids[1];
        long groupId = GetterUtil.getLong((String)ids[2]);
        long repositoryId = GetterUtil.getLong((String)ids[3]);
        File repositoryDir = this.getRepositoryDir(companyId, repositoryId);
        String[] stringArray = fileNames = FileUtil.listDirs((File)repositoryDir);
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            Collection<Document> documents = this.getDocuments(companyId, portletId, groupId, repositoryId, String.valueOf(repositoryDir.getPath()) + "/" + fileName);
            SearchEngineUtil.updateDocuments((long)companyId, documents);
            ++n2;
        }
    }

    @Override
    public void updateFile(long companyId, String portletId, long groupId, long repositoryId, String fileName, String newFileName, boolean reindex) throws PortalException {
        String[] fileNameVersions;
        super.updateFile(companyId, portletId, groupId, repositoryId, fileName, newFileName, reindex);
        File newFileNameDir = this.getFileNameDir(companyId, repositoryId, newFileName);
        String[] stringArray = fileNameVersions = FileUtil.listFiles((File)newFileNameDir);
        int n = fileNameVersions.length;
        int n2 = 0;
        while (n2 < n) {
            String fileNameVersion = stringArray[n2];
            String ext = FileUtil.getExtension((String)fileNameVersion);
            if (!ext.equals(_HOOK_EXTENSION)) {
                File fileNameVersionFile = new File(newFileNameDir + "/" + fileNameVersion);
                File newFileNameVersionFile = new File(newFileNameDir + "/" + FileUtil.stripExtension((String)fileNameVersion) + "." + _HOOK_EXTENSION);
                fileNameVersionFile.renameTo(newFileNameVersionFile);
            }
            ++n2;
        }
    }

    protected void buildPath(StringBundler sb, String fileNameFragment) {
        int fileNameFragmentLength = fileNameFragment.length();
        if (fileNameFragmentLength <= 2 || this.getDepth(sb.toString()) > 3) {
            return;
        }
        int i = 0;
        while (i < fileNameFragmentLength) {
            if (i + 2 < fileNameFragmentLength) {
                sb.append(fileNameFragment.substring(i, i + 2));
                sb.append("/");
                if (this.getDepth(sb.toString()) > 3) {
                    return;
                }
            }
            i += 2;
        }
    }

    protected int getDepth(String path) {
        String[] fragments = StringUtil.split((String)path, (String)"/");
        return fragments.length;
    }

    @Override
    protected File getDirNameDir(long companyId, long repositoryId, String dirName) {
        File repositoryDir = this.getRepositoryDir(companyId, repositoryId);
        return new File(repositoryDir + "/" + dirName);
    }

    protected Collection<Document> getDocuments(long companyId, String portletId, long groupId, long repositoryId, String fileName) throws SearchException {
        ArrayList<Document> documents = new ArrayList<Document>();
        String shortFileName = FileUtil.getShortFileName((String)fileName);
        if (shortFileName.equals("DLFE") || Validator.isNumber((String)shortFileName)) {
            String[] curFileNames;
            String[] stringArray = curFileNames = FileUtil.listDirs((String)fileName);
            int n = curFileNames.length;
            int n2 = 0;
            while (n2 < n) {
                String curFileName = stringArray[n2];
                documents.addAll(this.getDocuments(companyId, portletId, groupId, repositoryId, String.valueOf(fileName) + "/" + curFileName));
                ++n2;
            }
        } else {
            Indexer indexer = IndexerRegistryUtil.getIndexer(FileModel.class);
            FileModel fileModel = new FileModel();
            if (shortFileName.endsWith(_HOOK_EXTENSION)) {
                shortFileName = FileUtil.stripExtension((String)shortFileName);
            }
            fileModel.setCompanyId(companyId);
            fileModel.setFileName(shortFileName);
            fileModel.setGroupId(groupId);
            fileModel.setPortletId(portletId);
            fileModel.setRepositoryId(repositoryId);
            Document document = indexer.getDocument((Object)fileModel);
            if (document != null) {
                documents.add(document);
            }
        }
        return documents;
    }

    @Override
    protected File getFileNameDir(long companyId, long repositoryId, String fileName) {
        String ext = "." + FileUtil.getExtension((String)fileName);
        if (ext.equals(".")) {
            ext = String.valueOf(ext) + _HOOK_EXTENSION;
        }
        StringBundler sb = new StringBundler();
        String fileNameFragment = FileUtil.stripExtension((String)fileName);
        if (fileNameFragment.startsWith("DLFE-")) {
            fileNameFragment = fileNameFragment.substring(5);
            sb.append("DLFE/");
        }
        this.buildPath(sb, fileNameFragment);
        File repositoryDir = this.getRepositoryDir(companyId, repositoryId);
        File fileNameDir = new File(repositoryDir + "/" + sb.toString() + "/" + fileNameFragment + ext);
        return fileNameDir;
    }

    @Override
    protected File getFileNameVersionFile(long companyId, long repositoryId, String fileName, String version) {
        int pos;
        String ext = "." + FileUtil.getExtension((String)fileName);
        if (ext.equals(".")) {
            ext = String.valueOf(ext) + _HOOK_EXTENSION;
        }
        if ((pos = fileName.lastIndexOf(47)) == -1) {
            StringBundler sb = new StringBundler();
            String fileNameFragment = FileUtil.stripExtension((String)fileName);
            if (fileNameFragment.startsWith("DLFE-")) {
                fileNameFragment = fileNameFragment.substring(5);
                sb.append("DLFE/");
            }
            this.buildPath(sb, fileNameFragment);
            File repositoryDir = this.getRepositoryDir(companyId, repositoryId);
            return new File(repositoryDir + "/" + sb.toString() + "/" + fileNameFragment + ext + "/" + fileNameFragment + "_" + version + ext);
        }
        File fileNameDir = this.getDirNameDir(companyId, repositoryId, fileName);
        String fileNameFragment = FileUtil.stripExtension((String)fileName.substring(pos + 1));
        return new File(fileNameDir + "/" + fileNameFragment + "_" + version + ext);
    }

    @Override
    protected String getHeadVersionNumber(long companyId, long repositoryId, String fileName) {
        File fileNameDir = this.getFileNameDir(companyId, repositoryId, fileName);
        if (!fileNameDir.exists()) {
            return "1.0";
        }
        String[] versionNumbers = FileUtil.listFiles((File)fileNameDir);
        String headVersionNumber = "1.0";
        int i = 0;
        while (i < versionNumbers.length) {
            String versionNumber;
            String versionNumberFragment = versionNumbers[i];
            int x = versionNumberFragment.lastIndexOf(95);
            int y = versionNumberFragment.lastIndexOf(46);
            if (x > -1) {
                versionNumberFragment = versionNumberFragment.substring(x + 1, y);
            }
            if (DLUtil.compareVersions((String)(versionNumber = versionNumberFragment), (String)headVersionNumber) > 0) {
                headVersionNumber = versionNumber;
            }
            ++i;
        }
        return headVersionNumber;
    }
}

