/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapred;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.mapred.AvroJob;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapred.AvroValue;
import org.apache.avro.mapred.AvroWrapper;
import org.apache.avro.mapred.Pair;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.Serialization;
import org.apache.hadoop.io.serializer.Serializer;

public class AvroSerialization<T>
extends Configured
implements Serialization<AvroWrapper<T>> {
    private static final DecoderFactory FACTORY = new DecoderFactory();

    public boolean accept(Class<?> c) {
        return AvroWrapper.class.isAssignableFrom(c);
    }

    public Deserializer<AvroWrapper<T>> getDeserializer(Class<AvroWrapper<T>> c) {
        boolean isKey = AvroKey.class.isAssignableFrom(c);
        Schema schema = isKey ? Pair.getKeySchema(AvroJob.getMapOutputSchema(this.getConf())) : Pair.getValueSchema(AvroJob.getMapOutputSchema(this.getConf()));
        return new AvroWrapperDeserializer(new SpecificDatumReader(schema), isKey);
    }

    public Serializer<AvroWrapper<T>> getSerializer(Class<AvroWrapper<T>> c) {
        boolean isMap = this.getConf().getBoolean("mapred.task.is.map", false);
        Schema schema = !isMap ? AvroJob.getOutputSchema(this.getConf()) : (AvroKey.class.isAssignableFrom(c) ? Pair.getKeySchema(AvroJob.getMapOutputSchema(this.getConf())) : Pair.getValueSchema(AvroJob.getMapOutputSchema(this.getConf())));
        return new AvroWrapperSerializer(new SpecificDatumWriter(schema));
    }

    static {
        FACTORY.configureDirectDecoder(true);
    }

    private class AvroWrapperSerializer
    implements Serializer<AvroWrapper<T>> {
        private DatumWriter<T> writer;
        private OutputStream out;
        private BinaryEncoder encoder;

        public AvroWrapperSerializer(DatumWriter<T> writer) {
            this.writer = writer;
        }

        public void open(OutputStream out) {
            this.out = out;
            this.encoder = new BinaryEncoder(out);
        }

        public void serialize(AvroWrapper<T> wrapper) throws IOException {
            this.writer.write(wrapper.datum(), this.encoder);
        }

        public void close() throws IOException {
            this.out.close();
        }
    }

    private class AvroWrapperDeserializer
    implements Deserializer<AvroWrapper<T>> {
        private DatumReader<T> reader;
        private BinaryDecoder decoder;
        private boolean isKey;

        public AvroWrapperDeserializer(DatumReader<T> reader, boolean isKey) {
            this.reader = reader;
            this.isKey = isKey;
        }

        public void open(InputStream in) {
            this.decoder = FACTORY.createBinaryDecoder(in, this.decoder);
        }

        public AvroWrapper<T> deserialize(AvroWrapper<T> wrapper) throws IOException {
            Object datum = this.reader.read(wrapper == null ? null : (Object)wrapper.datum(), this.decoder);
            if (wrapper == null) {
                wrapper = this.isKey ? new AvroKey<Object>(datum) : new AvroValue<Object>(datum);
            } else {
                wrapper.datum(datum);
            }
            return wrapper;
        }

        public void close() throws IOException {
            this.decoder.inputStream().close();
        }
    }
}

