/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.resourcemanager.memoization;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.gcube.rest.resourcemanager.memoization.Cache;
import org.gcube.rest.resourcemanager.memoization.GuavaCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Memoizer
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(Memoizer.class);
    private Long maximumSize;
    private Long duration;
    private TimeUnit unit;
    private Object object;
    private Map<Method, Cache> caches = new HashMap<Method, Cache>();

    public Object build(Object object) {
        this.object = object;
        return Proxy.newProxyInstance(object.getClass().getClassLoader(), object.getClass().getInterfaces(), (InvocationHandler)this);
    }

    public Memoizer maximumSize(long maximumSize) {
        this.maximumSize = maximumSize;
        return this;
    }

    public Memoizer expireAfterWrite(long duration, TimeUnit unit) {
        this.duration = duration;
        this.unit = unit;
        return this;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getReturnType().equals(Void.TYPE)) {
            return this.invoke(method, args);
        }
        Cache cache = this.getCache(method);
        ArrayList<Object> key = new ArrayList<Object>();
        key.add(this.object);
        key.add(method);
        for (Object arg : args) {
            key.add(arg);
        }
        Object value = cache.get(key);
        if (value == null) {
            log.trace("cache miss for method: " + method.getDeclaringClass().getName() + "." + method.getName() + "(" + Arrays.asList(method.getGenericParameterTypes()).toString().replaceAll("(?:class |\\[|\\])", "") + ")");
            value = this.invoke(method, args);
            cache.put(key, value);
        } else {
            log.trace("cache hit for method: " + method.getDeclaringClass().getName() + "." + method.getName() + "(" + Arrays.asList(method.getGenericParameterTypes()).toString().replaceAll("(?:class |\\[|\\])", "") + ")");
        }
        return value;
    }

    private Object invoke(Method method, Object[] args) throws Throwable {
        try {
            return method.invoke(this.object, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    private synchronized Cache getCache(Method m) {
        Cache cache = this.caches.get(m);
        if (cache == null) {
            log.info("Initializing cache for " + m.getDeclaringClass().getName() + "." + m.getName() + "(" + Arrays.asList(m.getGenericParameterTypes()).toString().replaceAll("(?:class |\\[|\\])", "") + ")" + " with maximum size (" + this.maximumSize + ") and expiration after write (" + this.duration + this.unit.toString() + ")");
            cache = new GuavaCache.CacheBuilder().maximumSize(this.maximumSize).expireAfterWrite(this.duration, this.unit).build();
            this.caches.put(m, cache);
        }
        return cache;
    }
}

