/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.resourcemanager.memoization;

import java.util.concurrent.TimeUnit;
import org.gcube.rest.resourcemanager.memoization.Cache;

public class GuavaCache
implements Cache {
    private final com.google.common.cache.Cache<Object, Object> cache;

    private GuavaCache(final com.google.common.cache.Cache<Object, Object> cache) {
        this.cache = cache;
        Thread t = new Thread(){

            @Override
            public void run() {
                while (true) {
                    System.out.println(cache.stats().toString());
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    @Override
    public Object get(Object key) {
        return this.cache.getIfPresent(key);
    }

    @Override
    public void put(Object key, Object value) {
        this.cache.put(key, value);
    }

    public static class CacheBuilder {
        private Long maximumSize;
        private Long expirationDuration;
        private TimeUnit unit;

        public CacheBuilder maximumSize(Long maximumSize) {
            this.maximumSize = maximumSize;
            return this;
        }

        public CacheBuilder expireAfterWrite(Long duration, TimeUnit unit) {
            this.expirationDuration = duration;
            this.unit = unit;
            return this;
        }

        public GuavaCache build() {
            com.google.common.cache.CacheBuilder cacheBuilder = com.google.common.cache.CacheBuilder.newBuilder();
            if (this.maximumSize != null) {
                cacheBuilder.maximumSize(this.maximumSize.longValue());
            }
            if (this.expirationDuration != null && this.unit != null) {
                cacheBuilder.expireAfterWrite(this.expirationDuration.longValue(), this.unit);
            }
            return new GuavaCache(cacheBuilder.build());
        }
    }
}

