/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.core.util;

import java.io.Serializable;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.sf.ehcache.Element;
import org.gcube.application.framework.core.GenericResourceInfoI;
import org.gcube.application.framework.core.cache.CachesManager;
import org.gcube.application.framework.core.genericresources.model.ISGenericResource;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.application.framework.core.util.CardinalitiesResultBean;
import org.gcube.application.framework.core.util.Pair;
import org.gcube.application.framework.core.util.QueryString;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.ServiceInstance;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.publisher.RegistryPublisher;
import org.gcube.informationsystem.publisher.RegistryPublisherFactory;
import org.gcube.informationsystem.publisher.ScopedPublisher;
import org.gcube.informationsystem.publisher.stubs.registry.faults.PublisherException;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class GenericResource
implements GenericResourceInfoI {
    private static final Logger logger = LoggerFactory.getLogger(GenericResource.class);
    protected static ScopedPublisher scopedPublisher = null;
    protected static RegistryPublisher publisher = null;
    protected static DiscoveryClient<org.gcube.common.resources.gcore.GenericResource> client = null;
    ASLSession session;

    public GenericResource(String extrenalSessionID, String username) {
        this.session = SessionManager.getInstance().getASLSession(extrenalSessionID, username);
        try {
            ScopeProvider.instance.set(this.session.getScope());
            scopedPublisher = RegistryPublisherFactory.scopedPublisher();
            publisher = RegistryPublisherFactory.create();
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
        }
        if (client == null) {
            try {
                client = ICFactory.clientFor(org.gcube.common.resources.gcore.GenericResource.class);
            }
            catch (Exception e) {
                logger.error("Exception:", (Throwable)e);
                client = null;
            }
        }
    }

    public GenericResource(ASLSession session) {
        this.session = session;
        try {
            ScopeProvider.instance.set(session.getScope());
            scopedPublisher = RegistryPublisherFactory.scopedPublisher();
            publisher = RegistryPublisherFactory.create();
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
        }
        if (client == null) {
            try {
                client = ICFactory.clientFor(org.gcube.common.resources.gcore.GenericResource.class);
            }
            catch (Exception e) {
                logger.error("Exception:", (Throwable)e);
                client = null;
            }
        }
    }

    protected String getDLName() {
        return this.session.getOriginalScopeName();
    }

    protected List<ISGenericResource> getGenericResource(QueryString query) {
        List resList = (List)((Object)CachesManager.getInstance().getGenericResourceCache().get((Serializable)query).getValue());
        if (resList.isEmpty()) {
            logger.debug("no generic resources in cache " + (String)query.get("name"));
        }
        return resList;
    }

    public HashMap<String, org.gcube.common.resources.gcore.GenericResource> getAllTreeCollections(boolean onlyUserCollections) {
        HashMap<String, org.gcube.common.resources.gcore.GenericResource> pairs = new HashMap<String, org.gcube.common.resources.gcore.GenericResource>();
        XQuery query = null;
        try {
            query = ICFactory.queryFor(org.gcube.common.resources.gcore.GenericResource.class);
            query.addCondition("$resource/Profile/SecondaryType eq 'DataSource'");
            List results = client.submit((Query)query);
            if (results == null || results.size() == 0) {
                logger.debug("Couldn't find any tree collections within that scope! Will return empty list.");
            }
            for (org.gcube.common.resources.gcore.GenericResource gr : results) {
                pairs.put(gr.id(), gr);
            }
        }
        catch (Exception e) {
            logger.debug("Remote Exception:" + e.toString());
        }
        Iterator iter = pairs.entrySet().iterator();
        while (iter.hasNext()) {
            org.gcube.common.resources.gcore.GenericResource collection = (org.gcube.common.resources.gcore.GenericResource)iter.next().getValue();
            org.w3c.dom.Element body = collection.profile().body();
            if (body.getElementsByTagName("type").getLength() <= 0) continue;
            logger.debug("Filtering opensearch collection with ID: " + collection.id() + " Type: " + collection.type());
            iter.remove();
        }
        logger.debug("# of Tree Collections found: " + pairs.size());
        return pairs;
    }

    public HashMap<String, org.gcube.common.resources.gcore.GenericResource> getAllOpenSearchCollections(boolean onlyUserCollections) {
        HashMap<String, org.gcube.common.resources.gcore.GenericResource> pairs = new HashMap<String, org.gcube.common.resources.gcore.GenericResource>();
        XQuery query = null;
        try {
            query = ICFactory.queryFor(org.gcube.common.resources.gcore.GenericResource.class);
            query.addCondition("$resource/Profile/SecondaryType eq 'DataSource'");
            List results = client.submit((Query)query);
            if (results == null || results.size() == 0) {
                logger.debug("Couldn't find any OpenSearch collections within that scope! Will return empty list.");
            }
            for (org.gcube.common.resources.gcore.GenericResource gr : results) {
                pairs.put(gr.id(), gr);
            }
            Iterator<Map.Entry<String, org.gcube.common.resources.gcore.GenericResource>> iter = pairs.entrySet().iterator();
            while (iter.hasNext()) {
                org.gcube.common.resources.gcore.GenericResource collection = iter.next().getValue();
                org.w3c.dom.Element body = collection.profile().body();
                if (body.getElementsByTagName("type").getLength() != 0) continue;
                logger.debug("Removing non-opensearch collection: " + collection.id() + " Type: " + collection.type());
                iter.remove();
            }
            logger.debug("# of Opensearch Collections found: " + pairs.size());
        }
        catch (Exception e) {
            logger.debug("Remote Exception:" + e.toString());
        }
        return pairs;
    }

    public String getTreeResourceCardinality(String collectionID) {
        XQuery query = ICFactory.queryFor(ServiceInstance.class);
        query.addCondition("$resource/Data/child::*[local-name()='ServiceName']/string() eq 'tree-manager-service'");
        query.addCondition("$resource/Data/child::*[local-name()='SourceId']/string() eq '" + collectionID + "'");
        DiscoveryClient client = ICFactory.clientFor(ServiceInstance.class);
        List resources = client.submit((Query)query);
        String cardinality = "0";
        if (resources.size() == 0) {
            logger.debug("No collection '" + collectionID + "' found within scope " + ScopeProvider.instance.get());
        } else if (resources.size() == 1) {
            NodeList nodes = ((ServiceInstance)resources.get(0)).properties().customProperties().getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                if (!nodes.item(i).getLocalName().equalsIgnoreCase("Cardinality")) continue;
                cardinality = nodes.item(i).getTextContent();
            }
            logger.debug("Cardinality of collection '" + collectionID + "' is " + cardinality);
        } else {
            logger.debug("ERROR ! Found more than 1 resources '" + collectionID + "' within scope " + ScopeProvider.instance.get());
        }
        return cardinality;
    }

    public HashMap<String, String> getTreeResourcesCardinalities() {
        HashMap<String, String> outputResults = new HashMap<String, String>();
        DiscoveryClient client = ICFactory.clientFor(CardinalitiesResultBean.class);
        XQuery query = ICFactory.queryFor(ServiceInstance.class);
        query.addCondition("$resource/Data/child::*[local-name()='ServiceName']/string() eq 'tree-manager-service'");
        query.setResult("<Result><CollectionID>{$resource/Data/child::*[local-name()='SourceId']/string()}</CollectionID><Cardinality>{$resource/Data/child::*[local-name()='Cardinality']/string()}</Cardinality></Result>");
        List beanResults = client.submit((Query)query);
        if (beanResults.size() == 0) {
            logger.debug("There are no tree collection cardinality results");
        }
        for (CardinalitiesResultBean beanResult : beanResults) {
            outputResults.put(beanResult.collectionID, beanResult.cardinality);
        }
        return outputResults;
    }

    public boolean checkIfUser(org.gcube.common.resources.gcore.GenericResource resource) throws XPathExpressionException {
        XPathExpression userExpression = null;
        XPath xPath = XPathFactory.newInstance().newXPath();
        try {
            userExpression = xPath.compile("/SourceProperties/user");
        }
        catch (XPathExpressionException e) {
            logger.debug("Could not initiate the xpath expression for the user property");
            e.printStackTrace();
        }
        return Boolean.parseBoolean(userExpression.evaluate(new InputSource(new StringReader(resource.profile().bodyAsString()))));
    }

    @Override
    public String createGenericResource(ISGenericResource genericResource) throws RemoteException {
        try {
            org.gcube.common.resources.gcore.GenericResource gCubeRes = new org.gcube.common.resources.gcore.GenericResource();
            gCubeRes.newProfile();
            gCubeRes.profile().name(genericResource.getName());
            gCubeRes.profile().description(genericResource.getDescription());
            gCubeRes.profile().type(genericResource.getSecondaryType());
            gCubeRes.profile().newBody(genericResource.getBody());
            ArrayList<String> scopes = new ArrayList<String>();
            scopes.add(this.session.getScope());
            org.gcube.common.resources.gcore.GenericResource res = (org.gcube.common.resources.gcore.GenericResource)scopedPublisher.create((Resource)gCubeRes, scopes);
            logger.info("Created Generic Resource with id: " + res.id() + " on scope: " + ((Object)scopes).toString());
            logger.info("Adding it also in cache...");
            ArrayList<ISGenericResource> genRes = new ArrayList<ISGenericResource>();
            genRes.add(genericResource);
            QueryString query1 = new QueryString();
            query1.addParameter("id", genericResource.getId());
            query1.addParameter("vre", this.session.getScope());
            CachesManager.getInstance().getGenericResourceCache().put(new Element((Object)query1, genRes));
            logger.info("...added in cache");
            return res.id();
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            throw new RemoteException();
        }
    }

    public List<org.gcube.common.resources.gcore.GenericResource> getAllGenericResources() throws RemoteException {
        XQuery queryMan = null;
        try {
            queryMan = ICFactory.queryFor(org.gcube.common.resources.gcore.GenericResource.class);
            return client.submit((Query)queryMan);
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            throw new RemoteException();
        }
    }

    @Override
    public void updateGenericResourceByID(ISGenericResource genericResource) throws RemoteException {
        try {
            logger.info("Updating generic resource by ID");
            XQuery query = ICFactory.queryFor(org.gcube.common.resources.gcore.GenericResource.class);
            query.addCondition("$resource/ID eq '" + genericResource.getId() + "'");
            List result = client.submit((Query)query);
            if (result == null || result.size() == 0) {
                logger.info("Error during updateGenericResourceByID: Couldn't find the resource to update");
                return;
            }
            org.gcube.common.resources.gcore.GenericResource gCubeRes = (org.gcube.common.resources.gcore.GenericResource)result.get(0);
            logger.debug("Updating generic resource body from: " + gCubeRes.profile().bodyAsString());
            logger.debug("Updating generic resource body to: " + genericResource.getBody());
            gCubeRes.profile().name(genericResource.getName());
            gCubeRes.profile().description(genericResource.getDescription());
            gCubeRes.profile().newBody(genericResource.getBody());
            gCubeRes.profile().type(genericResource.getSecondaryType());
            try {
                ArrayList<String> scopes = new ArrayList<String>();
                for (String scope : gCubeRes.scopes().asCollection()) {
                    scopes.add(scope);
                }
                Resource res = publisher.update((Resource)gCubeRes);
                logger.info("Updated generic resource on IS ! New ID: " + res.id());
            }
            catch (Exception e) {
                logger.error("Exception during update of generic resource:", (Throwable)e);
            }
            QueryString query1 = new QueryString();
            query1.addParameter("name", genericResource.getName());
            query1.addParameter("vre", this.session.getScope());
            if (CachesManager.getInstance().getGenericResourceCache().isElementInMemory((Serializable)query1) || CachesManager.getInstance().getGenericResourceCache().isElementOnDisk((Serializable)query1)) {
                logger.info("Removing old generic resource from cache...");
                CachesManager.getInstance().getGenericResourceCache().get((Serializable)query1).setTimeToLive(0);
            } else {
                logger.info("The generic resource to replace in cache was not found");
            }
            logger.info("...and adding new generic resource in cache.");
            QueryString query2 = new QueryString();
            ArrayList<ISGenericResource> genRes = new ArrayList<ISGenericResource>();
            genRes.add(genericResource);
            query2.addParameter("id", genericResource.getId());
            query2.addParameter("vre", this.session.getScope());
            CachesManager.getInstance().getGenericResourceCache().put(new Element((Object)query2, genRes));
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            throw new RemoteException();
        }
    }

    @Override
    public List<Pair> getAvailableGenericResourceNames() throws RemoteException {
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        XQuery queryMan = null;
        try {
            queryMan = ICFactory.queryFor(org.gcube.common.resources.gcore.GenericResource.class);
            List results = client.submit((Query)queryMan);
            for (org.gcube.common.resources.gcore.GenericResource gr : results) {
                pairs.add(new Pair(gr.profile().name(), gr.id()));
            }
            return pairs;
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            throw new RemoteException();
        }
    }

    public List<ISGenericResource> getGenericResourcesByType(String type) throws RemoteException {
        return GenericResource.getGenericResourcesByType(this.session.getScope(), type);
    }

    public static List<ISGenericResource> getGenericResourcesByType(String scope, String type) throws RemoteException {
        ScopeProvider.instance.set(scope);
        ArrayList<ISGenericResource> output = new ArrayList<ISGenericResource>();
        XQuery queryMan = null;
        try {
            client = ICFactory.clientFor(org.gcube.common.resources.gcore.GenericResource.class);
            queryMan = ICFactory.queryFor(org.gcube.common.resources.gcore.GenericResource.class);
            queryMan.addCondition("$resource/Profile/SecondaryType eq '" + type + "'");
            List results = client.submit((Query)queryMan);
            for (org.gcube.common.resources.gcore.GenericResource res : results) {
                output.add(new ISGenericResource(res.id(), res.profile().name(), res.profile().description(), res.profile().bodyAsString(), res.profile().type()));
            }
            return output;
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            throw new RemoteException();
        }
    }

    @Override
    public List<ISGenericResource> getGenericResourceByID(String id) throws RemoteException {
        QueryString query = new QueryString();
        query.put("id", id);
        query.put("vre", this.getDLName());
        return this.getGenericResource(query);
    }

    @Override
    public List<ISGenericResource> getGenericResourceByName(String name) throws RemoteException {
        List<org.gcube.common.resources.gcore.GenericResource> allRes = this.getAllGenericResources();
        ArrayList<ISGenericResource> results = new ArrayList<ISGenericResource>();
        for (org.gcube.common.resources.gcore.GenericResource res : allRes) {
            if (!res.profile().name().equalsIgnoreCase(name)) continue;
            results.add(new ISGenericResource(res.id(), res.profile().name(), res.profile().description(), res.profile().bodyAsString(), res.profile().type()));
        }
        return results;
    }

    @Override
    public List<ISGenericResource> getGenericResourceForScenario() throws RemoteException {
        QueryString query = new QueryString();
        query.put("name", "ScenarioCollectionInfo");
        query.put("vre", this.getDLName());
        return this.getGenericResource(query);
    }

    @Override
    public void removeGenericResource(ISGenericResource genericResource) throws RemoteException {
        try {
            XQuery query = ICFactory.queryFor(org.gcube.common.resources.gcore.GenericResource.class);
            query.addCondition("$resource/ID eq '" + genericResource.getId() + "'");
            List result = client.submit((Query)query);
            if (result == null || result.size() == 0) {
                logger.error("Couldn't find the resource to delete! Returning...");
                return;
            }
            org.gcube.common.resources.gcore.GenericResource gCubeRes = (org.gcube.common.resources.gcore.GenericResource)result.get(0);
            publisher = RegistryPublisherFactory.create();
            Resource res = publisher.remove((Resource)gCubeRes);
            logger.info("Removed generic resource from IS");
            QueryString queryString = new QueryString();
            queryString.addParameter("id", genericResource.getId());
            queryString.addParameter("vre", this.session.getScope());
            if (CachesManager.getInstance().getGenericResourceCache().isElementInMemory((Serializable)queryString) || CachesManager.getInstance().getGenericResourceCache().isElementOnDisk((Serializable)queryString)) {
                genericResource = (ISGenericResource)((List)((Object)CachesManager.getInstance().getGenericResourceCache().get((Serializable)queryString).getValue())).get(0);
                CachesManager.getInstance().getGenericResourceCache().get((Serializable)queryString).setTimeToLive(0);
            }
        }
        catch (PublisherException e) {
            logger.error("Exception:", (Throwable)e);
            throw new RemoteException();
        }
    }

    static Document parseXMLFileToDOM(String XMLdoc) {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = dbFactory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(XMLdoc)));
            return doc;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public HashMap<String, Vector<String[]>> getAllXslts(String xsltType) {
        HashMap<String, Vector<String[]>> schemas_xslts = new HashMap<String, Vector<String[]>>();
        Vector<Object> xslts = null;
        List<String[]> result = null;
        try {
            result = GenericResource.retrieveGenericResourcesFromNameParts(xsltType, this.session.getScope());
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
        }
        if (result == null) {
            return null;
        }
        logger.info("Inside getAllXslts");
        logger.info("The type is: " + xsltType);
        for (int i = 0; i < result.size(); ++i) {
            String fullName = result.get(i)[0];
            logger.info("fullname: " + fullName);
            String id = result.get(i)[1];
            logger.info("id: " + id);
            String tmp = fullName.substring(xsltType.length() + 3, fullName.length());
            logger.info("tmp: " + tmp);
            String[] parts = tmp.split("-\\|-");
            String schemaName = parts[0];
            for (int k = 0; k < parts.length; ++k) {
                logger.info("part: " + parts[k]);
            }
            logger.info("schemaName: " + schemaName);
            String xsltName = parts[1];
            logger.info("xsltName: " + xsltName);
            xslts = schemas_xslts.get(schemaName);
            if (xslts == null) {
                xslts = new Vector();
                schemas_xslts.put(schemaName, xslts);
            }
            String[] s = new String[]{xsltName, id};
            xslts.add(s);
        }
        return schemas_xslts;
    }

    private static List<String[]> retrieveGenericResourcesFromNameParts(String nameParts, String scope) throws Exception {
        ScopeProvider.instance.set(scope);
        logger.debug("retrieveGenericResourcesFromNameParts");
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/Profile/Name eq '" + nameParts + "'");
        List queryResults = null;
        queryResults = client.submit((Query)query);
        if (queryResults == null || queryResults.size() == 0) {
            logger.error("Couldn't find the resource from name! Returning null");
            return null;
        }
        LinkedList<String[]> results = new LinkedList<String[]>();
        for (org.gcube.common.resources.gcore.GenericResource gr : queryResults) {
            String[] nameAndID = new String[]{gr.profile().name(), gr.id()};
            results.add(nameAndID);
        }
        return results;
    }
}

