/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.Bytes;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBAddress;
import com.mongodb.DBApiLayer;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.DBTCPConnector;
import com.mongodb.MongoException;
import com.mongodb.MongoOptions;
import com.mongodb.MongoURI;
import com.mongodb.ReplicaSetStatus;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.bson.io.PoolOutputBuffer;
import org.bson.util.SimplePool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mongo {
    public static final int MAJOR_VERSION = 2;
    public static final int MINOR_VERSION = 6;
    static int cleanerIntervalMS = Integer.parseInt(System.getProperty("com.mongodb.cleanerIntervalMS", "1000"));
    final ServerAddress _addr;
    final List<ServerAddress> _addrs;
    final MongoOptions _options;
    final DBTCPConnector _connector;
    final ConcurrentMap<String, DB> _dbs = new ConcurrentHashMap<String, DB>();
    private WriteConcern _concern = WriteConcern.NORMAL;
    final Bytes.OptionHolder _netOptions = new Bytes.OptionHolder(null);
    final DBCleanerThread _cleaner;
    SimplePool<PoolOutputBuffer> _bufferPool = new SimplePool<PoolOutputBuffer>(1000){

        @Override
        protected PoolOutputBuffer createNew() {
            return new PoolOutputBuffer();
        }
    };

    public static DB connect(DBAddress addr) {
        return new Mongo(addr).getDB(addr.getDBName());
    }

    public Mongo() throws UnknownHostException, MongoException {
        this(new ServerAddress());
    }

    public Mongo(String host) throws UnknownHostException, MongoException {
        this(new ServerAddress(host));
    }

    public Mongo(String host, MongoOptions options) throws UnknownHostException, MongoException {
        this(new ServerAddress(host), options);
    }

    public Mongo(String host, int port) throws UnknownHostException, MongoException {
        this(new ServerAddress(host, port));
    }

    public Mongo(ServerAddress addr) throws MongoException {
        this(addr, new MongoOptions());
    }

    public Mongo(ServerAddress addr, MongoOptions options) throws MongoException {
        this._addr = addr;
        this._addrs = null;
        this._options = options;
        this._applyMongoOptions();
        this._connector = new DBTCPConnector(this, this._addr);
        this._connector.start();
        this._cleaner = new DBCleanerThread();
        this._cleaner.start();
    }

    public Mongo(ServerAddress left, ServerAddress right) throws MongoException {
        this(left, right, new MongoOptions());
    }

    public Mongo(ServerAddress left, ServerAddress right, MongoOptions options) throws MongoException {
        this._addr = null;
        this._addrs = Arrays.asList(left, right);
        this._options = options;
        this._applyMongoOptions();
        this._connector = new DBTCPConnector(this, this._addrs);
        this._connector.start();
        this._cleaner = new DBCleanerThread();
        this._cleaner.start();
    }

    public Mongo(List<ServerAddress> replicaSetSeeds) throws MongoException {
        this(replicaSetSeeds, new MongoOptions());
    }

    public Mongo(List<ServerAddress> replicaSetSeeds, MongoOptions options) throws MongoException {
        this._addr = null;
        this._addrs = replicaSetSeeds;
        this._options = options;
        this._applyMongoOptions();
        this._connector = new DBTCPConnector(this, this._addrs);
        this._connector.start();
        this._cleaner = new DBCleanerThread();
        this._cleaner.start();
    }

    public Mongo(MongoURI uri) throws MongoException, UnknownHostException {
        this._options = uri.getOptions();
        this._applyMongoOptions();
        if (uri.getHosts().size() == 1) {
            this._addr = new ServerAddress(uri.getHosts().get(0));
            this._addrs = null;
            this._connector = new DBTCPConnector(this, this._addr);
        } else {
            ArrayList<ServerAddress> replicaSetSeeds = new ArrayList<ServerAddress>(uri.getHosts().size());
            for (String host : uri.getHosts()) {
                replicaSetSeeds.add(new ServerAddress(host));
            }
            this._addr = null;
            this._addrs = replicaSetSeeds;
            this._connector = new DBTCPConnector(this, replicaSetSeeds);
        }
        this._connector.start();
        this._cleaner = new DBCleanerThread();
        this._cleaner.start();
    }

    public DB getDB(String dbname) {
        DB db = (DB)this._dbs.get(dbname);
        if (db != null) {
            return db;
        }
        db = new DBApiLayer(this, dbname, this._connector);
        DB temp = this._dbs.putIfAbsent(dbname, db);
        if (temp != null) {
            return temp;
        }
        return db;
    }

    public Collection<DB> getUsedDatabases() {
        return this._dbs.values();
    }

    public List<String> getDatabaseNames() throws MongoException {
        BasicDBObject cmd = new BasicDBObject();
        cmd.put("listDatabases", (Object)1);
        CommandResult res = this.getDB("admin").command(cmd, this.getOptions());
        res.throwOnError();
        List l = (List)res.get("databases");
        ArrayList<String> list = new ArrayList<String>();
        for (Object o : l) {
            list.add(((BasicDBObject)o).getString("name"));
        }
        return list;
    }

    public void dropDatabase(String dbName) throws MongoException {
        this.getDB(dbName).dropDatabase();
    }

    public String getVersion() {
        return "2.6";
    }

    public String debugString() {
        return this._connector.debugString();
    }

    public String getConnectPoint() {
        return this._connector.getConnectPoint();
    }

    public DBTCPConnector getConnector() {
        return this._connector;
    }

    public ReplicaSetStatus getReplicaSetStatus() {
        return this._connector.getReplicaSetStatus();
    }

    public ServerAddress getAddress() {
        return this._connector.getAddress();
    }

    public List<ServerAddress> getAllAddress() {
        List<ServerAddress> result = this._connector.getAllAddress();
        if (result == null) {
            return Arrays.asList(this.getAddress());
        }
        return result;
    }

    public List<ServerAddress> getServerAddressList() {
        return this._connector.getServerAddressList();
    }

    public void close() {
        this._connector.close();
        this._cleaner.interrupt();
        try {
            this._cleaner.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void setWriteConcern(WriteConcern concern) {
        this._concern = concern;
    }

    public WriteConcern getWriteConcern() {
        return this._concern;
    }

    public void slaveOk() {
        this.addOption(4);
    }

    public void addOption(int option) {
        this._netOptions.add(option);
    }

    public void setOptions(int options) {
        this._netOptions.set(options);
    }

    public void resetOptions() {
        this._netOptions.reset();
    }

    public int getOptions() {
        return this._netOptions.get();
    }

    void _applyMongoOptions() {
        if (this._options.slaveOk) {
            this.slaveOk();
        }
        this.setWriteConcern(this._options.getWriteConcern());
    }

    public MongoOptions getMongoOptions() {
        return this._options;
    }

    public int getMaxBsonObjectSize() {
        int maxsize = this._connector.getMaxBsonObjectSize();
        if (maxsize == 0) {
            maxsize = this._connector.fetchMaxBsonObjectSize();
        }
        return maxsize > 0 ? maxsize : 0x400000;
    }

    public CommandResult fsync(boolean async) {
        BasicDBObject cmd = new BasicDBObject("fsync", (Object)1);
        if (async) {
            cmd.put("async", (Object)1);
        }
        return this.getDB("admin").command(cmd);
    }

    public CommandResult fsyncAndLock() {
        BasicDBObject cmd = new BasicDBObject("fsync", (Object)1);
        cmd.put("lock", (Object)1);
        return this.getDB("admin").command(cmd);
    }

    public DBObject unlock() {
        DB db = this.getDB("admin");
        DBCollection col = db.getCollection("$cmd.sys.unlock");
        return col.findOne();
    }

    public boolean isLocked() {
        DB db = this.getDB("admin");
        DBCollection col = db.getCollection("$cmd.sys.inprog");
        BasicDBObject res = (BasicDBObject)col.findOne();
        if (res.containsField("fsyncLock")) {
            return res.getInt("fsyncLock") == 1;
        }
        return false;
    }

    public String toString() {
        StringBuilder str = new StringBuilder("Mongo: ");
        List<ServerAddress> list = this.getServerAddressList();
        if (list == null || list.isEmpty()) {
            str.append("null");
        } else {
            for (ServerAddress addr : list) {
                str.append(addr.toString()).append(',');
            }
            str.deleteCharAt(str.length() - 1);
        }
        return str.toString();
    }

    class DBCleanerThread
    extends Thread {
        DBCleanerThread() {
            this.setDaemon(true);
            this.setName("MongoCleaner" + this.hashCode());
        }

        public void run() {
            while (Mongo.this._connector.isOpen()) {
                try {
                    try {
                        Thread.sleep(cleanerIntervalMS);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    for (DB db : Mongo.this._dbs.values()) {
                        db.cleanCursors(true);
                    }
                }
                catch (Throwable throwable) {
                }
            }
        }
    }

    public static class Holder {
        private static Holder _default = new Holder();
        private final ConcurrentMap<String, Mongo> _mongos = new ConcurrentHashMap<String, Mongo>();

        public Mongo connect(MongoURI uri) throws MongoException, UnknownHostException {
            String key = this._toKey(uri);
            Mongo m = (Mongo)this._mongos.get(key);
            if (m != null) {
                return m;
            }
            m = new Mongo(uri);
            Mongo temp = this._mongos.putIfAbsent(key, m);
            if (temp == null) {
                return m;
            }
            m.close();
            return temp;
        }

        String _toKey(MongoURI uri) {
            StringBuilder buf = new StringBuilder();
            for (String h : uri.getHosts()) {
                buf.append(h).append(",");
            }
            buf.append(uri.getOptions());
            buf.append(uri.getUsername());
            return buf.toString();
        }

        public static Holder singleton() {
            return _default;
        }
    }
}

