/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Future;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelListener;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.SuspectedException;
import org.jgroups.TimeoutException;
import org.jgroups.Transport;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.MethodLookup;
import org.jgroups.blocks.PullPushAdapter;
import org.jgroups.blocks.RspFilter;
import org.jgroups.util.Buffer;
import org.jgroups.util.NullFuture;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RpcDispatcher
extends MessageDispatcher
implements ChannelListener {
    protected Object server_obj = null;
    protected Marshaller2 req_marshaller = null;
    protected Marshaller2 rsp_marshaller = null;
    protected final List additionalChannelListeners = new ArrayList();
    protected MethodLookup method_lookup = null;

    public RpcDispatcher() {
    }

    public RpcDispatcher(Channel channel, MessageListener l, MembershipListener l2, Object server_obj) {
        super(channel, l, l2);
        channel.addChannelListener(this);
        this.server_obj = server_obj;
    }

    public RpcDispatcher(Channel channel, MessageListener l, MembershipListener l2, Object server_obj, boolean deadlock_detection) {
        super(channel, l, l2);
        channel.addChannelListener(this);
        this.server_obj = server_obj;
    }

    public RpcDispatcher(Channel channel, MessageListener l, MembershipListener l2, Object server_obj, boolean deadlock_detection, boolean concurrent_processing) {
        super(channel, l, l2, false, concurrent_processing);
        channel.addChannelListener(this);
        this.server_obj = server_obj;
    }

    public RpcDispatcher(PullPushAdapter adapter, Serializable id, MessageListener l, MembershipListener l2, Object server_obj) {
        super(adapter, id, l, l2);
        Transport t;
        if (this.adapter != null && (t = this.adapter.getTransport()) != null && t instanceof Channel) {
            ((Channel)t).addChannelListener(this);
        }
        this.server_obj = server_obj;
    }

    public String getName() {
        return "RpcDispatcher";
    }

    public Marshaller getRequestMarshaller() {
        return this.req_marshaller;
    }

    public void setRequestMarshaller(Marshaller m) {
        this.req_marshaller = m == null ? null : (m instanceof Marshaller2 ? (Marshaller2)m : new MarshallerAdapter(m));
    }

    public Marshaller getResponseMarshaller() {
        return this.rsp_marshaller;
    }

    public void setResponseMarshaller(Marshaller m) {
        this.rsp_marshaller = m == null ? null : (m instanceof Marshaller2 ? (Marshaller2)m : new MarshallerAdapter(m));
        if (this.corr != null) {
            this.corr.setMarshaller(this.rsp_marshaller);
        }
    }

    public Marshaller getMarshaller() {
        return this.req_marshaller;
    }

    public void setMarshaller(Marshaller m) {
        this.setRequestMarshaller(m);
    }

    public Object getServerObject() {
        return this.server_obj;
    }

    public void setServerObject(Object server_obj) {
        this.server_obj = server_obj;
    }

    public MethodLookup getMethodLookup() {
        return this.method_lookup;
    }

    public void setMethodLookup(MethodLookup method_lookup) {
        this.method_lookup = method_lookup;
    }

    @Override
    public RspList castMessage(Vector dests, Message msg, int mode, long timeout) {
        if (this.log.isErrorEnabled()) {
            this.log.error("this method should not be used with RpcDispatcher, but MessageDispatcher. Returning null");
        }
        return null;
    }

    @Override
    public Object sendMessage(Message msg, int mode, long timeout) throws TimeoutException, SuspectedException {
        if (this.log.isErrorEnabled()) {
            this.log.error("this method should not be used with RpcDispatcher, but MessageDispatcher. Returning null");
        }
        return null;
    }

    public RspList callRemoteMethods(Vector dests, String method_name, Object[] args, Class[] types, int mode, long timeout) {
        return this.callRemoteMethods(dests, method_name, args, types, mode, timeout, false);
    }

    public RspList callRemoteMethods(Vector dests, String method_name, Object[] args, Class[] types, int mode, long timeout, boolean use_anycasting) {
        return this.callRemoteMethods(dests, method_name, args, types, mode, timeout, use_anycasting, null);
    }

    public RspList callRemoteMethods(Vector dests, String method_name, Object[] args, Class[] types, int mode, long timeout, boolean use_anycasting, RspFilter filter) {
        MethodCall method_call = new MethodCall(method_name, args, types);
        return this.callRemoteMethods(dests, method_call, mode, timeout, use_anycasting, false, filter);
    }

    public RspList callRemoteMethods(Vector dests, String method_name, Object[] args, String[] signature, int mode, long timeout) {
        return this.callRemoteMethods(dests, method_name, args, signature, mode, timeout, false);
    }

    public RspList callRemoteMethods(Vector dests, String method_name, Object[] args, String[] signature, int mode, long timeout, boolean use_anycasting) {
        MethodCall method_call = new MethodCall(method_name, args, signature);
        return this.callRemoteMethods(dests, method_call, mode, timeout, use_anycasting);
    }

    public RspList callRemoteMethods(Vector dests, MethodCall method_call, int mode, long timeout) {
        return this.callRemoteMethods(dests, method_call, mode, timeout, false);
    }

    public RspList callRemoteMethods(Vector dests, MethodCall method_call, int mode, long timeout, boolean use_anycasting) {
        return this.callRemoteMethods(dests, method_call, mode, timeout, use_anycasting, false);
    }

    public RspList callRemoteMethods(Vector dests, MethodCall method_call, int mode, long timeout, boolean use_anycasting, boolean oob) {
        return this.callRemoteMethods(dests, method_call, mode, timeout, use_anycasting, oob, null);
    }

    public RspList callRemoteMethods(Vector dests, MethodCall method_call, int mode, long timeout, boolean use_anycasting, boolean oob, RspFilter filter) {
        return this.callRemoteMethods(dests, method_call, mode, timeout, use_anycasting, oob, false, filter);
    }

    public RspList callRemoteMethods(Vector dests, MethodCall method_call, int mode, long timeout, boolean use_anycasting, boolean oob, boolean dont_bundle, RspFilter filter) {
        byte[] buf;
        if (dests != null && dests.isEmpty()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace(new StringBuilder("destination list of ").append(method_call.getName()).append("() is empty: no need to send message"));
            }
            return new RspList();
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace(new StringBuilder("dests=").append(dests).append(", method_call=").append(method_call).append(", mode=").append(mode).append(", timeout=").append(timeout));
        }
        try {
            buf = this.req_marshaller != null ? (Object)this.req_marshaller.objectToBuffer(method_call) : Util.objectToByteBuffer(method_call);
        }
        catch (Exception e) {
            throw new RuntimeException("failure to marshal argument(s)", e);
        }
        Message msg = new Message();
        if (buf instanceof Buffer) {
            msg.setBuffer((Buffer)buf);
        } else {
            msg.setBuffer(buf);
        }
        if (oob) {
            msg.setFlag((byte)1);
        }
        if (dont_bundle) {
            msg.setFlag((byte)16);
        }
        RspList retval = super.castMessage(dests, msg, mode, timeout, use_anycasting, filter);
        if (this.log.isTraceEnabled()) {
            this.log.trace("responses: " + retval);
        }
        return retval;
    }

    public RspList callRemoteMethods(Vector dests, MethodCall method_call) {
        byte[] buf;
        if (dests != null && dests.isEmpty()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace(new StringBuilder("destination list of ").append(method_call.getName()).append("() is empty: no need to send message"));
            }
            return new RspList();
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace(new StringBuilder("dests=").append(dests).append(", method_call=").append(method_call).append(", mode=").append(method_call.getRequestMode()).append(", timeout=").append(method_call.getTimeout()));
        }
        try {
            buf = this.req_marshaller != null ? (Object)this.req_marshaller.objectToBuffer(method_call) : Util.objectToByteBuffer(method_call);
        }
        catch (Exception e) {
            throw new RuntimeException("failure to marshal argument(s)", e);
        }
        Message msg = new Message();
        if (buf instanceof Buffer) {
            msg.setBuffer((Buffer)buf);
        } else {
            msg.setBuffer(buf);
        }
        byte flags = method_call.getFlags();
        msg.setFlag(flags);
        RspList retval = super.castMessage(dests, msg, method_call.getRequestMode(), method_call.getTimeout(), method_call.isUseAnycasting(), method_call.getFilter());
        if (this.log.isTraceEnabled()) {
            this.log.trace("responses: " + retval);
        }
        return retval;
    }

    public Future<RspList> callRemoteMethodsWithFuture(Vector dests, MethodCall method_call, int mode, long timeout, boolean use_anycasting, boolean oob, RspFilter filter) {
        byte[] buf;
        if (dests != null && dests.isEmpty()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace(new StringBuilder("destination list of ").append(method_call.getName()).append("() is empty: no need to send message"));
            }
            return new NullFuture();
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace(new StringBuilder("dests=").append(dests).append(", method_call=").append(method_call).append(", mode=").append(mode).append(", timeout=").append(timeout));
        }
        try {
            buf = this.req_marshaller != null ? (Object)this.req_marshaller.objectToBuffer(method_call) : Util.objectToByteBuffer(method_call);
        }
        catch (Exception e) {
            throw new RuntimeException("failure to marshal argument(s)", e);
        }
        Message msg = new Message();
        if (buf instanceof Buffer) {
            msg.setBuffer((Buffer)buf);
        } else {
            msg.setBuffer(buf);
        }
        if (oob) {
            msg.setFlag((byte)1);
        }
        Future<RspList> retval = super.castMessageWithFuture(dests, msg, mode, timeout, use_anycasting, filter);
        if (this.log.isTraceEnabled()) {
            this.log.trace("responses: " + retval);
        }
        return retval;
    }

    public Future<RspList> callRemoteMethodsWithFuture(Vector dests, MethodCall method_call) {
        byte[] buf;
        if (dests != null && dests.isEmpty()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace(new StringBuilder("destination list of ").append(method_call.getName()).append("() is empty: no need to send message"));
            }
            return new NullFuture();
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace(new StringBuilder("dests=").append(dests).append(", method_call=").append(method_call).append(", mode=").append(method_call.getMode()).append(", timeout=").append(method_call.getTimeout()));
        }
        try {
            buf = this.req_marshaller != null ? (Object)this.req_marshaller.objectToBuffer(method_call) : Util.objectToByteBuffer(method_call);
        }
        catch (Exception e) {
            throw new RuntimeException("failure to marshal argument(s)", e);
        }
        Message msg = new Message();
        if (buf instanceof Buffer) {
            msg.setBuffer((Buffer)buf);
        } else {
            msg.setBuffer(buf);
        }
        msg.setFlag(method_call.getFlags());
        Future<RspList> retval = super.castMessageWithFuture(dests, msg, method_call.getRequestMode(), method_call.getTimeout(), method_call.isUseAnycasting(), method_call.getFilter());
        if (this.log.isTraceEnabled()) {
            this.log.trace("responses: " + retval);
        }
        return retval;
    }

    public Object callRemoteMethod(Address dest, String method_name, Object[] args, Class[] types, int mode, long timeout) throws Throwable {
        MethodCall method_call = new MethodCall(method_name, args, types);
        return this.callRemoteMethod(dest, method_call, mode, timeout);
    }

    public Object callRemoteMethod(Address dest, String method_name, Object[] args, String[] signature, int mode, long timeout) throws Throwable {
        MethodCall method_call = new MethodCall(method_name, args, signature);
        return this.callRemoteMethod(dest, method_call, mode, timeout);
    }

    public Object callRemoteMethod(Address dest, MethodCall method_call, int mode, long timeout) throws Throwable {
        return this.callRemoteMethod(dest, method_call, mode, timeout, false);
    }

    public Object callRemoteMethod(Address dest, MethodCall method_call, int mode, long timeout, boolean oob) throws Throwable {
        if (this.log.isTraceEnabled()) {
            this.log.trace("dest=" + dest + ", method_call=" + method_call + ", mode=" + mode + ", timeout=" + timeout);
        }
        byte[] buf = this.req_marshaller != null ? (Object)this.req_marshaller.objectToBuffer(method_call) : Util.objectToByteBuffer(method_call);
        Message msg = new Message(dest, null, null);
        if (buf instanceof Buffer) {
            msg.setBuffer((Buffer)buf);
        } else {
            msg.setBuffer(buf);
        }
        if (oob) {
            msg.setFlag((byte)1);
        }
        Object retval = super.sendMessage(msg, mode, timeout);
        if (this.log.isTraceEnabled()) {
            this.log.trace("retval: " + retval);
        }
        if (retval instanceof Throwable) {
            throw (Throwable)retval;
        }
        return retval;
    }

    public Object callRemoteMethod(Address dest, MethodCall call) throws Throwable {
        if (this.log.isTraceEnabled()) {
            this.log.trace("dest=" + dest + ", method_call=" + call + ", mode=" + call.getRequestMode() + ", timeout=" + call.getTimeout());
        }
        byte[] buf = this.req_marshaller != null ? (Object)this.req_marshaller.objectToBuffer(call) : Util.objectToByteBuffer(call);
        Message msg = new Message(dest, null, null);
        if (buf instanceof Buffer) {
            msg.setBuffer((Buffer)buf);
        } else {
            msg.setBuffer(buf);
        }
        msg.setFlag(call.getFlags());
        Object retval = super.sendMessage(msg, call.getRequestMode(), call.getTimeout());
        if (this.log.isTraceEnabled()) {
            this.log.trace("retval: " + retval);
        }
        if (retval instanceof Throwable) {
            throw (Throwable)retval;
        }
        return retval;
    }

    public <T> Future<T> callRemoteMethodWithFuture(Address dest, MethodCall method_call, int mode, long timeout, boolean oob) throws Throwable {
        if (this.log.isTraceEnabled()) {
            this.log.trace("dest=" + dest + ", method_call=" + method_call + ", mode=" + mode + ", timeout=" + timeout);
        }
        byte[] buf = this.req_marshaller != null ? (Object)this.req_marshaller.objectToBuffer(method_call) : Util.objectToByteBuffer(method_call);
        Message msg = new Message(dest, null, null);
        if (buf instanceof Buffer) {
            msg.setBuffer((Buffer)buf);
        } else {
            msg.setBuffer(buf);
        }
        if (oob) {
            msg.setFlag((byte)1);
        }
        return super.sendMessageWithFuture(msg, mode, timeout);
    }

    public <T> Future<T> callRemoteMethodWithFuture(Address dest, MethodCall call) throws Throwable {
        if (this.log.isTraceEnabled()) {
            this.log.trace("dest=" + dest + ", method_call=" + call + ", mode=" + call.getRequestMode() + ", timeout=" + call.getTimeout());
        }
        byte[] buf = this.req_marshaller != null ? (Object)this.req_marshaller.objectToBuffer(call) : Util.objectToByteBuffer(call);
        Message msg = new Message(dest, null, null);
        if (buf instanceof Buffer) {
            msg.setBuffer((Buffer)buf);
        } else {
            msg.setBuffer(buf);
        }
        msg.setFlag(call.getFlags());
        return super.sendMessageWithFuture(msg, call.getRequestMode(), call.getTimeout());
    }

    @Override
    protected void correlatorStarted() {
        if (this.corr != null) {
            this.corr.setMarshaller(this.rsp_marshaller);
        }
    }

    @Override
    public Object handle(Message req) {
        Object body;
        if (this.server_obj == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error("no method handler is registered. Discarding request.");
            }
            return null;
        }
        if (req == null || req.getLength() == 0) {
            if (this.log.isErrorEnabled()) {
                this.log.error("message or message buffer is null");
            }
            return null;
        }
        try {
            body = this.req_marshaller != null ? this.req_marshaller.objectFromByteBuffer(req.getBuffer(), req.getOffset(), req.getLength()) : req.getObject();
        }
        catch (Throwable e) {
            if (this.log.isErrorEnabled()) {
                this.log.error("exception marshalling object", e);
            }
            return e;
        }
        if (!(body instanceof MethodCall)) {
            if (this.log.isErrorEnabled()) {
                this.log.error("message does not contain a MethodCall object");
            }
            return new IllegalArgumentException("message does not contain a MethodCall object");
        }
        MethodCall method_call = (MethodCall)body;
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace("[sender=" + req.getSrc() + "], method_call: " + method_call);
            }
            if (method_call.getMode() == 5) {
                if (this.method_lookup == null) {
                    throw new Exception("MethodCall uses ID=" + method_call.getId() + ", but method_lookup has not been set");
                }
                Method m = this.method_lookup.findMethod(method_call.getId());
                if (m == null) {
                    throw new Exception("no method found for " + method_call.getId());
                }
                method_call.setMethod(m);
            }
            return method_call.invoke(this.server_obj);
        }
        catch (Throwable x) {
            return x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addChannelListener(ChannelListener l) {
        List list = this.additionalChannelListeners;
        synchronized (list) {
            if (this.additionalChannelListeners.contains(l)) {
                return false;
            }
            this.additionalChannelListeners.add(l);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeChannelListener(ChannelListener l) {
        List list = this.additionalChannelListeners;
        synchronized (list) {
            return this.additionalChannelListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelConnected(Channel channel) {
        List list = this.additionalChannelListeners;
        synchronized (list) {
            for (ChannelListener l : this.additionalChannelListeners) {
                try {
                    l.channelConnected(channel);
                }
                catch (Throwable t) {
                    this.log.warn("channel listener failed", t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelDisconnected(Channel channel) {
        this.stop();
        List list = this.additionalChannelListeners;
        synchronized (list) {
            for (ChannelListener l : this.additionalChannelListeners) {
                try {
                    l.channelDisconnected(channel);
                }
                catch (Throwable t) {
                    this.log.warn("channel listener failed", t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelClosed(Channel channel) {
        this.stop();
        List list = this.additionalChannelListeners;
        synchronized (list) {
            for (ChannelListener l : this.additionalChannelListeners) {
                try {
                    l.channelClosed(channel);
                }
                catch (Throwable t) {
                    this.log.warn("channel listener failed", t);
                }
            }
        }
    }

    @Override
    public void channelShunned() {
    }

    @Override
    public void channelReconnected(Address new_addr) {
    }

    public static class MarshallerAdapter
    implements Marshaller2 {
        private final Marshaller marshaller;

        public MarshallerAdapter(Marshaller marshaller) {
            this.marshaller = marshaller;
        }

        public byte[] objectToByteBuffer(Object obj) throws Exception {
            return this.marshaller.objectToByteBuffer(obj);
        }

        public Object objectFromByteBuffer(byte[] buf) throws Exception {
            return buf == null ? null : this.marshaller.objectFromByteBuffer(buf);
        }

        public Buffer objectToBuffer(Object obj) throws Exception {
            byte[] buf = this.marshaller.objectToByteBuffer(obj);
            return new Buffer(buf, 0, buf.length);
        }

        public Object objectFromByteBuffer(byte[] buf, int offset, int length) throws Exception {
            if (buf == null || offset == 0 && length == buf.length) {
                return this.marshaller.objectFromByteBuffer(buf);
            }
            byte[] tmp = new byte[length];
            System.arraycopy(buf, offset, tmp, 0, length);
            return this.marshaller.objectFromByteBuffer(tmp);
        }
    }

    public static interface Marshaller2
    extends Marshaller {
        public Buffer objectToBuffer(Object var1) throws Exception;

        public Object objectFromByteBuffer(byte[] var1, int var2, int var3) throws Exception;
    }

    public static interface Marshaller {
        public byte[] objectToByteBuffer(Object var1) throws Exception;

        public Object objectFromByteBuffer(byte[] var1) throws Exception;
    }
}

