/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.join;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.query.lucene.HierarchyResolver;
import org.apache.jackrabbit.core.query.lucene.MultiColumnQueryHits;
import org.apache.jackrabbit.core.query.lucene.ScoreNode;
import org.apache.jackrabbit.core.query.lucene.join.AbstractCondition;
import org.apache.jackrabbit.core.query.lucene.join.AncestorNodeJoin;
import org.apache.jackrabbit.core.query.lucene.join.AncestorPathNodeJoin;
import org.apache.jackrabbit.core.query.lucene.join.ChildNodeJoin;
import org.apache.jackrabbit.core.query.lucene.join.Condition;
import org.apache.jackrabbit.core.query.lucene.join.DescendantNodeJoin;
import org.apache.jackrabbit.core.query.lucene.join.DescendantPathNodeJoin;
import org.apache.jackrabbit.core.query.lucene.join.EquiJoin;
import org.apache.jackrabbit.core.query.lucene.join.ParentNodeJoin;
import org.apache.jackrabbit.core.query.lucene.join.SameNodeJoin;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.query.jsr283.qom.QueryObjectModelConstants;
import org.apache.jackrabbit.spi.commons.query.qom.ChildNodeJoinConditionImpl;
import org.apache.jackrabbit.spi.commons.query.qom.DefaultQOMTreeVisitor;
import org.apache.jackrabbit.spi.commons.query.qom.DescendantNodeJoinConditionImpl;
import org.apache.jackrabbit.spi.commons.query.qom.EquiJoinConditionImpl;
import org.apache.jackrabbit.spi.commons.query.qom.JoinConditionImpl;
import org.apache.jackrabbit.spi.commons.query.qom.QOMTreeVisitor;
import org.apache.jackrabbit.spi.commons.query.qom.SameNodeJoinConditionImpl;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.SortComparatorSource;

public class Join
implements MultiColumnQueryHits,
QueryObjectModelConstants {
    protected final MultiColumnQueryHits outer;
    protected final int outerScoreNodeIndex;
    protected final boolean innerJoin;
    protected final Condition condition;
    protected final Name[] selectorNames;
    protected final ScoreNode[] emptyInnerHits;
    protected final List buffer = new LinkedList();

    private Join(MultiColumnQueryHits outer, int outerScoreNodeIndex, boolean innerJoin, Condition condition) {
        this.outer = outer;
        this.outerScoreNodeIndex = outerScoreNodeIndex;
        this.innerJoin = innerJoin;
        this.condition = condition;
        this.emptyInnerHits = new ScoreNode[condition.getInnerSelectorNames().length];
        this.selectorNames = new Name[outer.getSelectorNames().length + this.emptyInnerHits.length];
        System.arraycopy(outer.getSelectorNames(), 0, this.selectorNames, 0, outer.getSelectorNames().length);
        System.arraycopy(condition.getInnerSelectorNames(), 0, this.selectorNames, outer.getSelectorNames().length, this.emptyInnerHits.length);
    }

    public static Join create(final MultiColumnQueryHits left, final MultiColumnQueryHits right, final int joinType, JoinConditionImpl condition, final IndexReader reader, final HierarchyResolver resolver, final SortComparatorSource scs, final HierarchyManager hmgr) throws IOException {
        try {
            return (Join)condition.accept((QOMTreeVisitor)new DefaultQOMTreeVisitor(){
                private boolean isInner;
                private MultiColumnQueryHits outer;
                private int outerIdx;
                {
                    this.isInner = joinType == 101;
                }

                public Object visit(DescendantNodeJoinConditionImpl node, Object data) throws Exception {
                    AbstractCondition c;
                    MultiColumnQueryHits ancestor = Join.getSourceWithName(node.getAncestorSelectorQName(), left, right);
                    MultiColumnQueryHits descendant = Join.getSourceWithName(node.getDescendantSelectorQName(), left, right);
                    if (this.isInner || descendant == left && joinType == 102 || descendant == right && joinType == 103) {
                        this.outer = descendant;
                        this.outerIdx = Join.getIndex(this.outer, node.getDescendantSelectorQName());
                        c = new DescendantNodeJoin(ancestor, node.getAncestorSelectorQName(), reader, resolver);
                    } else {
                        this.outer = ancestor;
                        this.outerIdx = Join.getIndex(this.outer, node.getAncestorSelectorQName());
                        c = new AncestorNodeJoin(descendant, node.getDescendantSelectorQName(), reader, resolver);
                    }
                    return new Join(this.outer, this.outerIdx, this.isInner, c);
                }

                public Object visit(EquiJoinConditionImpl node, Object data) throws Exception {
                    Name outerPropName;
                    Name innerPropName;
                    Name innerName;
                    MultiColumnQueryHits inner;
                    MultiColumnQueryHits src1 = Join.getSourceWithName(node.getSelector1QName(), left, right);
                    MultiColumnQueryHits src2 = Join.getSourceWithName(node.getSelector2QName(), left, right);
                    if (this.isInner || src1 == left && joinType == 102 || src1 == right && joinType == 103) {
                        this.outer = src1;
                        this.outerIdx = Join.getIndex(this.outer, node.getSelector1QName());
                        inner = src2;
                        innerName = node.getSelector2QName();
                        innerPropName = node.getProperty2QName();
                        outerPropName = node.getProperty1QName();
                    } else {
                        this.outer = src2;
                        this.outerIdx = Join.getIndex(this.outer, node.getSelector2QName());
                        inner = src1;
                        innerName = node.getSelector1QName();
                        innerPropName = node.getProperty1QName();
                        outerPropName = node.getProperty2QName();
                    }
                    EquiJoin c = new EquiJoin(inner, Join.getIndex(inner, innerName), scs, reader, innerPropName, outerPropName);
                    return new Join(this.outer, this.outerIdx, this.isInner, c);
                }

                public Object visit(ChildNodeJoinConditionImpl node, Object data) throws Exception {
                    AbstractCondition c;
                    MultiColumnQueryHits child = Join.getSourceWithName(node.getChildSelectorQName(), left, right);
                    MultiColumnQueryHits parent = Join.getSourceWithName(node.getParentSelectorQName(), left, right);
                    if (child == left && joinType == 102 || child == right && joinType == 103) {
                        this.outer = child;
                        this.outerIdx = Join.getIndex(this.outer, node.getChildSelectorQName());
                        c = new ChildNodeJoin(parent, reader, resolver, node);
                    } else {
                        this.outer = parent;
                        this.outerIdx = Join.getIndex(this.outer, node.getParentSelectorQName());
                        c = new ParentNodeJoin(child, reader, resolver, node);
                    }
                    return new Join(this.outer, this.outerIdx, this.isInner, c);
                }

                public Object visit(SameNodeJoinConditionImpl node, Object data) throws Exception {
                    AbstractCondition c;
                    MultiColumnQueryHits src1 = Join.getSourceWithName(node.getSelector1QName(), left, right);
                    MultiColumnQueryHits src2 = Join.getSourceWithName(node.getSelector2QName(), left, right);
                    if (this.isInner || src1 == left && joinType == 102 || src1 == right && joinType == 103) {
                        this.outer = src1;
                        this.outerIdx = Join.getIndex(this.outer, node.getSelector1QName());
                        c = node.getSelector2QPath() != null ? new DescendantPathNodeJoin(src2, node.getSelector2QName(), node.getSelector2QPath(), hmgr) : new SameNodeJoin(src2, node.getSelector2QName(), reader);
                    } else {
                        this.outer = src2;
                        this.outerIdx = Join.getIndex(this.outer, node.getSelector2QName());
                        c = node.getSelector2QPath() != null ? new AncestorPathNodeJoin(src1, node.getSelector1QName(), node.getSelector2QPath(), hmgr) : new SameNodeJoin(src1, node.getSelector1QName(), reader);
                    }
                    return new Join(this.outer, this.outerIdx, this.isInner, c);
                }
            }, null);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            IOException ex = new IOException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    public ScoreNode[] nextScoreNodes() throws IOException {
        if (!this.buffer.isEmpty()) {
            return (ScoreNode[])this.buffer.remove(0);
        }
        do {
            ScoreNode[] sn;
            if ((sn = this.outer.nextScoreNodes()) == null) {
                return null;
            }
            ScoreNode[][] nodes = this.condition.getMatchingScoreNodes(sn[this.outerScoreNodeIndex]);
            if (nodes != null) {
                for (int i = 0; i < nodes.length; ++i) {
                    ScoreNode[] node = nodes[i];
                    ScoreNode[] tmp = new ScoreNode[sn.length + node.length];
                    System.arraycopy(sn, 0, tmp, 0, sn.length);
                    System.arraycopy(node, 0, tmp, sn.length, node.length);
                    this.buffer.add(tmp);
                }
            } else {
                if (this.innerJoin) continue;
                ScoreNode[] tmp = new ScoreNode[sn.length + this.emptyInnerHits.length];
                System.arraycopy(sn, 0, tmp, 0, sn.length);
                System.arraycopy(this.emptyInnerHits, 0, tmp, sn.length, this.emptyInnerHits.length);
                this.buffer.add(tmp);
            }
        } while (this.buffer.isEmpty());
        return (ScoreNode[])this.buffer.remove(0);
    }

    public Name[] getSelectorNames() {
        return this.selectorNames;
    }

    public void close() throws IOException {
        IOException ex;
        block5: {
            ex = null;
            try {
                this.outer.close();
            }
            catch (IOException e) {
                ex = e;
            }
            try {
                this.condition.close();
            }
            catch (IOException e) {
                if (ex != null) break block5;
                ex = e;
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    public int getSize() {
        return -1;
    }

    public void skip(int n) throws IOException {
        while (n-- > 0) {
            if (this.nextScoreNodes() != null) continue;
            return;
        }
    }

    protected static MultiColumnQueryHits getSourceWithName(Name selectorName, MultiColumnQueryHits left, MultiColumnQueryHits right) {
        if (Arrays.asList(left.getSelectorNames()).contains(selectorName)) {
            return left;
        }
        if (Arrays.asList(right.getSelectorNames()).contains(selectorName)) {
            return right;
        }
        throw new IllegalArgumentException("unknown selector name: " + selectorName);
    }

    protected static int getIndex(MultiColumnQueryHits source, Name selectorName) {
        return Arrays.asList(source.getSelectorNames()).indexOf(selectorName);
    }
}

