/*
 * Decompiled with CFR 0.152.
 */
package jodd.servlet.tag;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;
import jodd.servlet.HtmlEncoder;
import jodd.servlet.HtmlFormUtil;
import jodd.servlet.HtmlTag;
import jodd.servlet.JspValueResolver;
import jodd.util.StringUtil;

public class FormTag
extends BodyTagSupport {
    private static final String INPUT = "input";
    private static final String TYPE = "type";
    private static final String VALUE = "value";
    private static final String TEXT = "text";
    private static final String SELECT = "select";
    private static final String HIDDEN = "hidden";
    private static final String IMAGE = "image";
    private static final String PASSWORD = "password";
    private static final String CHECKBOX = "checkbox";
    private static final String TRUE = "true";
    private static final String CHECKED = "checked";
    private static final String RADIO = "radio";
    private static final String TEXTAREA = "textarea";
    private static final String NAME = "name";
    private static final String OPTION = "option";
    private static final String SELECTED = "selected";
    private static final String IDREF = "@id(";

    public int doStartTag() {
        return 2;
    }

    public int doAfterBody() throws JspException {
        BodyContent body = this.getBodyContent();
        JspWriter out = body.getEnclosingWriter();
        String bodytext = this.populateForm(body.getString(), new FieldResolver(){

            public Object value(String name) {
                return JspValueResolver.resolveProperty(name, FormTag.this.pageContext);
            }
        });
        try {
            out.print(bodytext);
        }
        catch (IOException ioex) {
            throw new JspException((Throwable)ioex);
        }
        return 0;
    }

    public int doEndTag() {
        return 6;
    }

    protected String populateForm(String html, FieldResolver resolver) {
        int s = 0;
        StringBuilder result = new StringBuilder((int)((double)html.length() * 1.2));
        String currentSelectName = null;
        HtmlTag tag = null;
        block0: while (true) {
            Object vals;
            String tagValue;
            if (tag != null) {
                result.append(tag);
            }
            if ((tag = HtmlTag.locateNextTag(html, s)) == null) break;
            result.append(html.substring(s, tag.getStartIndex()));
            s = tag.getNextIndex();
            String tagName = tag.getTagName();
            if (tag.isEndTag()) {
                if (!tagName.equals(SELECT)) continue;
                currentSelectName = null;
                continue;
            }
            if (tagName.equals(INPUT)) {
                String tagValue2;
                Object valueObject;
                String name;
                String tagType = tag.getAttribute(TYPE);
                if (tagType == null || (name = tag.getAttribute(NAME)) == null || (valueObject = resolver.value(name)) == null) continue;
                String value = valueObject.toString();
                if ((tagType = tagType.toLowerCase()).equals(TEXT)) {
                    tag.setAttribute(VALUE, value);
                    continue;
                }
                if (tagType.equals(HIDDEN)) {
                    tag.setAttribute(VALUE, value);
                    continue;
                }
                if (tagType.equals(IMAGE)) {
                    tag.setAttribute(VALUE, value);
                    continue;
                }
                if (tagType.equals(PASSWORD)) {
                    tag.setAttribute(VALUE, value);
                    continue;
                }
                if (tagType.equals(CHECKBOX)) {
                    String tagValue3 = tag.getAttribute(VALUE);
                    if (tagValue3 == null) {
                        tagValue3 = TRUE;
                    }
                    if (valueObject.getClass().isArray()) {
                        String[] vs;
                        String[] arr$ = vs = StringUtil.toStringArray(valueObject);
                        int len$ = arr$.length;
                        int i$ = 0;
                        while (true) {
                            if (i$ >= len$) continue block0;
                            String vsk = arr$[i$];
                            if (vsk != null && vsk.equals(tagValue3)) {
                                tag.setAttribute(CHECKED);
                            }
                            ++i$;
                        }
                    }
                    if (!tagValue3.equals(value)) continue;
                    tag.setAttribute(CHECKED);
                    continue;
                }
                if (!tagType.equals(RADIO) || (tagValue2 = tag.getAttribute(VALUE)) == null || !tagValue2.equals(value)) continue;
                tag.setAttribute(CHECKED);
                continue;
            }
            if (tagName.equals(TEXTAREA)) {
                String name = tag.getAttribute(NAME);
                Object valueObject = resolver.value(name);
                if (valueObject == null) continue;
                tag.setSuffixText(HtmlEncoder.text(valueObject.toString()));
                continue;
            }
            if (tagName.equals(SELECT)) {
                currentSelectName = tag.getAttribute(NAME);
                continue;
            }
            if (!tagName.equals(OPTION) || currentSelectName == null || (tagValue = tag.getAttribute(VALUE)) == null || (vals = resolver.value(currentSelectName)) == null) continue;
            if (vals.getClass().isArray()) {
                String[] vs;
                String[] arr$ = vs = StringUtil.toStringArray(vals);
                int len$ = arr$.length;
                int i$ = 0;
                while (true) {
                    if (i$ >= len$) continue block0;
                    String vsk = arr$[i$];
                    if (vsk != null && vsk.equals(tagValue)) {
                        tag.setAttribute(SELECTED);
                    }
                    ++i$;
                }
            }
            String value = StringUtil.toString(vals);
            if (!value.equals(tagValue)) continue;
            tag.setAttribute(SELECTED);
        }
        result.append(html.substring(s));
        return result.toString();
    }

    protected static String replaceReference(String formId, String value) {
        int ndx = value.indexOf(IDREF);
        if (ndx == -1) {
            return null;
        }
        int ndx2 = value.indexOf(41, ndx);
        if (ndx2 == -1) {
            throw new IllegalArgumentException("ID reference not closed: '" + value + "'.");
        }
        String ref = value.substring(ndx + IDREF.length(), ndx2);
        return value.substring(0, ndx) + formId + HtmlFormUtil.name2id(ref) + value.substring(ndx2 + 1);
    }

    public static interface FieldResolver {
        public Object value(String var1);
    }
}

