/*
 * Decompiled with CFR 0.152.
 */
package jodd.servlet;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;
import jodd.io.FileNameUtil;
import jodd.servlet.upload.FileUpload;
import jodd.servlet.upload.MultipartRequestWrapper;
import jodd.util.Base64;
import jodd.util.MimeTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletUtil {
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String TYPE_MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String HEADER_AUTHORIZATION = "Authorization";
    public static final String CONTENT_DISPOSITION = "Content-Disposition";
    public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    private static final String JAVAX_SERVLET_ERROR_EXCEPTION = "javax.servlet.error.exception";
    public static final String METHOD_GET = "GET";
    public static final String METHOD_HEAD = "HEAD";
    public static final String METHOD_PUT = "PUT";
    public static final String METHOD_POST = "POST";
    public static final String METHOD_DELETE = "DELETE";
    public static final String METHOD_OPTIONS = "OPTIONS";
    public static final String METHOD_TRACE = "TRACE";
    public static final String METHOD_CONNECT = "CONNECT";
    public static final String VALID_SCHEME_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+.-";

    public static boolean isMultipartRequest(HttpServletRequest request) {
        String type = request.getHeader(HEADER_CONTENT_TYPE);
        return type != null && type.startsWith(TYPE_MULTIPART_FORM_DATA);
    }

    public static void setBrowserVary(HttpServletResponse response) {
        response.setHeader("Vary", "User-Agent");
    }

    public static String getAuthUsername(HttpServletRequest request) {
        String header = request.getHeader(HEADER_AUTHORIZATION);
        if (header == null) {
            return null;
        }
        String encoded = header.substring(header.indexOf(32) + 1);
        String decoded = new String(Base64.decode(encoded));
        return decoded.substring(0, decoded.indexOf(58));
    }

    public static String getAuthPassword(HttpServletRequest request) {
        String header = request.getHeader(HEADER_AUTHORIZATION);
        if (header == null) {
            return null;
        }
        String encoded = header.substring(header.indexOf(32) + 1);
        String decoded = new String(Base64.decode(encoded));
        return decoded.substring(decoded.indexOf(58) + 1);
    }

    public static void requireAuthentication(HttpServletResponse resp, String realm) throws IOException {
        resp.setHeader(WWW_AUTHENTICATE, "Basic realm=\"" + realm + '\"');
        resp.sendError(401);
    }

    public static void prepareDownload(HttpServletResponse response, String fileName) {
        ServletUtil.prepareDownload(response, fileName, -1);
    }

    public static void prepareDownload(HttpServletResponse response, String fileName, int fileSize) {
        String extension = FileNameUtil.getExtension(fileName);
        String name = FileNameUtil.getName(fileName);
        String mime = MimeTypes.getMimeType(extension);
        response.setContentType(mime);
        response.setHeader(CONTENT_DISPOSITION, "attachment;filename=\"" + name + '\"');
        if (fileSize >= 0) {
            response.setContentLength(fileSize);
        }
    }

    public static void prepareDownload(HttpServletResponse response, File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException("Unable to prepare file for download. File '" + file + "' doesn't exist.");
        }
        if (file.length() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Unable to prepare file for download. File '" + file + "' is too big.");
        }
        ServletUtil.prepareDownload(response, file.getAbsolutePath(), (int)file.length());
    }

    public static Cookie getCookie(HttpServletRequest request, String cookieName) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(cookieName)) continue;
                return cookie;
            }
        }
        return null;
    }

    public static Cookie[] getAllCookies(HttpServletRequest request, String cookieName) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        ArrayList<Cookie> list = new ArrayList<Cookie>(cookies.length);
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equals(cookieName)) continue;
            list.add(cookie);
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new Cookie[list.size()]);
    }

    public static Object getRequestParameter(ServletRequest request, String name) {
        String[] values = request.getParameterValues(name);
        if (values == null) {
            return null;
        }
        if (values.length == 1) {
            return values[0];
        }
        return values;
    }

    public static void setRequestAttributes(ServletRequest request, Map<String, Object> attributes) {
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            request.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    public static Map<String, Object> getRequestAttributes(ServletRequest request) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ServletUtil.loadRequestAttributes(map, request);
        return map;
    }

    public static void loadRequestAttributes(Map<String, Object> map, ServletRequest request) {
        Enumeration names = request.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            map.put(name, request.getAttribute(name));
        }
    }

    public static Map<String, Object> getRequestParameters(ServletRequest request) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ServletUtil.loadRequestParameters(map, request);
        return map;
    }

    public static void loadRequestParameters(Map<String, Object> map, ServletRequest request) {
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            map.put(name, ServletUtil.getRequestParameter(request, name));
        }
    }

    public static void loadSessionAttributes(Map<String, Object> destination, HttpSession session) {
        Enumeration names = session.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            destination.put(name, session.getAttribute(name));
        }
    }

    public static Map<String, Object> getSessionAttributes(HttpSession session) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ServletUtil.loadSessionAttributes(map, session);
        return map;
    }

    public static void setSessionAttributes(HttpSession session, Map<String, Object> attributes) {
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            session.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    public static Object attrValue(PageContext pageContext, String name) {
        Object value = pageContext.getAttribute(name);
        if (value != null) {
            return value;
        }
        return ServletUtil.attrValue((HttpServletRequest)pageContext.getRequest(), name);
    }

    public static Object attrValue(HttpServletRequest request, String name) {
        Object value = request.getAttribute(name);
        if (value != null) {
            return value;
        }
        value = request.getSession().getAttribute(name);
        if (value != null) {
            return value;
        }
        return request.getSession().getServletContext().getAttribute(name);
    }

    public static Object value(PageContext pageContext, String name) {
        Object value = pageContext.getAttribute(name);
        if (value != null) {
            return value;
        }
        return ServletUtil.value((HttpServletRequest)pageContext.getRequest(), name);
    }

    public static Object value(HttpServletRequest request, String name) {
        Object value = request.getAttribute(name);
        if (value != null) {
            return value;
        }
        value = request.getParameter(name);
        if (value != null) {
            return value;
        }
        value = request.getSession().getAttribute(name);
        if (value != null) {
            return value;
        }
        return request.getSession().getServletContext().getAttribute(name);
    }

    public static boolean isAbsoluteUrl(String url) {
        if (url == null) {
            return false;
        }
        int colonPos = url.indexOf(58);
        if (colonPos == -1) {
            return false;
        }
        for (int i = 0; i < colonPos; ++i) {
            if (VALID_SCHEME_CHARS.indexOf(url.charAt(i)) != -1) continue;
            return false;
        }
        return true;
    }

    public static String stripSession(String url) {
        int sessionStart;
        StringBuilder u = new StringBuilder(url);
        while ((sessionStart = u.toString().indexOf(";jsessionid=")) != -1) {
            int sessionEnd = u.toString().indexOf(59, sessionStart + 1);
            if (sessionEnd == -1) {
                sessionEnd = u.toString().indexOf(63, sessionStart + 1);
            }
            if (sessionEnd == -1) {
                sessionEnd = u.length();
            }
            u.delete(sessionStart, sessionEnd);
        }
        return u.toString();
    }

    public static String resolveUrl(String url, PageContext pageContext) {
        return ServletUtil.resolveUrl(url, (HttpServletRequest)pageContext.getRequest());
    }

    public static String resolveUrl(String url, HttpServletRequest request) {
        if (ServletUtil.isAbsoluteUrl(url)) {
            return url;
        }
        if (url.startsWith("/")) {
            return request.getContextPath() + url;
        }
        return url;
    }

    public static String resolveUrl(String url, String context) {
        if (ServletUtil.isAbsoluteUrl(url)) {
            return url;
        }
        if (!context.startsWith("/") || !url.startsWith("/")) {
            throw new IllegalArgumentException("Values of both 'context' and 'url' must start with '/'.");
        }
        if (context.equals("/")) {
            return url;
        }
        return context + url;
    }

    public static String[] prepareParameters(String[] paramValues, boolean trimParams, boolean treatEmptyParamsAsNull, boolean ignoreEmptyRequestParams) {
        if (trimParams || treatEmptyParamsAsNull || ignoreEmptyRequestParams) {
            int emptyCount = 0;
            int total = paramValues.length;
            for (int i = 0; i < paramValues.length; ++i) {
                String paramValue = paramValues[i];
                if (paramValue == null) {
                    ++emptyCount;
                    continue;
                }
                if (trimParams) {
                    paramValue = paramValue.trim();
                }
                if (paramValue.length() == 0) {
                    ++emptyCount;
                    if (treatEmptyParamsAsNull) {
                        paramValue = null;
                    }
                }
                paramValues[i] = paramValue;
            }
            if (ignoreEmptyRequestParams && emptyCount == total) {
                return null;
            }
        }
        return paramValues;
    }

    public static void copyParamsToAttributes(HttpServletRequest servletRequest, boolean trimParams, boolean treatEmptyParamsAsNull, boolean ignoreEmptyRequestParams) {
        Enumeration<String> paramNames = servletRequest.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            if (servletRequest.getAttribute(paramName) != null) continue;
            String[] paramValues = servletRequest.getParameterValues(paramName);
            if ((paramValues = ServletUtil.prepareParameters(paramValues, trimParams, treatEmptyParamsAsNull, ignoreEmptyRequestParams)) == null) continue;
            servletRequest.setAttribute(paramName, paramValues.length == 1 ? paramValues[0] : paramValues);
        }
        if (!(servletRequest instanceof MultipartRequestWrapper)) {
            return;
        }
        MultipartRequestWrapper multipartRequest = (MultipartRequestWrapper)servletRequest;
        if (!multipartRequest.isMultipart()) {
            return;
        }
        paramNames = multipartRequest.getFileParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = paramNames.nextElement();
            if (servletRequest.getAttribute(paramName) != null) continue;
            FileUpload[] paramValues = multipartRequest.getFiles(paramName);
            servletRequest.setAttribute(paramName, paramValues.length == 1 ? paramValues[0] : paramValues);
        }
    }

    public static Throwable getServletError(ServletRequest request) {
        return (Throwable)request.getAttribute(JAVAX_SERVLET_ERROR_EXCEPTION);
    }

    public static void setServletError(ServletRequest request, Throwable throwable) {
        request.setAttribute(JAVAX_SERVLET_ERROR_EXCEPTION, (Object)throwable);
    }

    public static String debug(HttpServletRequest request) {
        return ServletUtil.debug(request, null);
    }

    public static String debug(PageContext pageContext) {
        return ServletUtil.debug((HttpServletRequest)pageContext.getRequest(), pageContext);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected static String debug(HttpServletRequest request, PageContext pageContext) {
        int i;
        StringBuilder result = new StringBuilder();
        result.append("\nPARAMETERS\n----------\n");
        Enumeration enumeration = request.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String[] value = request.getParameterValues(name);
            result.append(name).append('=');
            if (value == null) {
                result.append("<null>");
                continue;
            }
            if (value.length == 1) {
                result.append((Object)value[0]).append('\n');
                continue;
            }
            result.append('[');
            int valueLength = value.length;
            for (i = 0; i < valueLength; ++i) {
                if (i == 0) {
                    result.append(',');
                }
                result.append((Object)value[i]);
            }
            result.append("]\n");
        }
        HttpSession session = request.getSession();
        ServletContext context = session.getServletContext();
        i = 0;
        while (i < 4) {
            switch (i) {
                case 0: {
                    result.append("\nREQUEST\n--------\n");
                    enumeration = request.getAttributeNames();
                    break;
                }
                case 1: {
                    result.append("\nSESSION\n--------\n");
                    enumeration = session.getAttributeNames();
                    break;
                }
                case 2: {
                    result.append("\nAPPLICATION\n-----------\n");
                    enumeration = context.getAttributeNames();
                    break;
                }
                case 3: {
                    if (pageContext == null) {
                        return result.toString();
                    }
                    result.append("\nPAGE\n-----------\n");
                    enumeration = pageContext.getAttributeNamesInScope(1);
                }
            }
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                Object value = null;
                switch (i) {
                    case 0: {
                        value = request.getAttribute(name);
                        break;
                    }
                    case 1: {
                        value = session.getAttribute(name);
                        break;
                    }
                    case 2: {
                        value = context.getAttribute(name);
                        break;
                    }
                    case 3: {
                        value = pageContext.getAttribute(name);
                        break;
                    }
                }
                result.append(name).append('=');
                if (value == null) {
                    result.append("<null>\n");
                    continue;
                }
                result.append(value).append('\n');
            }
            ++i;
        }
        return result.toString();
    }

    public static void preventCaching(HttpServletResponse response) {
        response.setHeader("Cache-Control", "max-age=0, must-revalidate, no-cache, no-store, private, post-check=0, pre-check=0");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
    }
}

