/*
 * Decompiled with CFR 0.152.
 */
package jodd.introspector;

import java.util.HashMap;
import java.util.Map;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.Introspector;

public class AccessibleIntrospector
implements Introspector {
    protected final Map<Class, ClassDescriptor> cache = new HashMap<Class, ClassDescriptor>();

    public ClassDescriptor lookup(Class type) {
        ClassDescriptor cd = this.cache.get(type);
        if (cd != null) {
            cd.increaseUsageCount();
            return cd;
        }
        cd = this.describeClass(type);
        this.cache.put(type, cd);
        return cd;
    }

    public ClassDescriptor register(Class type) {
        ClassDescriptor cd = this.describeClass(type);
        this.cache.put(type, cd);
        return cd;
    }

    protected ClassDescriptor describeClass(Class type) {
        return new ClassDescriptor(type, true);
    }

    public void reset() {
        this.cache.clear();
    }

    public String getStatistics() {
        StringBuilder stat = new StringBuilder();
        stat.append("Total classes: ").append(this.cache.size()).append('\n');
        for (Map.Entry<Class, ClassDescriptor> entry : this.cache.entrySet()) {
            ClassDescriptor bcd = entry.getValue();
            stat.append('\t').append(entry.getKey().getName()).append(" (");
            stat.append(bcd.getUsageCount()).append(" uses)").append('\n');
        }
        return stat.toString();
    }
}

