/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.util;

import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class BlockingConcurrentWindowCounter {
    private final PriorityBlockingQueue<Integer> queue;
    private volatile int tail = 0;
    private volatile int head = 0;
    private final Semaphore semaphore;

    public BlockingConcurrentWindowCounter(int size) {
        this(size, 0);
    }

    public BlockingConcurrentWindowCounter(int size, int init) {
        this.queue = new PriorityBlockingQueue(size);
        this.semaphore = new Semaphore(size);
        this.head = this.tail = init;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int incrementAndGet() throws Exception {
        this.semaphore.acquire();
        BlockingConcurrentWindowCounter blockingConcurrentWindowCounter = this;
        synchronized (blockingConcurrentWindowCounter) {
            return this.head++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int incrementAndGet(long timeout, TimeUnit unit) throws Exception {
        this.semaphore.tryAcquire(timeout, unit);
        BlockingConcurrentWindowCounter blockingConcurrentWindowCounter = this;
        synchronized (blockingConcurrentWindowCounter) {
            return this.head++;
        }
    }

    public synchronized int release(int index) {
        int count = 0;
        this.queue.add(index);
        while (!this.queue.isEmpty() && this.queue.peek() == this.tail) {
            this.queue.remove();
            ++this.tail;
            ++count;
        }
        if (count > 0) {
            this.semaphore.release(count);
        }
        return count;
    }
}

