/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.thrift;

import com.netflix.astyanax.ExceptionCallback;
import com.netflix.astyanax.model.ByteBufferRange;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ColumnSlice;
import com.netflix.astyanax.query.AllRowsQuery;
import com.netflix.astyanax.query.CheckpointManager;
import com.netflix.astyanax.shallows.EmptyCheckpointManager;
import com.netflix.astyanax.thrift.ThriftUtils;
import com.netflix.astyanax.util.TokenGenerator;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.cassandra.thrift.KeyRange;
import org.apache.cassandra.thrift.KeySlice;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SliceRange;

public abstract class AbstractThriftAllRowsQueryImpl<K, C>
implements AllRowsQuery<K, C> {
    protected SlicePredicate predicate = new SlicePredicate().setSlice_range(ThriftUtils.RANGE_ALL);
    protected CheckpointManager checkpointManager = new EmptyCheckpointManager();
    private int blockSize = 100;
    private ColumnFamily<K, C> columnFamily;
    private boolean repeatLastToken = true;
    private ExceptionCallback exceptionCallback;
    private Integer nThreads;
    private BigInteger startToken = TokenGenerator.MINIMUM;
    private BigInteger endToken = TokenGenerator.MAXIMUM;
    private Boolean includeEmptyRows;

    public AbstractThriftAllRowsQueryImpl(ColumnFamily<K, C> columnFamily) {
        this.columnFamily = columnFamily;
    }

    @Override
    public AllRowsQuery<K, C> setExceptionCallback(ExceptionCallback cb) {
        this.exceptionCallback = cb;
        return this;
    }

    protected ExceptionCallback getExceptionCallback() {
        return this.exceptionCallback;
    }

    @Override
    public AllRowsQuery<K, C> setThreadCount(int numberOfThreads) {
        this.setConcurrencyLevel(numberOfThreads);
        return this;
    }

    @Override
    public AllRowsQuery<K, C> setConcurrencyLevel(int numberOfThreads) {
        this.nThreads = numberOfThreads;
        return this;
    }

    @Override
    public AllRowsQuery<K, C> setCheckpointManager(CheckpointManager manager) {
        this.checkpointManager = manager;
        return this;
    }

    @Override
    public AllRowsQuery<K, C> withColumnSlice(C ... columns) {
        if (columns != null) {
            this.predicate.setColumn_names(this.columnFamily.getColumnSerializer().toBytesList(Arrays.asList(columns))).setSlice_rangeIsSet(false);
        }
        return this;
    }

    @Override
    public AllRowsQuery<K, C> withColumnSlice(Collection<C> columns) {
        if (columns != null) {
            this.predicate.setColumn_names(this.columnFamily.getColumnSerializer().toBytesList(columns)).setSlice_rangeIsSet(false);
        }
        return this;
    }

    @Override
    public AllRowsQuery<K, C> withColumnRange(C startColumn, C endColumn, boolean reversed, int count) {
        this.predicate.setSlice_range(ThriftUtils.createSliceRange(this.columnFamily.getColumnSerializer(), startColumn, endColumn, reversed, count));
        return this;
    }

    @Override
    public AllRowsQuery<K, C> withColumnRange(ByteBuffer startColumn, ByteBuffer endColumn, boolean reversed, int count) {
        this.predicate.setSlice_range(new SliceRange(startColumn, endColumn, reversed, count));
        return this;
    }

    @Override
    public AllRowsQuery<K, C> withColumnSlice(ColumnSlice<C> slice) {
        if (slice.getColumns() != null) {
            this.predicate.setColumn_names(this.columnFamily.getColumnSerializer().toBytesList(slice.getColumns())).setSlice_rangeIsSet(false);
        } else {
            this.predicate.setSlice_range(ThriftUtils.createSliceRange(this.columnFamily.getColumnSerializer(), slice.getStartColumn(), slice.getEndColumn(), slice.getReversed(), slice.getLimit()));
        }
        return this;
    }

    @Override
    public AllRowsQuery<K, C> withColumnRange(ByteBufferRange range) {
        this.predicate.setSlice_range(new SliceRange().setStart(range.getStart()).setFinish(range.getEnd()).setCount(range.getLimit()).setReversed(range.isReversed()));
        return this;
    }

    @Override
    public AllRowsQuery<K, C> setBlockSize(int blockSize) {
        return this.setRowLimit(blockSize);
    }

    @Override
    public AllRowsQuery<K, C> setRowLimit(int rowLimit) {
        this.blockSize = rowLimit;
        return this;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    @Override
    public AllRowsQuery<K, C> setRepeatLastToken(boolean repeatLastToken) {
        this.repeatLastToken = repeatLastToken;
        return this;
    }

    public boolean getRepeatLastToken() {
        return this.repeatLastToken;
    }

    protected Integer getConcurrencyLevel() {
        return this.nThreads;
    }

    @Override
    public AllRowsQuery<K, C> setIncludeEmptyRows(boolean flag) {
        this.includeEmptyRows = flag;
        return this;
    }

    public BigInteger getStartToken() {
        return this.startToken;
    }

    public BigInteger getEndToken() {
        return this.endToken;
    }

    @Override
    public AllRowsQuery<K, C> forTokenRange(BigInteger startToken, BigInteger endToken) {
        this.startToken = startToken;
        this.endToken = endToken;
        return this;
    }

    @Override
    public AllRowsQuery<K, C> forTokenRange(String startToken, String endToken) {
        return this.forTokenRange(new BigInteger(startToken), new BigInteger(endToken));
    }

    SlicePredicate getPredicate() {
        return this.predicate;
    }

    Boolean getIncludeEmptyRows() {
        return this.includeEmptyRows;
    }

    protected abstract List<KeySlice> getNextBlock(KeyRange var1);
}

