/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.serializers;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.serializers.ByteBufferOutputStream;
import com.netflix.astyanax.serializers.ComparatorType;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public abstract class AbstractSerializer<T>
implements Serializer<T> {
    @Override
    public abstract ByteBuffer toByteBuffer(T var1);

    @Override
    public byte[] toBytes(T obj) {
        ByteBuffer bb = this.toByteBuffer(obj);
        byte[] bytes = new byte[bb.remaining()];
        bb.get(bytes, 0, bytes.length);
        return bytes;
    }

    @Override
    public T fromBytes(byte[] bytes) {
        return this.fromByteBuffer(ByteBuffer.wrap(bytes));
    }

    @Override
    public abstract T fromByteBuffer(ByteBuffer var1);

    @Override
    public Set<ByteBuffer> toBytesSet(List<T> list) {
        HashSet<ByteBuffer> bytesList = new HashSet<ByteBuffer>(this.computeInitialHashSize(list.size()));
        for (T s : list) {
            bytesList.add(this.toByteBuffer(s));
        }
        return bytesList;
    }

    @Override
    public List<T> fromBytesSet(Set<ByteBuffer> set) {
        ArrayList<T> objList = new ArrayList<T>(set.size());
        for (ByteBuffer b : set) {
            objList.add(this.fromByteBuffer(b));
        }
        return objList;
    }

    @Override
    public List<ByteBuffer> toBytesList(List<T> list) {
        return Lists.transform(list, (Function)new Function<T, ByteBuffer>(){

            public ByteBuffer apply(@Nullable T s) {
                return AbstractSerializer.this.toByteBuffer(s);
            }
        });
    }

    @Override
    public List<ByteBuffer> toBytesList(Collection<T> list) {
        ArrayList<ByteBuffer> bytesList = new ArrayList<ByteBuffer>(list.size());
        for (T s : list) {
            bytesList.add(this.toByteBuffer(s));
        }
        return bytesList;
    }

    @Override
    public List<ByteBuffer> toBytesList(Iterable<T> list) {
        return Lists.newArrayList((Iterable)Iterables.transform(list, (Function)new Function<T, ByteBuffer>(){

            public ByteBuffer apply(@Nullable T s) {
                return AbstractSerializer.this.toByteBuffer(s);
            }
        }));
    }

    @Override
    public List<T> fromBytesList(List<ByteBuffer> list) {
        ArrayList<T> objList = new ArrayList<T>(list.size());
        for (ByteBuffer s : list) {
            objList.add(this.fromByteBuffer(s));
        }
        return objList;
    }

    @Override
    public <V> Map<ByteBuffer, V> toBytesMap(Map<T, V> map) {
        LinkedHashMap<ByteBuffer, V> bytesMap = new LinkedHashMap<ByteBuffer, V>(this.computeInitialHashSize(map.size()));
        for (Map.Entry<T, V> entry : map.entrySet()) {
            bytesMap.put(this.toByteBuffer(entry.getKey()), entry.getValue());
        }
        return bytesMap;
    }

    @Override
    public <V> Map<T, V> fromBytesMap(Map<ByteBuffer, V> map) {
        LinkedHashMap<T, V> objMap = new LinkedHashMap<T, V>(this.computeInitialHashSize(map.size()));
        for (Map.Entry<ByteBuffer, V> entry : map.entrySet()) {
            objMap.put(this.fromByteBuffer(entry.getKey()), entry.getValue());
        }
        return objMap;
    }

    public int computeInitialHashSize(int initialSize) {
        return Double.valueOf(Math.floor((double)initialSize / 0.75)).intValue() + 1;
    }

    @Override
    public ComparatorType getComparatorType() {
        return ComparatorType.BYTESTYPE;
    }

    @Override
    public ByteBuffer fromString(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getString(ByteBuffer byteBuffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuffer getNext(ByteBuffer byteBuffer) {
        ByteBufferOutputStream next = new ByteBufferOutputStream();
        next.write(byteBuffer);
        next.write(0);
        return next.getByteBuffer();
    }
}

