/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.recipes.uniqueness;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.connectionpool.exceptions.NotFoundException;
import com.netflix.astyanax.model.Column;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.model.ConsistencyLevel;
import com.netflix.astyanax.recipes.locks.BusyLockException;
import com.netflix.astyanax.recipes.locks.StaleLockException;
import com.netflix.astyanax.recipes.uniqueness.NotUniqueException;
import com.netflix.astyanax.recipes.uniqueness.UniquenessConstraint;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class DedicatedMultiRowUniquenessConstraint<C>
implements UniquenessConstraint {
    private final Keyspace keyspace;
    private Integer ttl = null;
    private ConsistencyLevel consistencyLevel = ConsistencyLevel.CL_LOCAL_QUORUM;
    private final C uniqueColumnName;
    private final List<Row<?>> locks = Lists.newArrayList();

    public DedicatedMultiRowUniquenessConstraint(Keyspace keyspace, Supplier<C> uniqueColumnSupplier) {
        this.keyspace = keyspace;
        this.uniqueColumnName = uniqueColumnSupplier.get();
    }

    public DedicatedMultiRowUniquenessConstraint(Keyspace keyspace, C uniqueColumnName) {
        this.keyspace = keyspace;
        this.uniqueColumnName = uniqueColumnName;
    }

    public DedicatedMultiRowUniquenessConstraint<C> withTtl(Integer ttl) {
        this.ttl = ttl;
        return this;
    }

    public DedicatedMultiRowUniquenessConstraint<C> withConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        return this;
    }

    public <K> DedicatedMultiRowUniquenessConstraint<C> withRow(ColumnFamily<K, C> columnFamily, K rowKey) {
        this.locks.add(new Row<K>(columnFamily, rowKey));
        return this;
    }

    public C getLockColumn() {
        return this.uniqueColumnName;
    }

    @Override
    public void acquire() throws NotUniqueException, Exception {
        this.acquireAndApplyMutation(null);
    }

    @Override
    @Deprecated
    public void acquireAndMutate(final MutationBatch other) throws NotUniqueException, Exception {
        this.acquireAndApplyMutation(new Function<MutationBatch, Boolean>(){

            public Boolean apply(@Nullable MutationBatch input) {
                if (other != null) {
                    input.mergeShallow(other);
                }
                return true;
            }
        });
    }

    @Override
    public void acquireAndApplyMutation(Function<MutationBatch, Boolean> callback) throws NotUniqueException, Exception {
        try {
            MutationBatch m = this.keyspace.prepareMutationBatch().setConsistencyLevel(this.consistencyLevel);
            for (Row<?> lock : this.locks) {
                lock.fillMutation(m, this.ttl);
            }
            m.execute();
            for (Row<?> lock : this.locks) {
                lock.verifyLock();
            }
            for (Row<?> lock : this.locks) {
                lock.fillMutation(m, null);
            }
            if (callback != null) {
                callback.apply((Object)m);
            }
            m.execute();
        }
        catch (BusyLockException e) {
            this.release();
            throw new NotUniqueException(e);
        }
        catch (StaleLockException e) {
            this.release();
            throw new NotUniqueException(e);
        }
        catch (Exception e) {
            this.release();
            throw e;
        }
    }

    @Override
    public void release() throws Exception {
        MutationBatch m = this.keyspace.prepareMutationBatch();
        for (Row<?> lock : this.locks) {
            lock.fillReleaseMutation(m);
        }
        m.execute();
    }

    public Column<C> getUniqueColumn() throws Exception {
        if (this.locks.size() == 0) {
            throw new IllegalStateException("Missing call to withRow to add rows to the uniqueness constraint");
        }
        ArrayList columns = Lists.newArrayList();
        for (Row<?> row : this.locks) {
            columns.add(row.getUniqueColumn());
        }
        Column foundColumn = (Column)columns.get(0);
        for (int i = 1; i < columns.size(); ++i) {
            Column nextColumn = (Column)columns.get(i);
            if (!nextColumn.getRawName().equals(foundColumn.getRawName())) {
                throw new NotUniqueException("The provided rows are not part of the same uniquness constraint");
            }
            if (foundColumn.hasValue() != nextColumn.hasValue()) {
                throw new NotUniqueException("The provided rows are not part of the same uniquness constraint");
            }
            if (!foundColumn.hasValue() || nextColumn.getByteBufferValue().equals(foundColumn.getByteBufferValue())) continue;
            throw new NotUniqueException("The provided rows are not part of the same uniquness constraint");
        }
        return foundColumn;
    }

    private class Row<K> {
        private final ColumnFamily<K, C> columnFamily;
        private final K row;

        Row(ColumnFamily<K, C> columnFamily, K row) {
            this.columnFamily = columnFamily;
            this.row = row;
        }

        void fillMutation(MutationBatch m, Integer ttl) {
            m.withRow(this.columnFamily, this.row).putEmptyColumn(DedicatedMultiRowUniquenessConstraint.this.uniqueColumnName, ttl);
        }

        void fillReleaseMutation(MutationBatch m) {
            m.withRow(this.columnFamily, this.row).deleteColumn(DedicatedMultiRowUniquenessConstraint.this.uniqueColumnName);
        }

        void verifyLock() throws Exception {
            ColumnList result = (ColumnList)DedicatedMultiRowUniquenessConstraint.this.keyspace.prepareQuery(this.columnFamily).setConsistencyLevel(DedicatedMultiRowUniquenessConstraint.this.consistencyLevel).getKey(this.row).execute().getResult();
            if (result.size() != 1) {
                throw new NotUniqueException(this.row.toString());
            }
        }

        Column<C> getUniqueColumn() throws ConnectionException {
            ColumnList columns = (ColumnList)DedicatedMultiRowUniquenessConstraint.this.keyspace.prepareQuery(this.columnFamily).getKey(this.row).execute().getResult();
            Column foundColumn = null;
            for (Column column : columns) {
                if (column.getTtl() != 0) continue;
                if (foundColumn != null) {
                    throw new RuntimeException("Row has duplicate quite columns");
                }
                foundColumn = column;
            }
            if (foundColumn == null) {
                throw new NotFoundException("Unique column not found");
            }
            return foundColumn;
        }
    }
}

