/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.recipes.scheduler;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.model.ConsistencyLevel;
import com.netflix.astyanax.recipes.locks.BusyLockException;
import com.netflix.astyanax.recipes.queue.Message;
import com.netflix.astyanax.recipes.queue.MessageConsumer;
import com.netflix.astyanax.recipes.queue.MessageContext;
import com.netflix.astyanax.recipes.queue.MessageProducer;
import com.netflix.astyanax.recipes.queue.MessageQueueException;
import com.netflix.astyanax.recipes.queue.MessageQueueHooks;
import com.netflix.astyanax.recipes.queue.ShardedDistributedMessageQueue;
import com.netflix.astyanax.recipes.queue.triggers.Trigger;
import com.netflix.astyanax.recipes.scheduler.Task;
import com.netflix.astyanax.recipes.scheduler.TaskHistory;
import com.netflix.astyanax.recipes.scheduler.TaskInfo;
import com.netflix.astyanax.recipes.scheduler.TaskScheduler;
import com.netflix.astyanax.recipes.scheduler.TaskSchedulerException;
import com.netflix.astyanax.recipes.scheduler.TaskState;
import com.netflix.astyanax.recipes.scheduler.TaskStatus;
import com.netflix.astyanax.recipes.uniqueness.ColumnPrefixUniquenessConstraint;
import com.netflix.astyanax.recipes.uniqueness.NotUniqueException;
import com.netflix.astyanax.serializers.StringSerializer;
import com.netflix.astyanax.serializers.TimeUUIDSerializer;
import com.netflix.astyanax.util.TimeUUIDUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class DistributedTaskScheduler
implements MessageQueueHooks,
TaskScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(DistributedTaskScheduler.class);
    public static final String DEFAULT_SCHEDULER_NAME = "Tasks";
    public static final ConsistencyLevel DEFAULT_CONSISTENCY_LEVEL = ConsistencyLevel.CL_QUORUM;
    public static final int DEFAULT_BATCH_SIZE = 5;
    public static final int DEFAULT_CONSUMER_THREAD_COUNT = 1;
    public static final Integer DEFAULT_ERROR_TTL = (int)TimeUnit.SECONDS.convert(14L, TimeUnit.DAYS);
    public static final int DEFAULT_SCHEMA_AGREEMENT_GRACE_PERIOD = 3000;
    public static final int DEFAULT_SHARD_COUNT = 1;
    public static final int DEFAULT_BUCKET_COUNT = 1;
    public static final int DEFAULT_BUCKET_DURATION = 1;
    public static final int DEFAULT_POLLING_INTERVAL = 1;
    public static final int THROTTLE_DURATION = 1000;
    public static final String TASKS_SUFFIX = "_Tasks";
    public static final String QUEUE_SUFFIX = "_Queue";
    public static final String HISTORY_SUFFIX = "_History";
    public static final String COLUMN_TASK_INFO = "task_info";
    public static final String COLUMN_TRIGGER_CLASS = "trigger_class";
    public static final String COLUMN_TRIGGER = "trigger";
    public static final String COLUMN_TOKEN = "token";
    public static final String COLUMN_STATE = "state";
    public static final String PARAM_KEY = "key";
    private final ObjectMapper mapper = new ObjectMapper();
    private ShardedDistributedMessageQueue messageQueue;
    private ExecutorService executor;
    private int threadCount;
    private int batchSize;
    private volatile boolean terminate;
    private ConsistencyLevel consistencyLevel;
    private String name;
    private String groupName;
    private MessageProducer producer;
    private Keyspace keyspace;
    private ColumnFamily<String, String> taskCf;
    private ColumnFamily<String, UUID> historyCf;
    private long pollingInterval;

    public DistributedTaskScheduler() {
        this.mapper.configure(SerializationConfig.Feature.USE_STATIC_TYPING, true);
        this.threadCount = 1;
        this.batchSize = 5;
        this.terminate = false;
        this.consistencyLevel = DEFAULT_CONSISTENCY_LEVEL;
        this.name = DEFAULT_SCHEDULER_NAME;
        this.pollingInterval = 1L;
    }

    private void intialize() {
        Preconditions.checkNotNull((Object)this.keyspace, (Object)"Must specify keyspace");
        this.taskCf = new ColumnFamily<String, String>(this.name + TASKS_SUFFIX, StringSerializer.get(), StringSerializer.get());
        this.historyCf = new ColumnFamily<String, UUID>(this.name + HISTORY_SUFFIX, StringSerializer.get(), TimeUUIDSerializer.get());
        if (this.groupName == null) {
            this.groupName = this.name;
        }
        this.executor = Executors.newFixedThreadPool(this.threadCount);
        this.messageQueue = new ShardedDistributedMessageQueue.Builder().withColumnFamily(this.taskCf.getName() + QUEUE_SUFFIX).withQueueName(this.groupName).withKeyspace(this.keyspace).withConsistencyLevel(this.consistencyLevel).withShardCount(1).withHook(this).withTimeBuckets(1, 1, TimeUnit.HOURS).withPollInterval(this.pollingInterval, TimeUnit.SECONDS).build();
        this.producer = this.messageQueue.createProducer();
    }

    @Override
    public void create() throws TaskSchedulerException {
        try {
            this.messageQueue.createQueue();
        }
        catch (MessageQueueException e) {
            throw new TaskSchedulerException("Failed to create message queue for scheduler " + this.taskCf.getName(), e);
        }
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e1) {
            Thread.currentThread().interrupt();
        }
        try {
            this.keyspace.createColumnFamily(this.taskCf, (Map<String, Object>)ImmutableMap.builder().put((Object)"column_metadata", (Object)ImmutableMap.builder().put((Object)COLUMN_TASK_INFO, (Object)ImmutableMap.builder().put((Object)"validation_class", (Object)"UTF8Type").build()).put((Object)COLUMN_TRIGGER_CLASS, (Object)ImmutableMap.builder().put((Object)"validation_class", (Object)"UTF8Type").build()).put((Object)COLUMN_TRIGGER, (Object)ImmutableMap.builder().put((Object)"validation_class", (Object)"UTF8Type").build()).put((Object)COLUMN_STATE, (Object)ImmutableMap.builder().put((Object)"validation_class", (Object)"UTF8Type").build()).put((Object)COLUMN_TOKEN, (Object)ImmutableMap.builder().put((Object)"validation_class", (Object)"UUIDType").build()).build()).build());
        }
        catch (ConnectionException e) {
            throw new TaskSchedulerException("Failed to create column family for scheduler " + this.taskCf.getName(), e);
        }
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e1) {
            Thread.currentThread().interrupt();
        }
        try {
            this.keyspace.createColumnFamily(this.historyCf, (Map<String, Object>)ImmutableMap.builder().put((Object)"default_validation_class", (Object)"UTF8Type").build());
        }
        catch (ConnectionException e) {
            throw new TaskSchedulerException("Failed to create column family for scheduler history " + this.historyCf.getName(), e);
        }
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e1) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void start() {
        for (int i = 0; i < this.threadCount; ++i) {
            this.startConsumer(i);
        }
    }

    @Override
    public boolean stop() throws TaskSchedulerException {
        this.terminate = true;
        this.executor.shutdownNow();
        try {
            this.executor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    private void startConsumer(final int id) {
        this.executor.submit(new Runnable(){
            private String name;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                this.name = StringUtils.join((Collection)Lists.newArrayList((Object[])new String[]{DistributedTaskScheduler.this.messageQueue.getName(), "Consumer", Integer.toString(id)}), (String)":");
                Thread.currentThread().setName(this.name);
                MessageConsumer consumer = DistributedTaskScheduler.this.messageQueue.createConsumer();
                try {
                    while (!DistributedTaskScheduler.this.terminate) {
                        Collection<MessageContext> messages = null;
                        try {
                            messages = consumer.readMessages(DistributedTaskScheduler.this.batchSize);
                            try {
                                for (MessageContext context : messages) {
                                    Message message = context.getMessage();
                                    TaskInfo info = null;
                                    String taskKey = null;
                                    ColumnList columns = null;
                                    TaskHistory history = new TaskHistory();
                                    history.setStartTime(System.currentTimeMillis());
                                    history.setTriggerTime(message.getTrigger().getTriggerTime());
                                    UUID historyUUID = TimeUUIDUtils.getTimeUUID(history.getStartTime());
                                    try {
                                        Trigger nextTrigger;
                                        Map<String, Object> parameters = message.getParameters();
                                        taskKey = (String)parameters.get(DistributedTaskScheduler.PARAM_KEY);
                                        columns = (ColumnList)DistributedTaskScheduler.this.keyspace.prepareQuery(DistributedTaskScheduler.this.taskCf).getRow(taskKey).execute().getResult();
                                        if (columns.isEmpty()) continue;
                                        String triggerClassName = columns.getStringValue(DistributedTaskScheduler.COLUMN_TRIGGER_CLASS, null);
                                        String triggerData = (String)message.getParameters().get(DistributedTaskScheduler.COLUMN_TRIGGER);
                                        TaskState state = TaskState.valueOf(columns.getStringValue(DistributedTaskScheduler.COLUMN_STATE, TaskState.Active.name()));
                                        info = (TaskInfo)DistributedTaskScheduler.this.deserializeString(columns.getStringValue(DistributedTaskScheduler.COLUMN_TASK_INFO, null), TaskInfo.class);
                                        if (state == TaskState.Inactive) {
                                            history.setStatus(TaskStatus.SKIPPED);
                                        } else {
                                            history.setStatus(TaskStatus.RUNNING);
                                        }
                                        if (info.isKeepHistory()) {
                                            DistributedTaskScheduler.this.keyspace.prepareColumnMutation(DistributedTaskScheduler.this.historyCf, taskKey, historyUUID).putValue(DistributedTaskScheduler.this.serializeToString(history), info.getHistoryTtl()).execute();
                                        }
                                        Task task = (Task)Class.forName(info.getClassName()).newInstance();
                                        Trigger trigger = null;
                                        if (triggerClassName != null && (nextTrigger = (trigger = (Trigger)DistributedTaskScheduler.this.deserializeString(triggerData, triggerClassName)).nextTrigger()) != null) {
                                            DistributedTaskScheduler.this.sendMessage(taskKey, nextTrigger);
                                        }
                                        if (state != TaskState.Active) continue;
                                        task.execute(info);
                                        history.setStatus(TaskStatus.DONE);
                                    }
                                    catch (Throwable t) {
                                        LOG.warn("Error executing task " + taskKey, t);
                                        history.setError(t.getMessage());
                                        history.setStackTrace(ExceptionUtils.getStackTrace((Throwable)t));
                                        history.setStatus(TaskStatus.FAILED);
                                    }
                                    finally {
                                        if (columns == null || taskKey == null || info != null && !info.isKeepHistory()) continue;
                                        try {
                                            history.setEndTime(System.currentTimeMillis());
                                            String value = DistributedTaskScheduler.this.serializeToString(history);
                                            Integer ttl = DEFAULT_ERROR_TTL;
                                            if (info != null) {
                                                ttl = info.getHistoryTtl();
                                            }
                                            DistributedTaskScheduler.this.keyspace.prepareColumnMutation(DistributedTaskScheduler.this.historyCf, taskKey, historyUUID).putValue(value, ttl).execute();
                                        }
                                        catch (Exception e) {
                                            LOG.warn("Error saving history for " + taskKey, (Throwable)e);
                                        }
                                    }
                                }
                            }
                            finally {
                                consumer.ackMessages(messages);
                            }
                        }
                        catch (BusyLockException e) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e1) {
                            }
                        }
                        catch (Exception e) {
                            LOG.warn("Error consuming messages ", (Throwable)e);
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e1) {
                            }
                        }
                    }
                    return;
                }
                finally {
                    LOG.info("Done with consumer " + this.name);
                }
            }
        });
    }

    @Override
    public void scheduleTask(TaskInfo task, final Trigger trigger) throws TaskSchedulerException, NotUniqueException {
        String serializedTrigger;
        String serializedTask;
        final String rowKey = this.getGroupKey(task.getKey());
        ColumnPrefixUniquenessConstraint<String> unique = new ColumnPrefixUniquenessConstraint<String>(this.keyspace, this.taskCf, rowKey).withConsistencyLevel(this.consistencyLevel);
        try {
            serializedTask = this.serializeToString(task);
            serializedTrigger = this.serializeToString(trigger);
        }
        catch (Exception e) {
            throw new TaskSchedulerException("Failed to serialize trigger or task for " + rowKey, e);
        }
        try {
            unique.acquireAndApplyMutation(new Function<MutationBatch, Boolean>(){

                public Boolean apply(@Nullable MutationBatch mb) {
                    mb.withRow(DistributedTaskScheduler.this.taskCf, rowKey).putColumn(DistributedTaskScheduler.COLUMN_TASK_INFO, serializedTask).putColumn(DistributedTaskScheduler.COLUMN_TRIGGER, serializedTrigger).putColumn(DistributedTaskScheduler.COLUMN_TRIGGER_CLASS, trigger.getClass().getCanonicalName());
                    return true;
                }
            });
        }
        catch (Exception e) {
            throw new TaskSchedulerException("Failed to serialize trigger or task for " + rowKey, e);
        }
        try {
            this.sendMessage(rowKey, trigger);
        }
        catch (Exception e) {
            throw new TaskSchedulerException("Failed to send message for task " + rowKey, e);
        }
    }

    @Override
    public void stopTask(String taskKey) throws TaskSchedulerException {
        String rowKey = this.getGroupKey(taskKey);
        try {
            this.keyspace.prepareColumnMutation(this.taskCf, rowKey, COLUMN_STATE).putValue(TaskState.Inactive.name(), null).execute();
        }
        catch (ConnectionException e) {
            throw new TaskSchedulerException("Failed to deactive task " + rowKey, e);
        }
    }

    @Override
    public void startTask(String taskKey) throws TaskSchedulerException {
        String rowKey = this.getGroupKey(taskKey);
        try {
            this.keyspace.prepareColumnMutation(this.taskCf, rowKey, COLUMN_STATE).putValue(TaskState.Active.name(), null).execute();
        }
        catch (ConnectionException e) {
            throw new TaskSchedulerException("Failed to deactive task " + rowKey, e);
        }
    }

    @Override
    public void deleteTask(String taskKey) throws TaskSchedulerException {
        String rowKey = this.getGroupKey(taskKey);
        MutationBatch mb = this.keyspace.prepareMutationBatch().setConsistencyLevel(this.consistencyLevel);
        mb.withRow(this.taskCf, rowKey).delete();
        try {
            mb.execute();
        }
        catch (ConnectionException e) {
            throw new TaskSchedulerException("Failed to delete task " + rowKey, e);
        }
    }

    @Override
    public Collection<TaskHistory> getTaskHistory(String taskKey, Long timeFrom, Long timeTo, int count) throws TaskSchedulerException {
        return null;
    }

    private Message sendMessage(String taskKey, Trigger trigger) throws Exception {
        Message message = new Message();
        message.setParameters((Map<String, Object>)ImmutableMap.builder().put((Object)PARAM_KEY, (Object)taskKey).put((Object)COLUMN_TRIGGER, (Object)this.serializeToString(trigger)).build());
        this.producer.sendMessage(message);
        return message;
    }

    private <T> String serializeToString(T trigger) throws JsonGenerationException, JsonMappingException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.mapper.writeValue((OutputStream)baos, trigger);
        baos.flush();
        return baos.toString();
    }

    private <T> T deserializeString(String data, Class<T> clazz) throws JsonParseException, JsonMappingException, IOException {
        return (T)this.mapper.readValue((InputStream)new ByteArrayInputStream(data.getBytes()), clazz);
    }

    private <T> T deserializeString(String data, String className) throws JsonParseException, JsonMappingException, IOException, ClassNotFoundException {
        return (T)this.mapper.readValue((InputStream)new ByteArrayInputStream(data.getBytes()), Class.forName(className));
    }

    @Override
    public void beforeAckMessages(Collection<Message> messages, MutationBatch mb) {
    }

    @Override
    public void beforeAckMessage(Message message, MutationBatch mb) {
    }

    @Override
    public void beforeSendMessage(Message message, MutationBatch mb) {
        try {
            mb.withRow(this.taskCf, (String)message.getParameters().get(PARAM_KEY)).putColumn(COLUMN_TOKEN, message.getToken());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getGroupKey(String key) {
        return this.groupName + "$" + key;
    }

    public static class Builder {
        private DistributedTaskScheduler taskExecutor = new DistributedTaskScheduler();

        public Builder withConsistencyLevel(ConsistencyLevel consistencyLevel) {
            this.taskExecutor.consistencyLevel = consistencyLevel;
            return this;
        }

        public Builder withThreadCount(int threadCount) {
            this.taskExecutor.threadCount = threadCount;
            return this;
        }

        public Builder withBatchSize(int batchSize) {
            this.taskExecutor.batchSize = batchSize;
            return this;
        }

        public Builder withName(String schedulerName) {
            this.taskExecutor.name = schedulerName;
            return this;
        }

        public Builder withGroupName(String groupName) {
            this.taskExecutor.groupName = groupName;
            return this;
        }

        public Builder withKeyspace(Keyspace keyspace) {
            this.taskExecutor.keyspace = keyspace;
            return this;
        }

        public Builder withPollingInterval(long interval, TimeUnit units) {
            this.taskExecutor.pollingInterval = TimeUnit.SECONDS.convert(interval, units);
            return this;
        }

        public TaskScheduler build() {
            this.taskExecutor.intialize();
            return this.taskExecutor;
        }
    }
}

