/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.recipes.queue;

import com.google.common.collect.Maps;
import com.netflix.astyanax.recipes.queue.triggers.Trigger;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class Message {
    private UUID token;
    private Trigger trigger;
    private Map<String, Object> parameters;
    private byte priority = 0;
    private Integer timeout = 5;
    private String key;
    private String taskClass;
    private boolean isKeepHistory = false;

    public Message() {
    }

    public Message(UUID token) {
        this.token = token;
    }

    public UUID getToken() {
        return this.token;
    }

    public Message setToken(UUID token) {
        this.token = token;
        return this;
    }

    public Trigger getTrigger() {
        return this.trigger;
    }

    public Message setTrigger(Trigger trigger) {
        this.trigger = trigger;
        return this;
    }

    public boolean hasTrigger() {
        return this.trigger != null;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public Message setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
        return this;
    }

    public Message addParameter(String key, Object value) {
        if (this.parameters == null) {
            this.parameters = Maps.newHashMap();
        }
        this.parameters.put(key, value);
        return this;
    }

    public byte getPriority() {
        return this.priority;
    }

    public Integer getTimeout() {
        if (this.timeout == null) {
            return 0;
        }
        return this.timeout;
    }

    public boolean hasTimeout() {
        return this.timeout != null;
    }

    public Message setPriority(byte priority) {
        this.priority = priority;
        return this;
    }

    public Message setTimeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    public Message setTimeout(Long timeout, TimeUnit units) {
        this.timeout = (int)TimeUnit.SECONDS.convert(timeout, units);
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public Message setKey(String key) {
        this.key = key;
        return this;
    }

    public boolean hasKey() {
        return this.key != null;
    }

    public String getTaskClass() {
        return this.taskClass;
    }

    public Message setTaskClass(String taskClass) {
        this.taskClass = taskClass;
        return this;
    }

    public boolean hasTaskClass() {
        return this.taskClass != null;
    }

    public Boolean isKeepHistory() {
        return this.isKeepHistory;
    }

    public Message setKeepHistory(Boolean isKeepHistory) {
        this.isKeepHistory = isKeepHistory;
        return this;
    }

    public Message clone() {
        Message message = new Message();
        message.token = this.token;
        message.trigger = this.trigger;
        message.parameters = this.parameters;
        message.priority = this.priority;
        message.timeout = this.timeout;
        message.key = this.key;
        message.taskClass = this.taskClass;
        message.isKeepHistory = this.isKeepHistory;
        return message;
    }

    public String toString() {
        return "Message [token=" + this.token + ", trigger=" + this.trigger + ", parameters=" + this.parameters + ", priority=" + this.priority + ", timeout=" + this.timeout + ", key=" + this.key + ", taskClass=" + this.taskClass + "]";
    }
}

