/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import org.compass.core.Compass;
import org.compass.core.util.StringUtils;

public class FileHandlerMonitor {
    private static final boolean windows = System.getProperty("os.name").toLowerCase().startsWith("windows");
    private static final boolean enabled = System.getProperty("compass.test.validateFileHandler", "false").equals("true");
    private File file;

    public static FileHandlerMonitor getFileHandlerMonitor(Compass compass) {
        String connection = compass.getSettings().getSetting("compass.engine.connection");
        if (connection.startsWith("file://") || connection.indexOf("://") == -1) {
            if (connection.startsWith("file://")) {
                connection = connection.substring("file://".length());
            }
            return new FileHandlerMonitor(connection);
        }
        return new FileHandlerMonitor(null);
    }

    public FileHandlerMonitor(String filePath) {
        if (filePath != null) {
            this.file = new File(filePath);
        }
    }

    public void verifyNoHandlers() throws Exception {
        FileHandlers handlers = this.handlers();
        if (handlers == null) {
            return;
        }
        if (handlers.hasHandlers()) {
            throw new Exception("File Handlers still exist \n" + handlers.getRawOutput());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileHandlers handlers() throws Exception {
        if (!enabled || this.file == null) {
            return new FileHandlers(null);
        }
        String command = windows ? "lib/handle/handle.exe " + this.file.getAbsolutePath() : "lsof | grep " + this.file.getAbsolutePath();
        Process process = Runtime.getRuntime().exec(command);
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
            process.waitFor();
        }
        finally {
            try {
                process.getInputStream().close();
            }
            catch (Exception e1) {}
            try {
                process.getOutputStream().close();
            }
            catch (Exception e1) {}
            try {
                process.getErrorStream().close();
            }
            catch (Exception e1) {}
            process.destroy();
        }
        return new FileHandlers(sb.toString());
    }

    public static class FileHandlers {
        private String output;

        public FileHandlers(String output) {
            this.output = output;
        }

        public boolean hasHandlers() {
            if (windows) {
                return this.output != null && this.output.indexOf("pid") != -1;
            }
            return StringUtils.hasLength(this.output);
        }

        public String getRawOutput() {
            return this.output;
        }
    }
}

