/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.impl;

import java.util.Locale;
import org.compass.core.CompassException;
import org.compass.core.CompassHits;
import org.compass.core.CompassQuery;
import org.compass.core.CompassQueryFilter;
import org.compass.core.CompassSearchSession;
import org.compass.core.CompassSession;
import org.compass.core.engine.SearchEngineHits;
import org.compass.core.engine.SearchEngineQuery;
import org.compass.core.events.FilterOperation;
import org.compass.core.impl.DefaultCompassHits;
import org.compass.core.impl.DefaultCompassQueryFilter;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.mapping.ResourcePropertyLookup;
import org.compass.core.spi.InternalCompass;
import org.compass.core.spi.InternalCompassQuery;
import org.compass.core.spi.InternalCompassSession;
import org.compass.core.spi.InternalCompassSpanQuery;

public class DefaultCompassQuery
implements InternalCompassQuery,
Cloneable {
    private static final ThreadLocal<InternalCompassSession> attachedSession = new ThreadLocal();
    private SearchEngineQuery searchEngineQuery;
    private InternalCompass compass;
    private CompassQueryFilter filter;

    public DefaultCompassQuery(SearchEngineQuery searchEngineQuery, InternalCompass compass) {
        this.searchEngineQuery = searchEngineQuery;
        this.compass = compass;
    }

    public CompassQuery attach(CompassSession session) {
        InternalCompassSession compassSession = (InternalCompassSession)session;
        attachedSession.set(compassSession);
        compassSession.addDelegateClose(this);
        return this;
    }

    public CompassQuery attach(CompassSearchSession session) {
        attachedSession.set((InternalCompassSession)session);
        return this;
    }

    public void detach() {
        attachedSession.remove();
    }

    public void close() {
        this.detach();
    }

    public CompassQuery setBoost(float boost) {
        this.searchEngineQuery.setBoost(boost);
        return this;
    }

    public CompassQuery addSort(String name) {
        ResourcePropertyLookup lookup = this.compass.getMapping().getResourcePropertyLookup(name);
        this.searchEngineQuery.addSort(lookup.getPath());
        return this;
    }

    public CompassQuery addSort(String name, CompassQuery.SortDirection direction) {
        ResourcePropertyLookup lookup = this.compass.getMapping().getResourcePropertyLookup(name);
        this.searchEngineQuery.addSort(lookup.getPath(), direction);
        return this;
    }

    public CompassQuery addSort(String name, CompassQuery.SortPropertyType type) {
        ResourcePropertyLookup lookup = this.compass.getMapping().getResourcePropertyLookup(name);
        this.searchEngineQuery.addSort(lookup.getPath(), type);
        return this;
    }

    public CompassQuery addSort(String name, CompassQuery.SortPropertyType type, CompassQuery.SortDirection direction) {
        ResourcePropertyLookup lookup = this.compass.getMapping().getResourcePropertyLookup(name);
        this.searchEngineQuery.addSort(lookup.getPath(), type, direction);
        return this;
    }

    public CompassQuery addSort(CompassQuery.SortImplicitType implicitType) {
        this.searchEngineQuery.addSort(implicitType);
        return this;
    }

    public CompassQuery addSort(CompassQuery.SortImplicitType implicitType, CompassQuery.SortDirection direction) {
        this.searchEngineQuery.addSort(implicitType, direction);
        return this;
    }

    public CompassQuery addSort(String propertyName, Locale locale, CompassQuery.SortDirection direction) {
        this.searchEngineQuery.addSort(propertyName, locale, direction);
        return this;
    }

    public CompassQuery addSort(String propertyName, Locale locale) {
        this.searchEngineQuery.addSort(propertyName, locale);
        return this;
    }

    public CompassQuery setSubIndexes(String ... subIndexes) {
        this.searchEngineQuery.setSubIndexes(subIndexes);
        return this;
    }

    public CompassQuery setAliases(String ... aliases) {
        this.searchEngineQuery.setAliases(aliases);
        return this;
    }

    public CompassQuery setTypes(Class ... types) {
        if (types == null) {
            this.searchEngineQuery.setAliases(null);
            return this;
        }
        String[] aliases = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            ResourceMapping resourceMapping = this.compass.getMapping().getRootMappingByClass(types[i]);
            aliases[i] = resourceMapping.getAlias();
        }
        this.setAliases(aliases);
        return this;
    }

    public CompassQuery setFilter(CompassQueryFilter filter) {
        this.filter = filter;
        this.searchEngineQuery.setFilter(((DefaultCompassQueryFilter)filter).getFilter());
        return this;
    }

    public CompassQueryFilter getFilter() {
        return this.filter;
    }

    public CompassQuery rewrite() {
        this.searchEngineQuery.rewrite();
        return this;
    }

    public CompassQuery getSuggestedQuery() {
        if (this.compass.getSpellCheckManager() == null) {
            return this;
        }
        return this.compass.getSpellCheckManager().suggest(this);
    }

    public boolean isSuggested() {
        return this.searchEngineQuery.isSuggested();
    }

    public long count() {
        return this.searchEngineQuery.count(this.session().getSearchEngine());
    }

    public long count(float minimumScore) {
        return this.searchEngineQuery.count(this.session().getSearchEngine(), minimumScore);
    }

    public CompassHits hits() throws CompassException {
        InternalCompassSession session = this.session();
        SearchEngineHits searchEngineHits = this.searchEngineQuery.hits(session.getSearchEngine());
        return new DefaultCompassHits(searchEngineHits, session, this);
    }

    public void delete() throws CompassException {
        InternalCompassSession session = this.session();
        session.getFirstLevelCache().evictAll();
        if (session.getCompass().getEventManager().onPreDelete(this) == FilterOperation.YES) {
            return;
        }
        session.getSearchEngine().delete(this.searchEngineQuery);
        session.getCompass().getEventManager().onPostDelete(this);
    }

    public SearchEngineQuery getSearchEngineQuery() {
        return this.searchEngineQuery;
    }

    public String toString() {
        return this.searchEngineQuery.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultCompassQuery clone = (DefaultCompassQuery)super.clone();
        clone.searchEngineQuery = (SearchEngineQuery)this.searchEngineQuery.clone();
        return clone;
    }

    private InternalCompassSession session() throws CompassException {
        InternalCompassSession session = attachedSession.get();
        if (session == null) {
            session = (InternalCompassSession)this.compass.getTransactionFactory().getTransactionBoundSession();
            if (session == null) {
                session = (InternalCompassSession)this.compass.getLocalTransactionFactory().getTransactionBoundSession();
            }
            if (session != null) {
                this.attach(session);
            }
        }
        if (session == null) {
            throw new CompassException("Trying to execute a query without an attached session, have you called attach on the query?");
        }
        session.startTransactionIfNeeded();
        return session;
    }

    public static class DefaultCompassSpanQuey
    extends DefaultCompassQuery
    implements InternalCompassSpanQuery {
        private SearchEngineQuery.SearchEngineSpanQuery spanQuery;

        public DefaultCompassSpanQuey(SearchEngineQuery.SearchEngineSpanQuery searchEngineQuery, InternalCompass compass) {
            super(searchEngineQuery, compass);
            this.spanQuery = searchEngineQuery;
        }

        public SearchEngineQuery.SearchEngineSpanQuery getSearchEngineSpanQuery() {
            return this.spanQuery;
        }
    }
}

