/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.config.process;

import java.util.Iterator;
import org.compass.core.Property;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.process.MappingProcessor;
import org.compass.core.converter.ConverterLookup;
import org.compass.core.engine.naming.PropertyNamingStrategy;
import org.compass.core.mapping.AliasMapping;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.MappingException;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.mapping.SpellCheck;
import org.compass.core.mapping.internal.InternalAllMapping;
import org.compass.core.mapping.internal.InternalCompassMapping;
import org.compass.core.mapping.internal.InternalResourceMapping;
import org.compass.core.mapping.osem.ClassMapping;
import org.compass.core.mapping.osem.CollectionMapping;
import org.compass.core.mapping.osem.LazyMapping;
import org.compass.core.mapping.osem.internal.InternalLazyMapping;

public class ResolveLateAttributesPreLateBindingMappingProcessor
implements MappingProcessor {
    public CompassMapping process(CompassMapping compassMapping, PropertyNamingStrategy namingStrategy, ConverterLookup converterLookup, CompassSettings settings) throws MappingException {
        ((InternalCompassMapping)compassMapping).setPath(namingStrategy.getRootPath());
        for (AliasMapping aliasMapping : compassMapping.getMappings()) {
            ResourceMapping resourceMapping;
            if (aliasMapping instanceof ClassMapping) {
                ClassMapping classMapping = (ClassMapping)aliasMapping;
                if (!classMapping.isSupportUnmarshallSet()) {
                    classMapping.setSupportUnmarshall(settings.getSettingAsBoolean("compass.osem.supportUnmarshall", true));
                }
                if (classMapping.isFilterDuplicates() == null) {
                    classMapping.setFilterDuplicates(settings.getSettingAsBoolean("compass.osem.filterDuplicates", false));
                }
                this.processClassMappingProperties(classMapping, settings);
            }
            if (aliasMapping instanceof ResourceMapping) {
                resourceMapping = (ResourceMapping)aliasMapping;
                if (resourceMapping.getAllMapping().isSupported() == null) {
                    ((InternalAllMapping)resourceMapping.getAllMapping()).setSupported(settings.getSettingAsBoolean("compass.property.all.enabled", true));
                }
                if (resourceMapping.getAllMapping().isExcludeAlias() == null) {
                    ((InternalAllMapping)resourceMapping.getAllMapping()).setExcludeAlias(settings.getSettingAsBoolean("compass.property.all.excludeAlias", true));
                }
                if (resourceMapping.getAllMapping().isOmitNorms() == null) {
                    ((InternalAllMapping)resourceMapping.getAllMapping()).setOmitNorms(settings.getSettingAsBoolean("compass.property.all.omitNorms", false));
                }
                if (resourceMapping.getAllMapping().isOmitTf() == null) {
                    ((InternalAllMapping)resourceMapping.getAllMapping()).setOmitTf(settings.getSettingAsBoolean("compass.property.all.omitTf", false));
                }
                if (resourceMapping.getAllMapping().getProperty() == null) {
                    ((InternalAllMapping)resourceMapping.getAllMapping()).setProperty(settings.getSetting("compass.property.all", "zzz-all"));
                }
                if (resourceMapping.getAllMapping().getTermVector() == null) {
                    ((InternalAllMapping)resourceMapping.getAllMapping()).setTermVector(Property.TermVector.fromString(settings.getSetting("compass.property.all.termVector", Property.TermVector.NO.toString())));
                }
                if (resourceMapping.getAllMapping().isIncludePropertiesWithNoMappings() == null) {
                    ((InternalAllMapping)resourceMapping.getAllMapping()).setIncludePropertiesWithNoMappings(settings.getSettingAsBoolean("compass.property.all.includeUnmappedProperties", true));
                }
            }
            if (!(aliasMapping instanceof InternalResourceMapping)) continue;
            resourceMapping = (InternalResourceMapping)aliasMapping;
            SpellCheck globablSpellCheck = SpellCheck.fromString(settings.getSetting("compass.engine.spellcheck.defaultMode", "NA"));
            if (resourceMapping.getSpellCheck() != SpellCheck.NA) continue;
            resourceMapping.setSpellCheck(globablSpellCheck);
        }
        return compassMapping;
    }

    private void processClassMappingProperties(ClassMapping classMapping, CompassSettings settings) {
        boolean defaultLazy = settings.getSettingAsBoolean("compass.osem.lazyReference", false);
        Iterator<Mapping> it = classMapping.mappingsIt();
        while (it.hasNext()) {
            Mapping m = it.next();
            if (!(m instanceof LazyMapping)) continue;
            LazyMapping lazyMapping = (LazyMapping)((Object)m);
            if (lazyMapping instanceof CollectionMapping) {
                LazyMapping elementMapping;
                CollectionMapping collectionMapping = (CollectionMapping)lazyMapping;
                if (!(collectionMapping.getElementMapping() instanceof LazyMapping) || (elementMapping = (LazyMapping)((Object)collectionMapping.getElementMapping())).isLazy() != null) continue;
                ((InternalLazyMapping)elementMapping).setLazy(defaultLazy);
                collectionMapping.setLazy(defaultLazy);
                continue;
            }
            ((InternalLazyMapping)lazyMapping).setLazy(false);
        }
    }
}

