/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.sql.Connection;
import javax.sql.DataSource;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.jdbc.JdbcDirectory;
import org.apache.lucene.store.jdbc.datasource.DataSourceUtils;

public class DirectoryTemplate {
    private DataSource dataSource;
    private Directory dir;

    public DirectoryTemplate(Directory dir) {
        this.dir = dir;
        if (dir instanceof JdbcDirectory) {
            this.dataSource = ((JdbcDirectory)dir).getDataSource();
        }
    }

    public void execute(DirectoryCallback callback) throws IOException {
        if (this.dataSource == null) {
            callback.doInDirectory(this.dir);
            return;
        }
        Connection conn = DataSourceUtils.getConnection(this.dataSource);
        try {
            callback.doInDirectory(this.dir);
            DataSourceUtils.commitConnectionIfPossible(conn);
        }
        catch (IOException e) {
            DataSourceUtils.safeRollbackConnectionIfPossible(conn);
            throw e;
        }
        finally {
            DataSourceUtils.releaseConnection(conn);
        }
    }

    public static abstract class DirectoryCallbackWithoutResult
    implements DirectoryCallback {
        public Object doInDirectory(Directory dir) throws IOException {
            this.doInDirectoryWithoutResult(dir);
            return null;
        }

        protected abstract void doInDirectoryWithoutResult(Directory var1) throws IOException;
    }

    public static interface DirectoryCallback {
        public Object doInDirectory(Directory var1) throws IOException;
    }
}

