/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.scheduler;

import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.scheduler.CronTrigger;
import com.liferay.portal.kernel.scheduler.IntervalTrigger;
import com.liferay.portal.kernel.scheduler.SchedulerEntry;
import com.liferay.portal.kernel.scheduler.SchedulerException;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.TriggerType;
import com.liferay.portal.kernel.util.GetterUtil;

public class SchedulerEntryImpl
implements SchedulerEntry {
    private String _description;
    private transient MessageListener _eventListener;
    private String _eventListenerClass;
    private String _propertyKey;
    private TimeUnit _timeUnit;
    private Trigger _trigger;
    private TriggerType _triggerType;
    private String _triggerValue;

    public String getDescription() {
        return this._description;
    }

    public MessageListener getEventListener() {
        return this._eventListener;
    }

    public String getEventListenerClass() {
        return this._eventListenerClass;
    }

    public String getPropertyKey() {
        return this._propertyKey;
    }

    public TimeUnit getTimeUnit() {
        return this._timeUnit;
    }

    public Trigger getTrigger() throws SchedulerException {
        if (this._trigger != null) {
            return this._trigger;
        }
        if (this._triggerType == TriggerType.CRON) {
            this._trigger = new CronTrigger(this._eventListenerClass, this._eventListenerClass, this._triggerValue);
        } else if (this._triggerType == TriggerType.SIMPLE) {
            long intervalTime = GetterUtil.getLong(this._triggerValue);
            intervalTime = this._timeUnit.equals((Object)TimeUnit.DAY) ? (intervalTime *= 86400000L) : (this._timeUnit.equals((Object)TimeUnit.HOUR) ? (intervalTime *= 3600000L) : (this._timeUnit.equals((Object)TimeUnit.MINUTE) ? (intervalTime *= 60000L) : (this._timeUnit.equals((Object)TimeUnit.WEEK) ? (intervalTime *= 604800000L) : (intervalTime *= 1000L))));
            this._trigger = new IntervalTrigger(this._eventListenerClass, this._eventListenerClass, intervalTime);
        } else {
            throw new SchedulerException("Unsupport trigger type " + (Object)((Object)this._triggerType));
        }
        return this._trigger;
    }

    public TriggerType getTriggerType() {
        return this._triggerType;
    }

    public String getTriggerValue() {
        return this._triggerValue;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void setEventListener(MessageListener eventListener) {
        this._eventListener = eventListener;
    }

    public void setEventListenerClass(String eventListenerClass) {
        this._eventListenerClass = eventListenerClass;
    }

    public void setPropertyKey(String propertyKey) {
        this._propertyKey = propertyKey;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this._timeUnit = timeUnit;
    }

    public void setTriggerType(TriggerType triggerType) {
        this._triggerType = triggerType;
    }

    public void setTriggerValue(int triggerValue) {
        this._triggerValue = String.valueOf(triggerValue);
    }

    public void setTriggerValue(long triggerValue) {
        this._triggerValue = String.valueOf(triggerValue);
    }

    public void setTriggerValue(String triggerValue) {
        this._triggerValue = triggerValue;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{description=");
        sb.append(this._description);
        sb.append(", eventListener=");
        sb.append(this._eventListener);
        sb.append(", eventListenerClass=");
        sb.append(this._eventListenerClass);
        sb.append(", propertyKey=");
        sb.append(this._propertyKey);
        sb.append(", timeUnit=");
        sb.append((Object)this._timeUnit);
        sb.append(", trigger=");
        sb.append(this._trigger);
        sb.append(", triggerType=");
        sb.append((Object)this._triggerType);
        sb.append(", triggerValue=");
        sb.append(this._triggerValue);
        sb.append("}");
        return sb.toString();
    }
}

