/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.io.unsync;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public class UnsyncByteArrayOutputStream
extends OutputStream {
    protected byte[] buffer;
    protected int index;

    public UnsyncByteArrayOutputStream() {
        this(32);
    }

    public UnsyncByteArrayOutputStream(int size) {
        this.buffer = new byte[size];
    }

    public void reset() {
        this.index = 0;
    }

    public int size() {
        return this.index;
    }

    public byte[] toByteArray() {
        byte[] newBuffer = new byte[this.index];
        System.arraycopy(this.buffer, 0, newBuffer, 0, this.index);
        return newBuffer;
    }

    public String toString() {
        return new String(this.buffer, 0, this.index);
    }

    public String toString(String charsetName) throws UnsupportedEncodingException {
        return new String(this.buffer, 0, this.index, charsetName);
    }

    public byte[] unsafeGetByteArray() {
        return this.buffer;
    }

    public ByteBuffer unsafeGetByteBuffer() {
        return ByteBuffer.wrap(this.buffer, 0, this.index);
    }

    public void write(byte[] byteArray) {
        this.write(byteArray, 0, byteArray.length);
    }

    public void write(byte[] byteArray, int offset, int length) {
        if (length <= 0) {
            return;
        }
        int newIndex = this.index + length;
        if (newIndex > this.buffer.length) {
            int newBufferSize = Math.max(this.buffer.length << 1, newIndex);
            byte[] newBuffer = new byte[newBufferSize];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.index);
            this.buffer = newBuffer;
        }
        System.arraycopy(byteArray, offset, this.buffer, this.index, length);
        this.index = newIndex;
    }

    public void write(int b) {
        int newIndex = this.index + 1;
        if (newIndex > this.buffer.length) {
            int newBufferSize = Math.max(this.buffer.length << 1, newIndex);
            byte[] newBuffer = new byte[newBufferSize];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
            this.buffer = newBuffer;
        }
        this.buffer[this.index] = (byte)b;
        this.index = newIndex;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.buffer, 0, this.index);
    }
}

