/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.image;

import com.liferay.portal.kernel.image.ImageBag;
import com.liferay.portal.kernel.image.ImageProcessor;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public class ImageProcessorUtil {
    private static ImageProcessor _imageProcessor;

    public static BufferedImage convertImageType(BufferedImage sourceImage, int type) {
        return ImageProcessorUtil.getImageProcessor().convertImageType(sourceImage, type);
    }

    public static void encodeGIF(RenderedImage renderedImage, OutputStream os) throws IOException {
        ImageProcessorUtil.getImageProcessor().encodeGIF(renderedImage, os);
    }

    public static void encodeWBMP(RenderedImage renderedImage, OutputStream os) throws InterruptedException, IOException {
        ImageProcessorUtil.getImageProcessor().encodeWBMP(renderedImage, os);
    }

    public static BufferedImage getBufferedImage(RenderedImage renderedImage) {
        return ImageProcessorUtil.getImageProcessor().getBufferedImage(renderedImage);
    }

    public static byte[] getBytes(RenderedImage renderedImage, String contentType) throws IOException {
        return ImageProcessorUtil.getImageProcessor().getBytes(renderedImage, contentType);
    }

    public static ImageProcessor getImageProcessor() {
        return _imageProcessor;
    }

    public static ImageBag read(File file) throws IOException {
        return ImageProcessorUtil.getImageProcessor().read(file);
    }

    public static ImageBag read(byte[] bytes) throws IOException {
        return ImageProcessorUtil.getImageProcessor().read(bytes);
    }

    public static RenderedImage scale(RenderedImage renderedImage, int maxHeight, int maxWidth) {
        return ImageProcessorUtil.getImageProcessor().scale(renderedImage, maxHeight, maxWidth);
    }

    public void setImageProcessor(ImageProcessor imageProcessor) {
        _imageProcessor = imageProcessor;
    }
}

