/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.concurrent;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockRegistry {
    private static ConcurrentHashMap<String, ConcurrentHashMap<String, Lock>> _lockGroupMap = new ConcurrentHashMap();

    public static Lock allocateLock(String groupName, String key) {
        Lock oldLock;
        Lock lock;
        ConcurrentHashMap<String, Lock> oldLockGroup;
        ConcurrentHashMap<String, Lock> lockGroup = _lockGroupMap.get(groupName);
        if (lockGroup == null && (oldLockGroup = _lockGroupMap.putIfAbsent(groupName, lockGroup = new ConcurrentHashMap())) != null) {
            lockGroup = oldLockGroup;
        }
        if ((lock = lockGroup.get(key)) == null && (oldLock = lockGroup.putIfAbsent(key, lock = new ReentrantLock())) != null) {
            lock = oldLock;
        }
        return lock;
    }

    public static void freeAllLock() {
        LockRegistry.freeAllLock(false);
    }

    public static void freeAllLock(boolean unlock) {
        if (unlock) {
            for (Map map : _lockGroupMap.values()) {
                for (Lock lock : map.values()) {
                    lock.unlock();
                }
            }
        }
        _lockGroupMap.clear();
    }

    public static Map<String, Lock> freeLock(String groupName) {
        return LockRegistry.freeLock(groupName, false);
    }

    public static Map<String, Lock> freeLock(String groupName, boolean unlock) {
        Map lockGroup = _lockGroupMap.remove(groupName);
        if (lockGroup == null) {
            return null;
        }
        if (unlock) {
            for (Lock lock : lockGroup.values()) {
                lock.unlock();
            }
        }
        return lockGroup;
    }

    public static Lock freeLock(String groupName, String key) {
        return LockRegistry.freeLock(groupName, key, false);
    }

    public static Lock freeLock(String groupName, String key, boolean unlock) {
        Map lockGroup = _lockGroupMap.get(groupName);
        if (lockGroup == null) {
            return null;
        }
        Lock lock = (Lock)lockGroup.remove(key);
        if (lock == null) {
            return null;
        }
        if (unlock) {
            lock.unlock();
        }
        return lock;
    }
}

