/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cal;

import com.liferay.portal.kernel.cal.DayAndPosition;
import com.liferay.portal.kernel.cal.Duration;
import com.liferay.portal.kernel.cal.Recurrence;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Calendar;
import java.util.TimeZone;

public class TZSRecurrence
extends Recurrence {
    private TimeZone _timeZone;

    public TZSRecurrence() {
    }

    public TZSRecurrence(Calendar start, Duration duration) {
        super(start, duration);
    }

    public TZSRecurrence(Calendar start, Duration duration, int frequency) {
        super(start, duration, frequency);
    }

    public TimeZone getTimeZone() {
        return this._timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this._timeZone = timeZone;
    }

    protected boolean matchesByField(int[] array, int field, Calendar candidate, boolean allowNegative, TimeZone timeZone) {
        Calendar adjustedCandidate = candidate;
        if (Validator.isNotNull(timeZone)) {
            adjustedCandidate = CalendarFactoryUtil.getCalendar(timeZone);
            adjustedCandidate.setTime(candidate.getTime());
        }
        return TZSRecurrence.matchesByField(array, field, adjustedCandidate, allowNegative);
    }

    protected boolean matchesIndividualByDay(Calendar candidate, DayAndPosition pos) {
        Calendar adjustedCandidate = candidate;
        if (Validator.isNotNull(this._timeZone)) {
            adjustedCandidate = CalendarFactoryUtil.getCalendar(this._timeZone);
            adjustedCandidate.setTime(candidate.getTime());
        }
        return super.matchesIndividualByDay(adjustedCandidate, pos);
    }

    protected boolean matchesByMonthDay(Calendar candidate) {
        return this.matchesByField(this.byMonthDay, 5, candidate, true, this._timeZone);
    }

    protected boolean matchesByYearDay(Calendar candidate) {
        return this.matchesByField(this.byYearDay, 6, candidate, true, this._timeZone);
    }

    protected boolean matchesByWeekNo(Calendar candidate) {
        return this.matchesByField(this.byWeekNo, 3, candidate, true, this._timeZone);
    }

    protected boolean matchesByMonth(Calendar candidate) {
        return this.matchesByField(this.byMonth, 2, candidate, false, this._timeZone);
    }
}

