/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.util;

import com.liferay.portal.freemarker.FreeMarkerVariables;
import com.liferay.portal.kernel.freemarker.FreeMarkerContext;
import com.liferay.portal.kernel.freemarker.FreeMarkerEngineUtil;
import com.liferay.portal.kernel.io.unsync.UnsyncPrintWriter;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.PipingServletResponse;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.velocity.VelocityContext;
import com.liferay.portal.kernel.velocity.VelocityEngineUtil;
import com.liferay.portal.model.Theme;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.velocity.VelocityVariables;
import com.liferay.taglib.util.VelocityTaglib;
import freemarker.ext.jsp.TaglibFactory;
import freemarker.ext.servlet.HttpRequestHashModel;
import freemarker.ext.servlet.ServletContextHashModel;
import freemarker.template.ObjectWrapper;
import java.io.Writer;
import javax.servlet.GenericServlet;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.struts.tiles.ComponentContext;

public class ThemeUtil {
    private static final String _TEMPLATE_EXTENSION_FTL = "ftl";
    private static final String _TEMPLATE_EXTENSION_VM = "vm";
    private static Log _log = LogFactoryUtil.getLog(ThemeUtil.class);

    public static void include(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, PageContext pageContext, String page, Theme theme) throws Exception {
        String extension = theme.getTemplateExtension();
        if (extension.equals(_TEMPLATE_EXTENSION_FTL)) {
            ThemeUtil.includeFTL(servletContext, request, pageContext, page, theme, true);
        } else if (extension.equals(_TEMPLATE_EXTENSION_VM)) {
            ThemeUtil.includeVM(servletContext, request, pageContext, page, theme, true);
        } else {
            String path = String.valueOf(theme.getTemplatesPath()) + "/" + page;
            ThemeUtil.includeJSP(servletContext, request, response, path, theme);
        }
    }

    public static String includeFTL(ServletContext servletContext, HttpServletRequest request, PageContext pageContext, String page, Theme theme, boolean write) throws Exception {
        String servletContextName = GetterUtil.getString((String)theme.getServletContextName());
        if (ServletContextPool.get((String)servletContextName) == null) {
            ServletContextPool.put((String)servletContextName, (ServletContext)servletContext);
        }
        int pos = page.lastIndexOf(46);
        StringBundler sb = new StringBundler(7);
        sb.append(servletContextName);
        sb.append(theme.getFreeMarkerTemplateLoader());
        sb.append(theme.getTemplatesPath());
        sb.append("/");
        sb.append(page.substring(0, pos));
        sb.append(".");
        sb.append(_TEMPLATE_EXTENSION_FTL);
        String source = sb.toString();
        if (!FreeMarkerEngineUtil.resourceExists((String)source)) {
            _log.error((Object)(String.valueOf(source) + " does not exist"));
            return null;
        }
        FreeMarkerContext freeMarkerContext = FreeMarkerEngineUtil.getWrappedStandardToolsContext();
        FreeMarkerVariables.insertVariables((FreeMarkerContext)freeMarkerContext, (HttpServletRequest)request);
        ServletContext themeServletContext = ServletContextPool.get((String)servletContextName);
        freeMarkerContext.put("themeServletContext", (Object)themeServletContext);
        HttpServletResponse response = (HttpServletResponse)pageContext.getResponse();
        Object writer = null;
        writer = write ? new UnsyncPrintWriter((Writer)pageContext.getOut()) : new UnsyncStringWriter();
        VelocityTaglib velocityTaglib = new VelocityTaglib(servletContext, request, (HttpServletResponse)new PipingServletResponse(response, (Writer)writer), pageContext);
        request.setAttribute("VELOCITY_TAGLIB", (Object)velocityTaglib);
        freeMarkerContext.put("taglibLiferay", (Object)velocityTaglib);
        freeMarkerContext.put("theme", (Object)velocityTaglib);
        TaglibFactory portalTaglib = new TaglibFactory(servletContext);
        freeMarkerContext.put("PortalJspTagLibs", (Object)portalTaglib);
        TaglibFactory themeTaglib = new TaglibFactory(themeServletContext);
        freeMarkerContext.put("ThemeJspTaglibs", (Object)themeTaglib);
        ServletContextHashModel servletContextHashModel = new ServletContextHashModel((GenericServlet)pageContext.getPage(), ObjectWrapper.DEFAULT_WRAPPER);
        freeMarkerContext.put("Application", (Object)servletContextHashModel);
        HttpRequestHashModel httpRequestHashModel = new HttpRequestHashModel(request, response, ObjectWrapper.DEFAULT_WRAPPER);
        freeMarkerContext.put("Request", (Object)httpRequestHashModel);
        FreeMarkerEngineUtil.mergeTemplate((String)source, (FreeMarkerContext)freeMarkerContext, (Writer)writer);
        if (write) {
            return null;
        }
        return writer.toString();
    }

    public static void includeJSP(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, String path, Theme theme) throws Exception {
        if (theme.isWARFile()) {
            ServletContext themeServletContext = servletContext.getContext(theme.getContextPath());
            if (themeServletContext == null) {
                _log.error((Object)("Theme " + theme.getThemeId() + " cannot find its " + "servlet context at " + theme.getServletContextName()));
            } else {
                RequestDispatcher requestDispatcher = themeServletContext.getRequestDispatcher(path);
                if (requestDispatcher == null) {
                    _log.error((Object)("Theme " + theme.getThemeId() + " does not have " + path));
                } else {
                    requestDispatcher.include((ServletRequest)request, (ServletResponse)response);
                }
            }
        } else {
            RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(path);
            if (requestDispatcher == null) {
                _log.error((Object)("Theme " + theme.getThemeId() + " does not have " + path));
            } else {
                requestDispatcher.include((ServletRequest)request, (ServletResponse)response);
            }
        }
    }

    public static String includeVM(ServletContext servletContext, HttpServletRequest request, PageContext pageContext, String page, Theme theme, boolean write) throws Exception {
        String servletContextName = GetterUtil.getString((String)theme.getServletContextName());
        if (ServletContextPool.get((String)servletContextName) == null) {
            ServletContextPool.put((String)servletContextName, (ServletContext)servletContext);
        }
        int pos = page.lastIndexOf(46);
        StringBundler sb = new StringBundler(7);
        sb.append(servletContextName);
        sb.append(theme.getVelocityResourceListener());
        sb.append(theme.getTemplatesPath());
        sb.append("/");
        sb.append(page.substring(0, pos));
        sb.append(".");
        sb.append(_TEMPLATE_EXTENSION_VM);
        String source = sb.toString();
        if (!VelocityEngineUtil.resourceExists((String)source)) {
            _log.error((Object)(String.valueOf(source) + " does not exist"));
            return null;
        }
        VelocityContext velocityContext = VelocityEngineUtil.getWrappedStandardToolsContext();
        VelocityVariables.insertVariables((VelocityContext)velocityContext, (HttpServletRequest)request);
        ServletContext themeServletContext = ServletContextPool.get((String)servletContextName);
        velocityContext.put("themeServletContext", (Object)themeServletContext);
        HttpServletResponse response = (HttpServletResponse)pageContext.getResponse();
        Object writer = null;
        writer = write ? pageContext.getOut() : new UnsyncStringWriter();
        VelocityTaglib velocityTaglib = new VelocityTaglib(servletContext, request, (HttpServletResponse)new PipingServletResponse(response, (Writer)writer), pageContext);
        request.setAttribute("VELOCITY_TAGLIB", (Object)velocityTaglib);
        velocityContext.put("taglibLiferay", (Object)velocityTaglib);
        velocityContext.put("theme", (Object)velocityTaglib);
        velocityContext.put("writer", writer);
        VelocityEngineUtil.mergeTemplate((String)source, (VelocityContext)velocityContext, (Writer)writer);
        if (write) {
            return null;
        }
        return ((UnsyncStringWriter)writer).toString();
    }

    public static void insertTilesVariables(HttpServletRequest request) {
        ComponentContext componentContext = (ComponentContext)request.getAttribute("org.apache.struts.taglib.tiles.CompContext");
        if (componentContext == null) {
            return;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        String tilesTitle = (String)componentContext.getAttribute("title");
        String tilesContent = (String)componentContext.getAttribute("content");
        boolean tilesSelectable = GetterUtil.getBoolean((String)((String)componentContext.getAttribute("selectable")));
        themeDisplay.setTilesTitle(tilesTitle);
        themeDisplay.setTilesContent(tilesContent);
        themeDisplay.setTilesSelectable(tilesSelectable);
    }
}

