/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.oidc.lr62;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.UserLocalServiceUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.gcube.oidc.D4ScienceMappings;
import org.gcube.oidc.OIDCToSitesAndRolesMapper;
import org.gcube.oidc.Site;
import org.gcube.oidc.SitesMapperExecption;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.RoleManager;
import org.gcube.vomanagement.usermanagement.UserManager;
import org.gcube.vomanagement.usermanagement.exception.GroupRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.RoleRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.UserManagementPortalException;
import org.gcube.vomanagement.usermanagement.exception.UserManagementSystemException;
import org.gcube.vomanagement.usermanagement.exception.UserRetrievalFault;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayRoleManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeGroup;
import org.gcube.vomanagement.usermanagement.model.GCubeRole;

public class UserSitesToGroupsAndRolesMapper {
    protected static final Log log = LogFactoryUtil.getLog(UserSitesToGroupsAndRolesMapper.class);
    protected User user;
    protected OIDCToSitesAndRolesMapper mapper;
    protected UserManager userManager;
    protected GroupManager groupManager;
    protected RoleManager roleManager;
    protected String rootVOName;
    protected Map<GCubeGroup, List<GCubeRole>> actualGroupAndRoles;
    protected Map<String, GCubeRole> roleNameToRole;

    public UserSitesToGroupsAndRolesMapper(User user, OIDCToSitesAndRolesMapper mapper) {
        this.user = user;
        this.mapper = mapper;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Creating the permission checker for admin user");
            }
            long adminUserId = LiferayUserManager.getAdmin().getUserId();
            PrincipalThreadLocal.setName((long)adminUserId);
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)PermissionCheckerFactoryUtil.create((User)UserLocalServiceUtil.getUser((long)adminUserId)));
        }
        catch (Exception e) {
            log.fatal((Object)"Cannot create permission checker for admin user", (Throwable)e);
            return;
        }
        this.userManager = new LiferayUserManager();
        this.groupManager = new LiferayGroupManager();
        this.roleManager = new LiferayRoleManager();
        try {
            this.rootVOName = this.groupManager.getRootVOName();
        }
        catch (GroupRetrievalFault | UserManagementSystemException e) {
            log.error((Object)"Cannot get infrastructure's Root VO", e);
            return;
        }
        try {
            this.actualGroupAndRoles = this.groupManager.listGroupsAndRolesByUser(user.getUserId());
        }
        catch (UserManagementSystemException e) {
            log.error((Object)"Cannot get sites and roles membership for user", (Throwable)e);
            return;
        }
        this.roleNameToRole = new TreeMap<String, GCubeRole>();
        for (GCubeRole role : this.roleManager.listAllGroupRoles()) {
            this.roleNameToRole.put(role.getRoleName(), role);
        }
    }

    public void map() {
        log.info((Object)("Mapping roles to sites for user: " + this.user.getScreenName()));
        Site gwSitesTree = null;
        try {
            gwSitesTree = this.mapper.map(this.rootVOName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sites tree is: " + (gwSitesTree != null ? gwSitesTree.dump() : "null")));
            }
        }
        catch (SitesMapperExecption e) {
            log.error((Object)"Computing sites tree in concrete mapper class", (Throwable)e);
        }
        if (gwSitesTree != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Check user to sites assignemnts");
            }
            this.rolesToSiteDescendant(gwSitesTree, null);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Check user to sites removal");
        }
        this.checkForSiteRemoval(gwSitesTree);
    }

    protected void rolesToSiteDescendant(Site actualSite, GCubeGroup parentGroup) {
        GCubeGroup actualSiteGroup = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Getting actual site group from group manager, actual site name=" + actualSite.getName()));
            }
            actualSiteGroup = this.groupManager.getGroup(this.groupManager.getGroupId(actualSite.getName()));
        }
        catch (GroupRetrievalFault | UserManagementSystemException e) {
            log.error((Object)("Cannot retrieve group for site: " + actualSite.getName()), e);
            return;
        }
        try {
            if (this.groupManager.isVRE(actualSiteGroup.getGroupId()).booleanValue() && !this.actualGroupAndRoles.containsKey(actualSiteGroup)) {
                log.info((Object)("Assigning user to new VRE site: " + actualSiteGroup.getGroupName()));
                this.userManager.assignUserToGroup(actualSiteGroup.getGroupId(), this.user.getUserId());
                if (actualSite.getRoles() != null && !actualSite.getRoles().isEmpty()) {
                    log.info((Object)"Assiging roles for the VRE site");
                    for (String roleName : actualSite.getRoles()) {
                        if (D4ScienceMappings.Role.MEMBER.asString().equals(roleName)) continue;
                        this.roleManager.assignRoleToUser(this.user.getUserId(), actualSiteGroup.getGroupId(), this.roleNameToRole.get(roleName).getRoleId());
                    }
                    return;
                }
                log.info((Object)"User has no roles in the VRE site");
            }
        }
        catch (RuntimeException | GroupRetrievalFault | RoleRetrievalFault | UserManagementPortalException | UserManagementSystemException | UserRetrievalFault e) {
            log.error((Object)("Assigning user to new VRE site: " + actualSiteGroup.getGroupName()), e);
        }
        if (actualSite.getRoles() != null) {
            List<GCubeRole> actualSiteGroupRoles = this.actualGroupAndRoles.get(actualSiteGroup);
            ArrayList newRoles = new ArrayList(actualSite.getRoles());
            newRoles.remove(D4ScienceMappings.Role.MEMBER.asString());
            if (actualSiteGroupRoles != null && !actualSiteGroupRoles.isEmpty()) {
                log.info((Object)"Checking actual roles in the dite group");
                for (GCubeRole gcRole : actualSiteGroupRoles) {
                    String actualSiteName = actualSite.getName();
                    String gcRoleName = gcRole.getRoleName();
                    if (!actualSite.getRoles().contains(gcRoleName)) {
                        try {
                            log.info((Object)("Removing '" + gcRoleName + "' user's role for site: " + actualSiteName));
                            this.roleManager.removeRoleFromUser(this.user.getUserId(), actualSiteGroup.getGroupId(), gcRole.getRoleId());
                        }
                        catch (GroupRetrievalFault | RoleRetrievalFault | UserManagementSystemException | UserRetrievalFault e) {
                            log.error((Object)("Cannot remove user's role '" + gcRoleName + "' for site: " + actualSite.getName()), e);
                        }
                        continue;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Removing site role from the roles list: " + gcRoleName));
                    }
                    newRoles.remove(gcRoleName);
                }
            } else {
                log.info((Object)"User actually has no roles in the site group");
            }
            for (String newRole : newRoles) {
                GCubeRole newGcRole;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding new role to user. New role=" + newRole));
                }
                if ((newGcRole = this.roleNameToRole.get(newRole)) != null) {
                    try {
                        log.info((Object)("Assinging new role '" + newRole + "' to user"));
                        this.roleManager.assignRoleToUser(this.user.getUserId(), actualSiteGroup.getGroupId(), newGcRole.getRoleId());
                    }
                    catch (GroupRetrievalFault | RoleRetrievalFault | UserManagementSystemException | UserRetrievalFault e) {
                        log.error((Object)("Cannot assign new role '" + newRole + "' for site: " + actualSite.getName()), e);
                    }
                    continue;
                }
                log.warn((Object)("New site's gc role is null (doesn't exist?) after getting it from role manager: " + newRole));
            }
        } else {
            log.info((Object)("Roles were not set, continuing descending letting them untouched in site: " + actualSite.getName()));
        }
        for (String childSite : actualSite.getChildren().keySet()) {
            log.info((Object)("Recursive call to child site: " + childSite));
            this.rolesToSiteDescendant((Site)actualSite.getChildren().get(childSite), actualSiteGroup);
        }
    }

    protected void checkForSiteRemoval(Site gwSitesTree) {
        ArrayList<String> vreNames = new ArrayList<String>();
        if (gwSitesTree != null) {
            log.debug((Object)"Collecting VREs user belongs to");
            for (String voName : gwSitesTree.getChildren().keySet()) {
                for (String vreName : ((Site)gwSitesTree.getChildren().get(voName)).getChildren().keySet()) {
                    log.debug((Object)("Adding VRE to the list: " + vreName));
                    vreNames.add(vreName);
                }
            }
        } else {
            log.info((Object)"User not belongs to any site");
        }
        for (GCubeGroup actualGroup : this.actualGroupAndRoles.keySet()) {
            try {
                if (this.groupManager.isVRE(actualGroup.getGroupId()).booleanValue() && !vreNames.contains(actualGroup.getGroupName())) {
                    log.info((Object)("Removing user from VRE: " + actualGroup.getGroupName()));
                    try {
                        this.userManager.dismissUserFromGroup(actualGroup.getGroupId(), this.user.getUserId());
                    }
                    catch (UserRetrievalFault e) {
                        log.error((Object)("Removing user from VRE: " + actualGroup.getGroupName()), (Throwable)e);
                    }
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("User still belong to VRE: " + actualGroup.getGroupName()));
            }
            catch (GroupRetrievalFault | UserManagementSystemException e) {
                log.error((Object)"Checking if site group is a VRE", e);
            }
        }
    }
}

