/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.oidc.lr62;

import com.liferay.portal.model.User;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpSession;
import org.gcube.oidc.rest.JWTToken;
import org.gcube.portal.oidc.lr62.JWTCacheProxy;
import org.gcube.portal.oidc.lr62.JWTTokenUtil;

public class IntraVMJWTCacheProxy
extends JWTCacheProxy {
    private Map<User, Map<HttpSession, String>> oidcTokens;
    private Map<User, Map<HttpSession, String>> rptTokens;

    protected IntraVMJWTCacheProxy() {
        log.info((Object)"Initializing tokens caches");
        this.oidcTokens = Collections.synchronizedMap(new TreeMap());
        this.rptTokens = Collections.synchronizedMap(new TreeMap());
    }

    public void checkMap(Map<User, Map<HttpSession, String>> map, User user) {
        if (!map.containsKey(user)) {
            log.debug((Object)("Initializing map for user: " + user.getScreenName()));
            map.put(user, Collections.synchronizedMap(new TreeMap(new Comparator<HttpSession>(){

                @Override
                public int compare(HttpSession s1, HttpSession s2) {
                    return s1.getId().compareTo(s2.getId());
                }
            })));
        }
    }

    @Override
    public void setOIDCToken(User user, HttpSession session, JWTToken token) {
        this.checkMap(this.oidcTokens, user);
        Map<HttpSession, String> oidcUserMap = this.oidcTokens.get(user);
        log.trace((Object)("OIDC user's sessions recorded: " + oidcUserMap.keySet().toArray()));
        oidcUserMap.put(session, JWTTokenUtil.getRawContent(token));
    }

    @Override
    public void setUMAToken(User user, HttpSession session, JWTToken token) {
        this.checkMap(this.rptTokens, user);
        Map<HttpSession, String> umaUserMap = this.rptTokens.get(user);
        log.trace((Object)("UMA user's sessions recorded objs: " + umaUserMap.keySet().toArray()));
        umaUserMap.put(session, JWTTokenUtil.getRawContent(token));
    }

    @Override
    public JWTToken getOIDCToken(User user, HttpSession session) {
        this.checkMap(this.oidcTokens, user);
        log.trace((Object)("Getting OIDC token for user '" + user.getScreenName() + "' and session obj: " + session));
        return JWTTokenUtil.fromString(this.oidcTokens.get(user).get(session));
    }

    @Override
    public JWTToken getUMAToken(User user, HttpSession session) {
        this.checkMap(this.rptTokens, user);
        log.trace((Object)("Getting UMA token for user '" + user.getScreenName() + "' and session obj: " + session));
        return JWTTokenUtil.fromString(this.rptTokens.get(user).get(session));
    }

    @Override
    public void removeOIDCToken(User user, HttpSession session) {
        this.checkMap(this.oidcTokens, user);
        if (this.oidcTokens.get(user).containsKey(session)) {
            log.trace((Object)("Removing OIDC token for user '" + user.getScreenName() + "' and session obj: " + session));
            this.oidcTokens.get(user).remove(session);
        }
    }

    @Override
    public void removeUMAToken(User user, HttpSession session) {
        this.checkMap(this.rptTokens, user);
        if (this.rptTokens.get(user).containsKey(session)) {
            log.trace((Object)("Removing UMA token for user '" + user.getScreenName() + "' and session obj: " + session));
            this.oidcTokens.get(user).remove(session);
        }
    }

    @Override
    public void removeAllOIDCTokens(User user) {
        log.trace((Object)("Removing OIDC session's tokens of user: " + user.getScreenName()));
        this.oidcTokens.remove(user);
    }

    @Override
    public void removeAllUMATokens(User user) {
        log.trace((Object)("Removing UMA session's tokens of user: " + user.getScreenName()));
        this.rptTokens.remove(user);
    }

    @Override
    public void clearOIDCTokens() {
        log.trace((Object)"Clearing OIDC tokens cache");
        this.oidcTokens.clear();
    }

    @Override
    public void clearUMATokens() {
        log.trace((Object)"Clearing UMA tokens cache");
        this.rptTokens.clear();
    }

    @Override
    public void clearAllTokens() {
        this.clearOIDCTokens();
        this.clearUMATokens();
    }
}

