package org.gcube.portal.oidc.lr62;

import javax.servlet.http.HttpSession;

import org.gcube.oidc.rest.JWTToken;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.User;

public abstract class JWTCacheProxy {

    protected static final Log log = LogFactoryUtil.getLog(JWTCacheProxy.class);

    protected static JWTCacheProxy instance;

    public JWTCacheProxy() {
        instance = this;
    }
    public static synchronized JWTCacheProxy getInstance() {
        return instance != null ? instance : new IntraVMJWTCacheProxy();
    }

    public abstract void setOIDCToken(User user, HttpSession session, JWTToken token);

    public abstract void setUMAToken(User user, HttpSession session, JWTToken token);

    public abstract JWTToken getOIDCToken(User user, HttpSession session);

    public abstract JWTToken getUMAToken(User user, HttpSession session);

    public abstract void removeOIDCToken(User user, HttpSession session);

    public abstract void removeUMAToken(User user, HttpSession session);

    public abstract void removeAllOIDCTokens(User user);

    public abstract void removeAllUMATokens(User user);

    public abstract void clearOIDCTokens();

    public abstract void clearUMATokens();

    public abstract void clearAllTokens();

}