/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.oidc.lr62;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import org.gcube.common.authorization.library.provider.UmaJWTProvider;
import org.gcube.oidc.rest.JWTToken;
import org.gcube.oidc.rest.OpenIdConnectRESTHelper;
import org.gcube.portal.oidc.lr62.JWTTokenUtil;
import org.gcube.portal.oidc.lr62.LiferayOpenIdConnectConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OIDCUmaUtil {
    private static final Logger log = LoggerFactory.getLogger(OIDCUmaUtil.class);

    public static void provideConfiguredPortalClientUMATokenInThreadLocal(String infraContext) {
        LiferayOpenIdConnectConfiguration configuration = LiferayOpenIdConnectConfiguration.getConfiguration();
        String clientId = configuration.getPortalClientId();
        String clientSecret = configuration.getPortalClientSecret();
        OIDCUmaUtil.provideClientUMATokenInThreadLocal(clientId, clientSecret, configuration.getTokenURL(), infraContext);
    }

    public static void provideClientUMATokenInThreadLocal(String clientId, String clientSecret, URL tokenURL, String infraContext) {
        try {
            log.debug("Getting client token from server");
            JWTToken clientToken = OpenIdConnectRESTHelper.queryClientToken((String)clientId, (String)clientSecret, (URL)tokenURL);
            OIDCUmaUtil.provideClientUMATokenInThreadLocal(clientToken.getAccessTokenAsBearer(), tokenURL, infraContext);
        }
        catch (Exception e) {
            log.error("Cannot retrieve client OIDC token", (Throwable)e);
            return;
        }
    }

    public static void provideClientUMATokenInThreadLocal(String clientAuthorizationBearer, URL tokenURL, String infraContext) {
        String encodedContext;
        try {
            encodedContext = URLEncoder.encode(infraContext, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("Cannot URL encode context", (Throwable)e);
            return;
        }
        log.debug("URL encoded context is: {}", (Object)encodedContext);
        try {
            log.debug("Getting UMA token from server");
            JWTToken umaToken = OpenIdConnectRESTHelper.queryUMAToken((URL)tokenURL, (String)clientAuthorizationBearer, (String)encodedContext, null);
            log.debug("Setting token in the UMA JWT provider");
            UmaJWTProvider.instance.set(JWTTokenUtil.getRawContent(umaToken));
        }
        catch (Exception e) {
            log.error("Cannot retrieve client UMA token", (Throwable)e);
            return;
        }
    }
}

