package org.gcube.portal.oidc.lr62;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;

import org.gcube.common.authorization.library.provider.UmaJWTProvider;
import org.gcube.oidc.rest.JWTToken;
import org.gcube.oidc.rest.OpenIdConnectConfiguration;
import org.gcube.oidc.rest.OpenIdConnectRESTHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OIDCUmaUtil {

    private static final Logger log = LoggerFactory.getLogger(OIDCUmaUtil.class);

    public static void provideConfiguredPortalClientUMATokenInThreadLocal(String infraContext) {
        OpenIdConnectConfiguration configuration = LiferayOpenIdConnectConfiguration.getConfiguration();
        String clientId = configuration.getPortalClientId();
        String clientSecret = configuration.getPortalClientSecret();

        provideClientUMATokenInThreadLocal(clientId, clientSecret, configuration.getTokenURL(), infraContext);
    }

    public static void provideClientUMATokenInThreadLocal(String clientId, String clientSecret, URL tokenURL,
            String infraContext) {

        try {
            log.debug("Getting client token from server");
            JWTToken clientToken = OpenIdConnectRESTHelper.queryClientToken(clientId, clientSecret, tokenURL);
            provideClientUMATokenInThreadLocal(clientToken.getAsBearer(), tokenURL, infraContext);
        } catch (Exception e) {
            log.error("Cannot retrieve client OIDC token", e);
            return;
        }
    }

    public static void provideClientUMATokenInThreadLocal(String clientAuthorizationBearer, URL tokenURL,
            String infraContext) {

        String encodedContext;
        try {
            encodedContext = URLEncoder.encode(infraContext, "UTF-8");
        } catch (UnsupportedEncodingException e) {
            log.error("Cannot URL encode context", e);
            return;
        }
        log.debug("URL encoded context is: {}", encodedContext);
        try {
            log.debug("Getting UMA token from server");
            JWTToken umaToken = OpenIdConnectRESTHelper.queryUMAToken(tokenURL, clientAuthorizationBearer,
                    encodedContext, null);

            log.debug("Setting token in the UMA JWT provider");
            UmaJWTProvider.instance.set(JWTTokenUtil.getRawContent(umaToken));
        } catch (Exception e) {
            log.error("Cannot retrieve client UMA token", e);
            return;
        }
    }
}
