package org.gcube.portal.oidc.lr62;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

import javax.servlet.http.HttpSession;

import org.gcube.oidc.rest.JWTToken;

import com.liferay.portal.model.User;

public class IntraVMJWTCacheProxy extends JWTCacheProxy {

    private Map<String, String> oidcTokens;
    private Map<String, String> rptTokens;

    protected IntraVMJWTCacheProxy() {
        oidcTokens = Collections.synchronizedMap(new TreeMap<>());
        rptTokens = Collections.synchronizedMap(new TreeMap<>());
    }

    @Override
    public void setOIDCToken(User user, HttpSession session, JWTToken token) {
        oidcTokens.put(generateKey(user, session), JWTTokenUtil.getRawContent(token));
    }

    @Override
    public void setUMAToken(User user, HttpSession session, JWTToken token) {
        rptTokens.put(generateKey(user, session), JWTTokenUtil.getRawContent(token));
    }

    @Override
    public JWTToken getOIDCToken(User user, HttpSession session) {
        return JWTTokenUtil.fromString(oidcTokens.get(generateKey(user, session)));
    }

    @Override
    public JWTToken getUMAToken(User user, HttpSession session) {
        return JWTTokenUtil.fromString(rptTokens.get(generateKey(user, session)));
    }

    @Override
    public void removeOIDCToken(User user, HttpSession session) {
        oidcTokens.remove(generateKey(user, session));
    }

    @Override
    public void removeUMAToken(User user, HttpSession session) {
        rptTokens.remove(generateKey(user, session));
    }

    @Override
    public void clearOIDCTokens() {
        oidcTokens.clear();
    }

    @Override
    public void clearUMATokens() {
        rptTokens.clear();
    }

    @Override
    public void clearAllTokens() {
        clearOIDCTokens();
        clearUMATokens();
    }

}
