package org.gcube.portal.oidc.lr62;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.gcube.oidc.rest.JWTToken;
import org.gcube.oidc.rest.OpenIdConnectConfiguration;
import org.gcube.oidc.rest.OpenIdConnectRESTHelper;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.BaseFilter;
import com.liferay.portal.model.User;
import com.liferay.portal.util.PortalUtil;

public class OpenIdConnectLoginFilter extends BaseFilter {

    protected static final Log log = LogFactoryUtil.getLog(OpenIdConnectLoginFilter.class);

    public OpenIdConnectLoginFilter() {
        super();
        if (log.isDebugEnabled()) {
            log.debug("Filter created");
        }
    }

    @Override
    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain)
            throws Exception {

        User user;
        try {
            if (log.isDebugEnabled()) {
                log.debug("Getting user via portal utils");
            }
            user = PortalUtil.getUser(request);
        } catch (PortalException | SystemException e) {
            throw new ServletException("Getting user using utils", e);
        }
        HttpSession session = request.getSession(false);
        JWTToken token = null;
        if (user == null) {
            String uri = request.getRequestURI();
            if (log.isDebugEnabled()) {
                log.debug("No user logged in " + uri);
            }
            String sessionId = session.getId();
            OpenIdConnectConfiguration configuration = LiferayOpenIdConnectConfiguration.getConfiguration(request);
            if (request.getParameter("state") != null && request.getParameter("state").equals(sessionId)) {
                try {
                    token = OpenIdConnectRESTHelper.queryToken(request.getServerName(),
                            configuration.getTokenURL(), request.getParameter("code"), configuration.getScope(),
                            request.getRequestURL().toString());
                } catch (Exception e) {
                    throw new ServletException("Querying token from OIDC server", e);
                }
                JWTTokenUtil.putOIDCInRequest(token, request);
                // The auto login class will perform the portal auto login using the token
            } else {
                String oidcRedirectURL = OpenIdConnectRESTHelper.buildLoginRequestURL(
                        configuration.getAuthorizationURL(), "preprod2.d4science.org" , sessionId,
                        request.getRequestURL().toString());

                if (log.isDebugEnabled()) {
                    log.debug("Redirecting to OIDC server login URL: " + oidcRedirectURL);
                }
                response.sendRedirect(oidcRedirectURL);
                return;
            }
        }
        processFilter(getClass(), request, response, filterChain);
    }

    @Override
    protected Log getLog() {
        return log;
    }

}
