/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.notifications.thread;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.gcube.applicationsupportlayer.social.NotificationsManager;
import org.gcube.portal.databook.server.DatabookStore;
import org.gcube.portal.databook.shared.Comment;
import org.gcube.portal.databook.shared.Like;
import org.gcube.vomanagement.usermanagement.UserManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommentNotificationsThread
implements Runnable {
    private static final Logger _log = LoggerFactory.getLogger(CommentNotificationsThread.class);
    String commenterUserId;
    String commentedFeedId;
    private String commentText;
    private String feedOwnerId;
    private NotificationsManager nm;
    private String commentKey;
    private HashSet<String> userIdsToNotify;
    private ArrayList<Like> favorites;
    private UserManager userManager;

    public CommentNotificationsThread(DatabookStore storeInstance, UserManager userManager, String commenterUserId, String commentedFeedId, String commentText, NotificationsManager nm, String feedOwnerId, String commentKey, ArrayList<Like> favorites) {
        this.nm = nm;
        this.commenterUserId = commenterUserId;
        this.commentedFeedId = commentedFeedId;
        this.commentText = commentText;
        this.feedOwnerId = feedOwnerId;
        this.commentKey = commentKey;
        this.favorites = favorites;
        this.userManager = userManager;
        this.userIdsToNotify = new HashSet();
        List feedComments = storeInstance.getAllCommentByFeed(commentedFeedId);
        for (Comment comment : feedComments) {
            if (comment.getUserid().compareTo(commenterUserId) == 0) continue;
            this.userIdsToNotify.add(comment.getUserid());
        }
    }

    @Override
    public void run() {
        String feedOwnerFullName = "";
        try {
            feedOwnerFullName = this.userManager.getUserByUsername(this.feedOwnerId).getFullname();
        }
        catch (Exception e) {
            feedOwnerFullName = this.feedOwnerId;
        }
        ArrayList<String> favoriteUserIds = new ArrayList<String>();
        for (Like favorite : this.favorites) {
            favoriteUserIds.add(favorite.getUserid());
        }
        if (this.userIdsToNotify != null) {
            for (String userId : this.userIdsToNotify) {
                if (userId.compareTo(this.feedOwnerId) == 0 || favoriteUserIds.contains(userId)) continue;
                boolean result = this.nm.notifyCommentReply(userId, this.commentedFeedId, this.commentText, feedOwnerFullName, this.feedOwnerId, this.commentKey);
                _log.trace("Sending Notification for also commented to: " + feedOwnerFullName + " result?" + result);
            }
        }
    }
}

