/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.notifications.thread;

import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;
import java.util.List;
import org.gcube.common.portal.mailing.EmailNotification;
import org.gcube.vomanagement.usermanagement.exception.RoleRetrievalFault;
import org.gcube.vomanagement.usermanagement.impl.LiferayRoleManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.gcube.vomanagement.usermanagement.model.GatewayRolesNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewUserSiteRegistrationNotificationThread
implements Runnable {
    private static Logger _log = LoggerFactory.getLogger(NewUserSiteRegistrationNotificationThread.class);
    final String SUBJECT = "New User registration to site notification";
    private User user;
    private Group site;
    private String siteURL;

    public NewUserSiteRegistrationNotificationThread(User user, Group site, String siteURL) {
        this.user = user;
        this.site = site;
        this.siteURL = siteURL;
    }

    @Override
    public void run() {
        this.handleUserToSiteRegistration(this.user, this.site, this.siteURL);
    }

    private void handleUserToSiteRegistration(User user, Group site, String siteURL) {
        LiferayUserManager um = new LiferayUserManager();
        LiferayRoleManager rm = new LiferayRoleManager();
        try {
            long groupId = site.getGroupId();
            long infraManagerRoleId = -1L;
            try {
                infraManagerRoleId = rm.getRoleIdByName(GatewayRolesNames.INFRASTRUCTURE_MANAGER.getRoleName());
            }
            catch (RoleRetrievalFault e) {
                _log.warn("There is no (Site) Role " + GatewayRolesNames.INFRASTRUCTURE_MANAGER.getRoleName() + " in this Portal. Will not notify about newly user accounts.");
                return;
            }
            List managers = um.listUsersByGroupAndRole(groupId, infraManagerRoleId);
            if (managers == null || managers.isEmpty()) {
                _log.warn("There are no users with (Site) Role " + GatewayRolesNames.INFRASTRUCTURE_MANAGER.getRoleName() + " on Site " + site.getName() + ". Will not notify about newly user accounts.");
            } else {
                for (GCubeUser manager : managers) {
                    this.sendNotification(manager, user, site, siteURL);
                    _log.info("sent email to manager: " + manager.getEmail());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendNotification(GCubeUser manager, User user, Group site, String siteURL) {
        EmailNotification toSend = new EmailNotification(manager.getEmail(), "New User registration to site notification", NewUserSiteRegistrationNotificationThread.getHTMLEmail(manager.getFirstName(), user.getScreenName(), user.getFullName(), user.getEmailAddress(), site, siteURL), null);
        toSend.sendEmail();
    }

    private static String getHTMLEmail(String userFirstName, String newUserUserName, String newUserFullName, String newUserEmailAddress, Group site, String siteURL) {
        String sender = newUserFullName + " (" + newUserUserName + ") ";
        StringBuilder body = new StringBuilder();
        body.append("<body><br />").append("<div style=\"color:#000; font-size:13px; font-family:'lucida grande',tahoma,verdana,arial,sans-serif;\">").append("Dear ").append(userFirstName).append(",").append("<p>").append(sender).append(" ").append("registered to the site " + site.getName() + " with the following email: ").append(newUserEmailAddress).append("<p>You received this email because you are a Manager in this Site: ").append(siteURL).append("</p>").append("</div>").append("</body>");
        return body.toString();
    }
}

