/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.moving;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import org.gcube.common.encryption.encrypter.StringEncrypter;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.portlets.user.moving.DB_Credentials;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DatabaseConnection {
    public static final String DB_SERVICE_ENDPOINT_NAME = "MOVING-MAP-Forms";
    public static final String DB_SERVICE_ENDPOINT_CATEGORY = "Database";
    private static Log _log = LogFactoryUtil.getLog(DatabaseConnection.class);
    private static DatabaseConnection instance;
    private Connection connection;

    private DatabaseConnection(DB_Credentials dbparams) throws SQLException {
        try {
            Class.forName("org.postgresql.Driver");
            this.connection = DriverManager.getConnection(dbparams.getJDBCURL(), dbparams.getUser(), dbparams.getPwd());
        }
        catch (ClassNotFoundException ex) {
            _log.error((Object)("Database Connection Creation Failed : " + ex.getMessage()));
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public static DatabaseConnection getInstance(String context) throws Exception {
        if (instance == null || instance.getConnection().isClosed()) {
            DB_Credentials cred = DatabaseConnection.getDBCredentials((String)context);
            instance = new DatabaseConnection(cred);
            _log.info((Object)("Database Connection acquired for : " + cred.getJDBCURL()));
        }
        return instance;
    }

    private static DB_Credentials getDBCredentials(String currContext) throws Exception {
        ServiceEndpoint.AccessPoint ac = DatabaseConnection.getDBAccessPoint((String)currContext);
        DB_Credentials toReturn = new DB_Credentials();
        _log.debug((Object)("Got AccessPoint:" + ac.toString()));
        String dbAddress = ac.address();
        toReturn.setDBURL(dbAddress);
        _log.debug((Object)("DB address: " + dbAddress));
        String dbName = ac.name();
        toReturn.setDBName(dbName);
        _log.debug((Object)("DB name: " + dbName));
        String dbUser = ac.username();
        toReturn.setUser(dbUser);
        _log.debug((Object)("DB user: " + dbUser));
        String jdbcURL = new StringBuffer("jdbc:postgresql://").append(dbAddress).append("/").append(dbName).toString();
        _log.debug((Object)("jdbc.url: " + jdbcURL));
        ScopeProvider.instance.set(currContext);
        String pwd = StringEncrypter.getEncrypter().decrypt(ac.password());
        toReturn.setPwd(pwd);
        _log.debug((Object)"Decrypted Password OK");
        return toReturn;
    }

    private static ServiceEndpoint.AccessPoint getDBAccessPoint(String currContext) {
        ScopeProvider.instance.set(currContext);
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Name/text() eq 'MOVING-MAP-Forms'");
        query.addCondition("$resource/Profile/Category/text() eq 'Database'");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List conf = client.submit((Query)query);
        ServiceEndpoint res = (ServiceEndpoint)conf.get(0);
        return (ServiceEndpoint.AccessPoint)res.profile().accessPoints().iterator().next();
    }
}

