/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.moving.createaccounts;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.provider.AccessTokenProvider;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.portal.PortalContext;
import org.gcube.common.portal.mailing.templates.Template;
import org.gcube.common.storagehub.client.dsl.StorageHubClient;
import org.gcube.event.publisher.Event;
import org.gcube.portal.mailing.message.Recipient;
import org.gcube.portal.mailing.service.EmailTemplateService;
import org.gcube.portal.mailing.templates.TemplateUserApprovedRequestVRE;
import org.gcube.portal.mailing.templates.TemplateWelcomeCreatedAccount;
import org.gcube.portal.oidc.lr62.OIDCUmaUtil;
import org.gcube.portlets.user.moving.createaccounts.CreateUserAddToVre;
import org.gcube.portlets.user.moving.createaccounts.CreateUserAddToVrePublisher;
import org.gcube.vomanagement.usermanagement.exception.GroupRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.UserManagementPortalException;
import org.gcube.vomanagement.usermanagement.exception.UserManagementSystemException;
import org.gcube.vomanagement.usermanagement.exception.UserRetrievalFault;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayRoleManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeGroup;
import org.gcube.vomanagement.usermanagement.model.GCubeRole;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.gcube.vomanagement.usermanagement.model.GatewayRolesNames;

/*
 * Exception performing whole class analysis ignored.
 */
public class CreateUserAccount {
    private static Log logger = LogFactoryUtil.getLog(CreateUserAccount.class);
    private static final String INITIAL_PWD = "training1";
    public static final String DEFAULT_COMPANY_WEB_ID = "liferay.com";

    public static boolean register(HttpServletRequest httpRequest, String name, String surname, String institution, String email, boolean sendEmail, boolean isMale, Timestamp dateCreated) {
        PortalContext pContext = PortalContext.getConfiguration();
        LiferayUserManager userManager = new LiferayUserManager();
        boolean exists = userManager.userExistsByEmail(email);
        if (exists) {
            logger.debug((Object)"User with this email already present , adding the user to the VRE");
            try {
                GCubeUser theUser = userManager.getUserByEmail(email);
                userManager.assignUserToGroup(CreateUserAccount.getCurrentGroupID((HttpServletRequest)httpRequest), theUser.getUserId());
                Date dateCreatedConverted = new Date(dateCreated.getTime());
                CreateUserAccount.sendEmailToUserRegisterVRE((HttpServletRequest)httpRequest, (GCubeUser)theUser, (Date)dateCreatedConverted);
            }
            catch (GroupRetrievalFault | UserManagementPortalException | UserManagementSystemException | UserRetrievalFault e) {
                e.printStackTrace();
                return false;
            }
            return true;
        }
        logger.debug((Object)("Trying to add user: " + name + ", " + surname + ", " + email + ", " + institution));
        try {
            User user = CreateUserAccount.createLRAccount((HttpServletRequest)httpRequest, (String)name, (String)surname, (String)email, (String)institution, (boolean)sendEmail);
            logger.debug((Object)("User registered to the Site, username assigned=" + user.getScreenName()));
            int numOfTries = 0;
            do {
                logger.debug((Object)("Waiting for user-registration-hook to finish create workspace via shub for " + user.getScreenName() + ",\n attempt: " + (numOfTries + 1)));
                Thread.sleep(500L);
            } while (!CreateUserAccount.workspaceExists((String)user.getScreenName()) && ++numOfTries < 10);
            if (numOfTries >= 10) {
                logger.error((Object)("Something wrong for this user, the workspace of " + user.getScreenName() + " could not be found"));
                return false;
            }
            logger.info((Object)"Create workspace via shub has been done, proceed with user add to VRE");
            long userId = userManager.getUserId(user.getScreenName());
            logger.info((Object)"trying to send the event to create the account for this user to the orchestrator");
            long currGroupId = pContext.getCurrentGroupId(httpRequest);
            Group theVRE = GroupLocalServiceUtil.getGroup((long)currGroupId);
            new CreateUserAddToVrePublisher().publish((Event)CreateUserAddToVre.newEvent((String)user.getScreenName(), (String)name, (String)surname, (String)email, (String)"training1", (Group)theVRE));
            logger.debug((Object)"... sleeping 5 seconds");
            Thread.sleep(5000L);
            logger.debug((Object)"... now adding his user to the VRE");
            userManager.assignUserToGroup(CreateUserAccount.getCurrentGroupID((HttpServletRequest)httpRequest), userId);
            if (sendEmail) {
                CreateUserAccount.sendEmailToUserCreatedAccount((HttpServletRequest)httpRequest, (String)email, (String)(name + " " + surname));
            }
        }
        catch (Exception e) {
            logger.error((Object)("Unable to create the user " + email + ""));
            return false;
        }
        return true;
    }

    private static long getCurrentGroupID(HttpServletRequest httpRequest) {
        try {
            return PortalUtil.getScopeGroupId((HttpServletRequest)httpRequest);
        }
        catch (PortalException | SystemException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    private static User createLRAccount(HttpServletRequest httpRequest, String firstName, String lastName, String email, String institution, boolean sendEmail) {
        User toReturn = null;
        try {
            String password1;
            logger.debug((Object)("Trying createuser and instatiate serviceContext" + email));
            Long defaultCompanyId = PortalUtil.getDefaultCompanyId();
            Long defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)defaultCompanyId);
            PortalContext pContext = PortalContext.getConfiguration();
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setScopeGroupId(pContext.getCurrentGroupId(httpRequest));
            serviceContext.setPortalURL(pContext.getGatewayURL(httpRequest));
            serviceContext.setPathMain("/c");
            boolean autoPassword = false;
            Locale locale = new Locale("en_US");
            int prefixId = 0;
            int suffixId = 0;
            int birthdayMonth = 1;
            int birthdayDay = 1;
            int birthdayYear = 1970;
            String password2 = password1 = "training1";
            toReturn = UserLocalServiceUtil.addUser((long)defaultUserId, (long)defaultCompanyId, (boolean)autoPassword, (String)password1, (String)password2, (boolean)true, (String)"", (String)email, (long)0L, (String)"", (Locale)locale, (String)firstName, (String)"", (String)lastName, (int)prefixId, (int)suffixId, (boolean)true, (int)birthdayMonth, (int)birthdayDay, (int)birthdayYear, (String)institution, null, null, null, null, (boolean)false, (ServiceContext)serviceContext);
            logger.debug((Object)("Created User on LR " + lastName + " SUCCESS"));
            UserLocalServiceUtil.updateEmailAddressVerified((long)toReturn.getUserId(), (boolean)true);
            UserLocalServiceUtil.updateReminderQuery((long)toReturn.getUserId(), (String)"What was your initial password?", (String)"training1");
            logger.debug((Object)("User " + lastName + " has agreed to ToU"));
            logger.debug((Object)("User " + lastName + " has verified the Email"));
            logger.debug((Object)("User " + lastName + " updatePasswordReset & updateReminderQuery"));
        }
        catch (Exception e) {
            logger.error((Object)("Unable to create the user " + email + " in liferay."), (Throwable)e);
        }
        return toReturn;
    }

    private static boolean workspaceExists(String usernameToCheck) {
        String previousToken = SecurityTokenProvider.instance.get();
        String previousUMAToken = AccessTokenProvider.instance.get();
        boolean toReturn = false;
        try {
            logger.info((Object)("Getting super user with role " + GatewayRolesNames.INFRASTRUCTURE_MANAGER.getRoleName()));
            String infraContext = "/" + PortalContext.getConfiguration().getInfrastructureName();
            long rootgroupId = new LiferayGroupManager().getGroupIdFromInfrastructureScope(infraContext);
            User theAdmin = LiferayUserManager.getRandomUserWithRole((long)rootgroupId, (GatewayRolesNames)GatewayRolesNames.INFRASTRUCTURE_MANAGER);
            if (theAdmin == null) {
                logger.error((Object)("Cannot check if workspace exists, could not find any " + GatewayRolesNames.INFRASTRUCTURE_MANAGER + " on context: " + infraContext));
                return false;
            }
            String adminUsername = theAdmin.getScreenName();
            String theAdminToken = PortalContext.getConfiguration().getCurrentUserToken(infraContext, adminUsername);
            ArrayList<String> rolesString = new ArrayList<String>();
            List theAdminRoles = new LiferayRoleManager().listRolesByUserAndGroup(theAdmin.getUserId(), rootgroupId);
            for (GCubeRole gCubeRole : theAdminRoles) {
                rolesString.add(gCubeRole.getRoleName());
            }
            rolesString.add(GatewayRolesNames.INFRASTRUCTURE_MANAGER.getRoleName());
            logger.debug((Object)"legacy authorizationService().setTokenRoles done");
            Constants.authorizationService().setTokenRoles(theAdminToken, rolesString);
            SecurityTokenProvider.instance.set(theAdminToken);
            OIDCUmaUtil.provideConfiguredPortalClientUMATokenInThreadLocal((String)("/" + PortalContext.getConfiguration().getInfrastructureName()));
            logger.info((Object)"\nCreateUser.workspaceExists() new authorizationService PortalClient UMA-Token In ThreadLocal done\n");
            StorageHubClient shc = new StorageHubClient();
            toReturn = shc.userExists(usernameToCheck);
            logger.info((Object)("\nshub userExists(" + usernameToCheck + ") returns " + toReturn));
            AccessTokenProvider.instance.set(previousUMAToken);
            SecurityTokenProvider.instance.set(previousToken);
            return toReturn;
        }
        catch (Exception e) {
            AccessTokenProvider.instance.set(previousUMAToken);
            SecurityTokenProvider.instance.set(previousToken);
            logger.error((Object)("Cannot check if worspace exists for " + usernameToCheck), (Throwable)e);
            return false;
        }
    }

    private static void sendEmailToUserCreatedAccount(HttpServletRequest request, String email, String nameCreatedUser) {
        try {
            logger.debug((Object)("Sending welcome message to user with email " + email));
            PortalContext context = PortalContext.getConfiguration();
            String gatewayName = context.getGatewayName(request);
            String gatewayURL = context.getGatewayURL(request);
            long groupId = context.getCurrentGroupId(request);
            GCubeGroup currVRE = new LiferayGroupManager().getGroup(groupId);
            GCubeUser theManagerUser = context.getCurrentUser(request);
            String subject = "Your user account for " + currVRE.getGroupName() + " VRE has been created";
            EmailTemplateService.send((String)subject, (Template)new TemplateWelcomeCreatedAccount(gatewayName, gatewayURL, email, nameCreatedUser, theManagerUser, currVRE), (HttpServletRequest)request, (Recipient[])new Recipient[]{new Recipient(email)});
        }
        catch (Exception e) {
            logger.error((Object)("Error while sending email to user " + email), (Throwable)e);
        }
    }

    private static void sendEmailToUserRegisterVRE(HttpServletRequest request, GCubeUser theRequestingUser, Date dateCreated) {
        try {
            logger.debug((Object)("Sending welcome message to user  " + theRequestingUser.getFullname()));
            PortalContext context = PortalContext.getConfiguration();
            String gatewayName = context.getGatewayName(request);
            String gatewayURL = context.getGatewayURL(request);
            long groupId = context.getCurrentGroupId(request);
            GCubeGroup currVRE = new LiferayGroupManager().getGroup(groupId);
            GCubeUser theManagerUser = context.getCurrentUser(request);
            String subject = "MOVING EU Multi-Actor VRE has been granted";
            EmailTemplateService.send((String)subject, (Template)new TemplateUserApprovedRequestVRE(theRequestingUser, theManagerUser, currVRE, dateCreated, gatewayName, gatewayURL), (HttpServletRequest)request, (Recipient[])new Recipient[]{new Recipient(theRequestingUser.getEmail())});
        }
        catch (Exception e) {
            logger.error((Object)"Error while sending email to user ");
        }
    }
}

